/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentBuilder {
    private static final String SHADOW = "XXXXXX";
    private final StringToStringMap values;
    private List<String> args = new ArrayList<String>();
    private List<String> argsToShadow = new ArrayList<String>();
    private boolean isUnix;

    public ArgumentBuilder(StringToStringMap values) {
        this.values = values = this.escapeQuotes(values);
    }

    public List<String> getArgs() {
        if (this.isUnix) {
            StringBuffer buf = new StringBuffer();
            for (int c = 2; c < this.args.size(); ++c) {
                if (c > 2) {
                    buf.append(' ');
                }
                buf.append(this.escapeUnixArg(this.args.get(c)));
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.args.get(0));
            result.add(this.args.get(1));
            result.add(buf.toString());
            return result;
        }
        return new ArrayList<String>(this.args);
    }

    private StringToStringMap escapeQuotes(StringToStringMap values) {
        StringToStringMap map = new StringToStringMap();
        for (String key : values.keySet()) {
            String oldValue = (String)values.get(key);
            String newValue = this.internalEscapeQuotes(oldValue);
            map.put(key, newValue);
        }
        return map;
    }

    private String internalEscapeQuotes(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        block3: for (int c = 0; c < str.length(); ++c) {
            char ch = str.charAt(c);
            switch (ch) {
                case '\"': {
                    buf.append('\\').append('\"');
                    continue block3;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private String escapeUnixArg(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        block3: for (int c = 0; c < str.length(); ++c) {
            char ch = str.charAt(c);
            switch (ch) {
                case ' ': {
                    buf.append("%20");
                    continue block3;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public boolean addString(String name, String arg) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        String value = ((String)this.values.get(name)).toString();
        if (value == null || value.length() == 0) {
            return false;
        }
        if (arg != null) {
            this.args.add(arg);
        }
        this.args.add(value);
        return true;
    }

    public boolean addStrings(String name, String arg, String sep) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        String value = ((String)this.values.get(name)).toString();
        if (value == null || value.length() == 0) {
            return false;
        }
        for (String v : value.split(sep)) {
            if (arg != null) {
                this.args.add(arg);
            }
            this.args.add(v.trim());
        }
        return true;
    }

    public boolean addStringShadow(String name, String arg) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        String value = ((String)this.values.get(name)).toString();
        if (value == null || value.length() == 0) {
            return false;
        }
        if (arg != null) {
            this.args.add(arg);
        }
        this.args.add(value);
        this.argsToShadow.add(value);
        return true;
    }

    public ArgumentBuilder addArgs(String ... args) {
        for (int c = 0; c < args.length; ++c) {
            this.args.add(args[c]);
        }
        return this;
    }

    public boolean addBoolean(String name, String arg) {
        if (this.values.containsKey(name) && Boolean.valueOf(((String)this.values.get(name)).toString()).booleanValue()) {
            this.args.add(arg);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int cnt = 0; cnt < this.args.size(); ++cnt) {
            if (cnt > 0) {
                buf.append(' ');
            }
            String value = this.args.get(cnt);
            for (String argToShadow : this.argsToShadow) {
                if (value.equals(argToShadow)) {
                    value = SHADOW;
                    break;
                }
                if (!value.startsWith(argToShadow)) continue;
                value = argToShadow + SHADOW;
                break;
            }
            if (value.indexOf(45) == 0) {
                if (value.indexOf(32) > 1) {
                    buf.append(value.substring(0, 2)).append('\"').append(value.substring(2)).append('\"');
                    continue;
                }
                buf.append(value);
                continue;
            }
            if (value.indexOf(32) >= 0) {
                buf.append('\"').append(value).append('\"');
                continue;
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public ArgumentBuilder startScript(String script) {
        return this.startScript(script, ".bat", ".sh");
    }

    public boolean addString(String name, String arg, String separator) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        String value = ((String)this.values.get(name)).toString();
        if (value == null || value.length() == 0) {
            return false;
        }
        this.args.add(arg + separator + value);
        return true;
    }

    public boolean addStringShadow(String name, String arg, String separator) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        String value = ((String)this.values.get(name)).toString();
        if (value == null || value.length() == 0) {
            return false;
        }
        this.args.add(arg + separator + value);
        this.argsToShadow.add(arg + separator);
        return true;
    }

    public boolean addBoolean(String name, String arg, String trueValue, String falseValue) {
        if (!this.values.containsKey(name)) {
            return false;
        }
        this.args.add(arg);
        if (Boolean.valueOf(((String)this.values.get(name)).toString()).booleanValue()) {
            this.args.add(trueValue);
            return true;
        }
        this.args.add(falseValue);
        return false;
    }

    public ArgumentBuilder startScript(String script, String windowsExt, String unixExt) {
        if (UISupport.isWindows() && windowsExt != null) {
            this.addArgs("cmd.exe", "/C", script + windowsExt);
        } else {
            this.isUnix = true;
            if (!script.startsWith(".") && !script.startsWith(File.separator)) {
                script = "./" + script;
            }
            this.addArgs("sh", "-c", script + unixExt);
        }
        return this;
    }

    public String[] getStringArgs() {
        return this.args.toArray(new String[this.args.size()]);
    }
}

