/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.panels.request.views.html.HttpHtmlResponseView;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.panels.teststeps.HttpTestRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.sun.java.xml.ns.j2Ee.HttpMethodType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWebTestAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "AddNewWebTestAction";
    private WsdlProject project;
    public static final MessageSupport messages = MessageSupport.getMessages(CreateWebTestAction.class);
    private static final String CREATE_NEW_OPTION = "<Create New>";
    private XFormDialog dialog;
    HttpTestRequestDesktopPanel desktopPanel;
    private static final Logger logger = Logger.getLogger(CreateWebTestAction.class);

    public CreateWebTestAction() {
        super("New Web TestCase", "New Web TestCase");
    }

    @Override
    public void perform(WsdlProject target, Object param) {
        this.project = target;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        this.dialog.setOptions("Target TestSuite", ModelSupport.getNames(new String[]{CREATE_NEW_OPTION}, this.project.getTestSuiteList()));
        this.dialog.setValue("Target TestSuite", CREATE_NEW_OPTION);
        this.dialog.setValue("Web TestCase Name", "Web TestCase");
        this.dialog.setValue("Web Address", "");
        this.dialog.setValue("Start Recording immediately", Boolean.toString(true));
        if (this.dialog.show()) {
            String targetTestSuiteName = this.dialog.getValue("Target TestSuite");
            String targetTestCaseName = this.dialog.getValue("Web TestCase Name");
            while (StringUtils.isNullOrEmpty(this.dialog.getValue("Web Address"))) {
                UISupport.showErrorMessage("You must specify the web address to start at");
                this.dialog.show();
            }
            String testStepName = this.dialog.getValue("Web Address");
            String url = HttpUtils.ensureEndpointStartsWithProtocol(testStepName);
            WsdlTestSuite targetTestSuite = null;
            WsdlTestCase targetTestCase = null;
            targetTestSuite = this.project.getTestSuiteByName(targetTestSuiteName);
            if (targetTestSuite == null) {
                targetTestSuiteName = "Web TestSuite";
                while (this.project.getTestSuiteByName(targetTestSuiteName) != null) {
                    targetTestSuiteName = UISupport.prompt("TestSuite name must be unique, please specify new name for TestSuite\n[" + this.project.getName() + "->" + targetTestSuiteName + "]", "Change TestSuite name", targetTestSuiteName);
                    if (targetTestSuiteName != null) continue;
                    return;
                }
                targetTestSuite = this.project.addNewTestSuite(targetTestSuiteName);
            }
            if ((targetTestCase = targetTestSuite.getTestCaseByName(targetTestCaseName)) == null) {
                while (targetTestSuite.getTestCaseByName(targetTestCaseName) != null) {
                    targetTestCaseName = UISupport.prompt("TestCase name must be unique, please specify new name for TestCase\n[" + targetTestCaseName + "] in TestSuite [" + this.project.getName() + "->" + targetTestSuiteName + "]", "Change TestCase name", targetTestCaseName);
                    if (targetTestCaseName != null) continue;
                    return;
                }
                targetTestCase = targetTestSuite.addNewTestCase(targetTestCaseName);
            }
            while (testStepName == null || targetTestCase.getTestStepByName(testStepName) != null) {
                testStepName = UISupport.prompt("TestStep name must be unique, please specify new name for step\n[" + testStepName + "] in TestCase [" + this.project.getName() + "->" + targetTestSuiteName + "->" + targetTestCaseName + "]", "Change TestStep name", testStepName);
                if (testStepName != null) continue;
                return;
            }
            this.createWebTest(targetTestCase, HttpUtils.ensureEndpointStartsWithProtocol(url), testStepName, this.dialog.getBooleanValue("Start Recording immediately"));
        }
    }

    private void createWebTest(WsdlTestCase targetTestCase, String endpoint, String name, boolean startRecording) {
        targetTestCase.setKeepSession(true);
        HttpRequestConfig httpRequest = HttpRequestConfig.Factory.newInstance();
        httpRequest.setMethod(HttpMethodType.GET.toString());
        httpRequest.setEndpoint(endpoint);
        TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
        testStepConfig.setType("httprequest");
        testStepConfig.setConfig(httpRequest);
        testStepConfig.setName(name);
        HttpTestRequestStep testStep = (HttpTestRequestStep)targetTestCase.addTestStep(testStepConfig);
        this.desktopPanel = (HttpTestRequestDesktopPanel)UISupport.selectAndShow(testStep);
        HttpTestRequest testRequest = null;
        try {
            testRequest = testStep.getTestRequest();
            Submit submitRequest = testRequest.submit(new WsdlTestRunContext(testStep), true);
            if (startRecording) {
                ((WsdlSubmit)submitRequest).waitUntilFinished();
                HttpHtmlResponseView htmlResponseView = (HttpHtmlResponseView)this.desktopPanel.getResponseEditor().getViews().get(2);
                htmlResponseView.setRecordHttpTrafic(true);
            }
        }
        catch (Request.SubmitException e) {
            SoapUI.logError(e);
        }
        this.desktopPanel.focusResponseInTabbedView(true);
    }

    @AForm(description="Specify Web TestCase Options", name="Add Web TestCase", helpUrl="http://www.soapui.org/userguide/functional/testsuites.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="Web Address", description="The web address to start at", type=AField.AFieldType.STRING)
        public static final String URL = "Web Address";
        @AField(name="Web TestCase Name", description="The Web TestCase name", type=AField.AFieldType.STRING)
        public static final String TESTCASENAME = "Web TestCase Name";
        @AField(name="Target TestSuite", description="The target TestSuite to add WebTest to", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "Target TestSuite";
        @AField(description="", type=AField.AFieldType.BOOLEAN, enabled=true)
        public static final String STARTRECORDING = "Start Recording immediately";
    }
}

