/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.XFormMultiSelectList;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertTestSuiteLoadTestsToLoadUIAction
extends AbstractSoapUIAction<WsdlTestSuite> {
    public static final String SOAPUI_ACTION_ID = "ConvertTestSuiteLoadTestsToLoadUIAction";

    public ConvertTestSuiteLoadTestsToLoadUIAction() {
        super("Convert LoadTests to loadUI TestCases", "Select Containing LoadTest to Convert to loadUI TestCases");
    }

    @Override
    public void perform(WsdlTestSuite testSuite, Object param) {
        if (IntegrationUtils.forceSaveProject(testSuite.getProject())) {
            if (!StartLoadUI.testCajoConnection()) {
                if (UISupport.confirm("For this action you have to launch loadUI. Launch it now?", "Launch loadUI")) {
                    StartLoadUI.launchLoadUI();
                }
                return;
            }
            XFormDialog dialog = ADialogBuilder.buildDialog(TestSuiteForm.class);
            dialog.setOptions("Target Project", IntegrationUtils.getAvailableProjects());
            if (!StringUtils.isNullOrEmpty(IntegrationUtils.getOpenedProjectName())) {
                dialog.setValue("Target Project", IntegrationUtils.getOpenedProjectName());
            } else {
                dialog.setValue("Target Project", "<Create New>");
            }
            ArrayList<String> testSuiteLoadTests = new ArrayList<String>();
            for (TestCase testCase : testSuite.getTestCaseList()) {
                for (LoadTest loadTest : testCase.getLoadTestList()) {
                    testSuiteLoadTests.add(testCase.getName() + " - " + loadTest.getName());
                }
            }
            Object[] names = new String[testSuiteLoadTests.size()];
            for (int c = 0; c < names.length; ++c) {
                names[c] = (String)testSuiteLoadTests.get(c);
            }
            dialog.setOptions("Source LoadTests", names);
            if (dialog.show() && dialog.getReturnValue() == 1) {
                String loadUIProject = dialog.getValue("Target Project");
                String openedProjectName = IntegrationUtils.getOpenedProjectName();
                if (!StringUtils.isNullOrEmpty(openedProjectName) && !loadUIProject.equals(openedProjectName) && IntegrationUtils.checkOpenedLoadUIProjectForClose()) {
                    return;
                }
                String[] soapuiLoadTests = StringUtils.toStringArray(((XFormMultiSelectList)dialog.getFormField("Source LoadTests")).getSelectedOptions());
                if (soapuiLoadTests.length == 0) {
                    UISupport.showErrorMessage("No LoadTests selected.");
                    return;
                }
                try {
                    IntegrationUtils.exportMultipleLoadTestToLoadUI(testSuite, soapuiLoadTests, loadUIProject);
                }
                catch (IOException e) {
                    UISupport.showInfoMessage("Error while opening selected loadUI project");
                    return;
                }
            }
        }
    }

    @AForm(description="Specify target loadUI Project and select LoadTests to convert", name="Convert multiple LoadTests to loadUI", helpUrl="http://www.soapui.org/userguide/functional/testsuites.html", icon="/convertLoadTestToLoadUI.png")
    public static interface TestSuiteForm {
        @AField(name="Target Project", description="The target loadUI Project to add to", type=AField.AFieldType.ENUMERATION)
        public static final String LOADUIPROJECT = "Target Project";
        @AField(name="Source LoadTests", description="The LoadTests to convert", type=AField.AFieldType.MULTILIST)
        public static final String LOADTESTS = "Source LoadTests";
    }
}

