/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testsuite;

import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.XFormMultiSelectList;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateLoadUITestsAction
extends AbstractSoapUIAction<WsdlTestSuite> {
    public static final String SOAPUI_ACTION_ID = "GenerateLoadUITestsAction";
    private WsdlTestSuite testSuite;

    public GenerateLoadUITestsAction() {
        super("Generate loadUI Tests", "Select contained TestCases to run with loadUI");
    }

    @Override
    public void perform(WsdlTestSuite testSuite, Object param) {
        if (IntegrationUtils.forceSaveProject(testSuite.getProject())) {
            if (!StartLoadUI.testCajoConnection()) {
                if (UISupport.confirm("For this action you have to launch loadUI. Launch it now?", "Launch loadUI")) {
                    StartLoadUI.launchLoadUI();
                }
                return;
            }
            this.testSuite = testSuite;
            String soapUITestSuite = testSuite.getName();
            String soapUIProjectPath = testSuite.getProject().getPath();
            XFormDialog dialog = ADialogBuilder.buildDialog(Form.class);
            dialog.setOptions("Target Project", IntegrationUtils.getAvailableProjects());
            if (!StringUtils.isNullOrEmpty(IntegrationUtils.getOpenedProjectName())) {
                dialog.setValue("Target Project", IntegrationUtils.getOpenedProjectName());
            } else {
                dialog.setValue("Target Project", "<Create New>");
            }
            dialog.setOptions("Source TestCases", ModelSupport.getNames(testSuite.getTestCaseList()));
            dialog.setValue("Level", "Project Level");
            if (dialog.show() && dialog.getReturnValue() == 1) {
                int levelToAdd = dialog.getValueIndex("Level");
                String loadUIProject = dialog.getValue("Target Project");
                String openedProjectName = IntegrationUtils.getOpenedProjectName();
                if (!StringUtils.isNullOrEmpty(openedProjectName) && !loadUIProject.equals(openedProjectName) && IntegrationUtils.checkOpenedLoadUIProjectForClose()) {
                    return;
                }
                String[] soapuiTestCases = StringUtils.toStringArray(((XFormMultiSelectList)dialog.getFormField("Source TestCases")).getSelectedOptions());
                if (soapuiTestCases.length == 0) {
                    UISupport.showErrorMessage("No TestCases selected.");
                    return;
                }
                try {
                    IntegrationUtils.generateTestSuiteLoadTests(soapUIProjectPath, soapUITestSuite, soapuiTestCases, loadUIProject, levelToAdd);
                }
                catch (IOException e) {
                    UISupport.showInfoMessage("Error while opening selected loadUI project");
                    return;
                }
            }
        }
    }

    @AForm(description="Specify target loadUI Project, select TestCases to add and the loadUI level to add them to", name="Add multiple TestCases to loadUI", helpUrl="http://www.soapui.org/userguide/functional/testsuites.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="Target Project", description="The target loadUI Project to add to", type=AField.AFieldType.ENUMERATION)
        public static final String LOADUIPROJECT = "Target Project";
        @AField(name="Source TestCases", description="The TestCases to add", type=AField.AFieldType.MULTILIST)
        public static final String TESTCASES = "Source TestCases";
        @AField(name="Level", description="Select the level where to add Samplers", type=AField.AFieldType.RADIOGROUP, values={"Project Level", "Single TestCase ", "Separate TestCases"})
        public static final String LEVEL = "Level";
    }
}

