/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadStrategyConfig;
import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestListener;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.LoadTestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogErrorEntry;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.BurstLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyRegistry;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.SimplePathPropertySupport;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.list.TreeList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlLoadTest
extends AbstractWsdlModelItem<LoadTestConfig>
implements LoadTest,
TestRunnable {
    public static final String THREADCOUNT_PROPERTY = WsdlLoadTest.class.getName() + "@threadcount";
    public static final String STARTDELAY_PROPERTY = WsdlLoadTest.class.getName() + "@startdelay";
    public static final String TESTLIMIT_PROPERTY = WsdlLoadTest.class.getName() + "@testlimit";
    public static final String HISTORYLIMIT_PROPERTY = WsdlLoadTest.class.getName() + "@historylimit";
    public static final String LIMITTYPE_PROPERRY = WsdlLoadTest.class.getName() + "@limittype";
    public static final String SAMPLEINTERVAL_PROPERRY = WsdlLoadTest.class.getName() + "@sample-interval";
    public static final String MAXASSERTIONERRORS_PROPERTY = WsdlLoadTest.class.getName() + "@max-assertion-errors";
    public static final String SETUP_SCRIPT_PROPERTY = WsdlTestCase.class.getName() + "@setupScript";
    public static final String TEARDOWN_SCRIPT_PROPERTY = WsdlTestCase.class.getName() + "@tearDownScript";
    private static final Logger logger = Logger.getLogger(WsdlLoadTest.class);
    public static final int DEFAULT_STRATEGY_INTERVAL = 500;
    private InternalTestRunListener internalTestRunListener = new InternalTestRunListener();
    private WsdlTestCase testCase;
    private LoadTestStatistics statisticsModel;
    private LoadStrategy loadStrategy = new BurstLoadStrategy(this);
    private LoadTestLog loadTestLog;
    private LoadStrategyConfigurationChangeListener loadStrategyListener = new LoadStrategyConfigurationChangeListener();
    private List<LoadTestAssertion> assertions = new ArrayList<LoadTestAssertion>();
    private ConfigurationChangePropertyListener configurationChangeListener = new ConfigurationChangePropertyListener();
    private Set<LoadTestListener> loadTestListeners = new HashSet<LoadTestListener>();
    private Set<LoadTestRunListener> loadTestRunListeners = new HashSet<LoadTestRunListener>();
    private List<LoadTestLogErrorEntry> assertionErrors = new TreeList();
    private WsdlLoadTestRunner runner;
    private StatisticsLogger statisticsLogger = new StatisticsLogger();
    private SoapUIScriptEngine setupScriptEngine;
    private SoapUIScriptEngine tearDownScriptEngine;
    private SimplePathPropertySupport logFolder;
    private LoadTestRunListener[] loadTestRunListenersArray;

    public WsdlLoadTest(WsdlTestCase testCase, LoadTestConfig config) {
        super(config, testCase, "/loadTest.gif");
        LoadStrategyFactory factory;
        this.testCase = testCase;
        if (((LoadTestConfig)this.getConfig()).getThreadCount() < 1) {
            ((LoadTestConfig)this.getConfig()).setThreadCount(5);
        }
        if (((LoadTestConfig)this.getConfig()).getLimitType() == null) {
            ((LoadTestConfig)this.getConfig()).setLimitType(LoadTestLimitTypesConfig.TIME);
            ((LoadTestConfig)this.getConfig()).setTestLimit(60L);
        }
        if (!((LoadTestConfig)this.getConfig()).isSetHistoryLimit()) {
            ((LoadTestConfig)this.getConfig()).setHistoryLimit(-1L);
        }
        this.addLoadTestRunListener(this.internalTestRunListener);
        LoadStrategyConfig ls = ((LoadTestConfig)this.getConfig()).getLoadStrategy();
        if (ls == null) {
            ls = ((LoadTestConfig)this.getConfig()).addNewLoadStrategy();
            ls.setType("Simple");
        }
        if ((factory = LoadStrategyRegistry.getInstance().getFactory(ls.getType())) == null) {
            ls.setType("Simple");
            factory = LoadStrategyRegistry.getInstance().getFactory(ls.getType());
        }
        this.loadStrategy = factory.build(ls.getConfig(), this);
        this.loadStrategy.addConfigurationChangeListener(this.loadStrategyListener);
        this.addLoadTestRunListener(this.loadStrategy);
        this.statisticsModel = new LoadTestStatistics(this);
        if (((LoadTestConfig)this.getConfig()).xgetSampleInterval() == null) {
            this.setSampleInterval(250);
        }
        this.statisticsModel.setUpdateFrequency(this.getSampleInterval());
        List<LoadTestAssertionConfig> assertionList = ((LoadTestConfig)this.getConfig()).getAssertionList();
        for (LoadTestAssertionConfig assertionConfig : assertionList) {
            AbstractLoadTestAssertion assertion = LoadTestAssertionRegistry.buildAssertion(assertionConfig, this);
            if (assertion != null) {
                this.assertions.add(assertion);
                assertion.addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this.configurationChangeListener);
                continue;
            }
            logger.warn((Object)("Failed to build LoadTestAssertion from getConfig() [" + assertionConfig + "]"));
        }
        if (((LoadTestConfig)this.getConfig()).xgetResetStatisticsOnThreadCountChange() == null) {
            ((LoadTestConfig)this.getConfig()).setResetStatisticsOnThreadCountChange(true);
        }
        if (((LoadTestConfig)this.getConfig()).xgetCalculateTPSOnTimePassed() == null) {
            ((LoadTestConfig)this.getConfig()).setCalculateTPSOnTimePassed(true);
        }
        if (!((LoadTestConfig)this.getConfig()).isSetMaxAssertionErrors()) {
            ((LoadTestConfig)this.getConfig()).setMaxAssertionErrors(100L);
        }
        if (((LoadTestConfig)this.getConfig()).xgetCancelExcessiveThreads() == null) {
            ((LoadTestConfig)this.getConfig()).setCancelExcessiveThreads(true);
        }
        if (((LoadTestConfig)this.getConfig()).xgetStrategyInterval() == null) {
            ((LoadTestConfig)this.getConfig()).setStrategyInterval(500);
        }
        this.loadTestLog = new LoadTestLog(this);
        for (LoadTestRunListener listener : SoapUI.getListenerRegistry().getListeners(LoadTestRunListener.class)) {
            this.addLoadTestRunListener(listener);
        }
        if (!this.getSettings().isSet(HttpSettings.CLOSE_CONNECTIONS)) {
            this.getSettings().setBoolean(HttpSettings.CLOSE_CONNECTIONS, SoapUI.getSettings().getBoolean(HttpSettings.CLOSE_CONNECTIONS));
        }
    }

    public LoadTestStatistics getStatisticsModel() {
        return this.statisticsModel;
    }

    public StatisticsLogger getStatisticsLogger() {
        return this.statisticsLogger;
    }

    public long getThreadCount() {
        return ((LoadTestConfig)this.getConfig()).getThreadCount();
    }

    public void setThreadCount(long threadCount) {
        long oldCount = this.getThreadCount();
        if (threadCount == oldCount) {
            return;
        }
        if (this.getLogStatisticsOnThreadChange() && this.isRunning()) {
            this.statisticsLogger.logStatistics("ThreadCount change from " + oldCount + " to " + threadCount);
        }
        ((LoadTestConfig)this.getConfig()).setThreadCount((int)threadCount);
        this.notifyPropertyChanged(THREADCOUNT_PROPERTY, oldCount, threadCount);
    }

    public boolean getResetStatisticsOnThreadCountChange() {
        return ((LoadTestConfig)this.getConfig()).getResetStatisticsOnThreadCountChange();
    }

    public void setResetStatisticsOnThreadCountChange(boolean value) {
        ((LoadTestConfig)this.getConfig()).setResetStatisticsOnThreadCountChange(value);
    }

    public boolean getCancelOnReachedLimit() {
        return ((LoadTestConfig)this.getConfig()).getCancelOnReachedLimit();
    }

    public void setCancelOnReachedLimit(boolean value) {
        ((LoadTestConfig)this.getConfig()).setCancelOnReachedLimit(value);
    }

    public boolean getCancelExcessiveThreads() {
        return ((LoadTestConfig)this.getConfig()).getCancelExcessiveThreads();
    }

    public void setCancelExcessiveThreads(boolean value) {
        ((LoadTestConfig)this.getConfig()).setCancelExcessiveThreads(value);
    }

    public boolean getLogStatisticsOnThreadChange() {
        return ((LoadTestConfig)this.getConfig()).getLogStatisticsOnThreadChange();
    }

    public void setLogStatisticsOnThreadChange(boolean value) {
        ((LoadTestConfig)this.getConfig()).setLogStatisticsOnThreadChange(value);
    }

    public String getStatisticsLogFolder() {
        return ((LoadTestConfig)this.getConfig()).getStatisticsLogFolder();
    }

    public void setStatisticsLogFolder(String value) {
        ((LoadTestConfig)this.getConfig()).setStatisticsLogFolder(value);
    }

    public boolean getCalculateTPSOnTimePassed() {
        return ((LoadTestConfig)this.getConfig()).getCalculateTPSOnTimePassed();
    }

    public void setCalculateTPSOnTimePassed(boolean value) {
        ((LoadTestConfig)this.getConfig()).setCalculateTPSOnTimePassed(value);
    }

    public int getStartDelay() {
        return ((LoadTestConfig)this.getConfig()).getStartDelay();
    }

    public void setStartDelay(int startDelay) {
        if (startDelay < 0) {
            return;
        }
        int oldDelay = this.getStartDelay();
        ((LoadTestConfig)this.getConfig()).setStartDelay(startDelay);
        this.notifyPropertyChanged(STARTDELAY_PROPERTY, oldDelay, startDelay);
    }

    public long getHistoryLimit() {
        return ((LoadTestConfig)this.getConfig()).getHistoryLimit();
    }

    public void setHistoryLimit(long historyLimit) {
        long oldLimit = this.getHistoryLimit();
        ((LoadTestConfig)this.getConfig()).setHistoryLimit(historyLimit);
        if (historyLimit == 0L) {
            this.notifyPropertyChanged(HISTORYLIMIT_PROPERTY, oldLimit, historyLimit);
        }
    }

    public long getTestLimit() {
        return ((LoadTestConfig)this.getConfig()).getTestLimit();
    }

    public void setTestLimit(long testLimit) {
        if (testLimit < 0L) {
            return;
        }
        long oldLimit = this.getTestLimit();
        ((LoadTestConfig)this.getConfig()).setTestLimit(testLimit);
        this.notifyPropertyChanged(TESTLIMIT_PROPERTY, oldLimit, testLimit);
    }

    public long getMaxAssertionErrors() {
        return ((LoadTestConfig)this.getConfig()).getMaxAssertionErrors();
    }

    public void setMaxAssertionErrors(long testLimit) {
        if (testLimit < 0L) {
            return;
        }
        long oldLimit = this.getMaxAssertionErrors();
        ((LoadTestConfig)this.getConfig()).setMaxAssertionErrors(testLimit);
        this.notifyPropertyChanged(MAXASSERTIONERRORS_PROPERTY, oldLimit, testLimit);
    }

    public long getStatisticsLogInterval() {
        return ((LoadTestConfig)this.getConfig()).getStatisticsLogInterval();
    }

    public void setStatisticsLogInterval(int sampleInterval) {
        if (sampleInterval < 0) {
            return;
        }
        long oldInterval = this.getStatisticsLogInterval();
        ((LoadTestConfig)this.getConfig()).setStatisticsLogInterval(sampleInterval);
        this.notifyPropertyChanged(SAMPLEINTERVAL_PROPERRY, oldInterval, (Object)sampleInterval);
        if (oldInterval == 0L && sampleInterval > 0 && this.isRunning()) {
            this.statisticsLogger.start();
        }
    }

    public long getSampleInterval() {
        return ((LoadTestConfig)this.getConfig()).getSampleInterval();
    }

    public void setSampleInterval(int sampleInterval) {
        if (sampleInterval < 0) {
            return;
        }
        long oldInterval = this.getSampleInterval();
        ((LoadTestConfig)this.getConfig()).setSampleInterval(sampleInterval);
        this.statisticsModel.setUpdateFrequency(sampleInterval);
        this.notifyPropertyChanged(SAMPLEINTERVAL_PROPERRY, oldInterval, (Object)sampleInterval);
    }

    public LoadTestLimitTypesConfig.Enum getLimitType() {
        return ((LoadTestConfig)this.getConfig()).getLimitType();
    }

    public void setLimitType(LoadTestLimitTypesConfig.Enum limitType) {
        if (limitType == null) {
            return;
        }
        LoadTestLimitTypesConfig.Enum oldType = this.getLimitType();
        ((LoadTestConfig)this.getConfig()).setLimitType(limitType);
        this.notifyPropertyChanged(LIMITTYPE_PROPERRY, (Object)oldType, (Object)limitType);
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public synchronized WsdlLoadTestRunner run() {
        this.getStatisticsModel().reset();
        if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
            return null;
        }
        if (this.runner != null) {
            this.runner.release();
        }
        this.assertionErrors.clear();
        this.runner = new WsdlLoadTestRunner(this);
        this.runner.start();
        return this.runner;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy.removeConfigurationChangeListener(this.loadStrategyListener);
        this.removeLoadTestRunListener(this.loadStrategy);
        this.loadStrategy = loadStrategy;
        this.loadStrategy.addConfigurationChangeListener(this.loadStrategyListener);
        this.addLoadTestRunListener(this.loadStrategy);
        ((LoadTestConfig)this.getConfig()).getLoadStrategy().setType(loadStrategy.getType());
        ((LoadTestConfig)this.getConfig()).getLoadStrategy().setConfig(loadStrategy.getConfig());
    }

    public LoadTestAssertion addAssertion(String type, String targetStep, boolean showConfig) {
        LoadTestAssertion assertion = LoadTestAssertionRegistry.createAssertion(type, this);
        assertion.setTargetStep(targetStep);
        if (assertion instanceof Configurable && showConfig && !((Configurable)((Object)assertion)).configure()) {
            return null;
        }
        this.assertions.add(assertion);
        ((LoadTestConfig)this.getConfig()).addNewAssertion().set(assertion.getConfiguration());
        assertion.addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this.configurationChangeListener);
        this.fireAssertionAdded(assertion);
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssertion(LoadTestAssertion assertion) {
        int ix = this.assertions.indexOf(assertion);
        if (ix >= 0) {
            try {
                this.assertions.remove(ix);
                this.fireAssertionRemoved(assertion);
            }
            finally {
                assertion.removePropertyChangeListener(this.configurationChangeListener);
                assertion.release();
                ((LoadTestConfig)this.getConfig()).removeAssertion(ix);
            }
        }
    }

    private void fireAssertionRemoved(LoadTestAssertion assertion) {
        if (!this.loadTestListeners.isEmpty()) {
            LoadTestListener[] l;
            for (LoadTestListener listener : l = this.loadTestListeners.toArray(new LoadTestListener[this.loadTestListeners.size()])) {
                listener.assertionRemoved(assertion);
            }
        }
    }

    private void fireAssertionAdded(LoadTestAssertion assertion) {
        if (!this.loadTestListeners.isEmpty()) {
            LoadTestListener[] l;
            for (LoadTestListener listener : l = this.loadTestListeners.toArray(new LoadTestListener[this.loadTestListeners.size()])) {
                listener.assertionAdded(assertion);
            }
        }
    }

    public int getAssertionCount() {
        return this.assertions.size();
    }

    public LoadTestAssertion getAssertionAt(int index) {
        return index < 0 || index >= this.assertions.size() ? null : this.assertions.get(index);
    }

    public LoadTestAssertion getAssertionByName(String name) {
        for (LoadTestAssertion assertion : this.assertions) {
            if (!assertion.getName().equals(name)) continue;
            return assertion;
        }
        return null;
    }

    public LoadTestLog getLoadTestLog() {
        return this.loadTestLog;
    }

    public List<LoadTestAssertion> getAssertionList() {
        return this.assertions;
    }

    public void addLoadTestListener(LoadTestListener listener) {
        this.loadTestListeners.add(listener);
    }

    public void removeLoadTestListener(LoadTestListener listener) {
        this.loadTestListeners.remove(listener);
    }

    @Override
    public void addLoadTestRunListener(LoadTestRunListener listener) {
        this.loadTestRunListeners.add(listener);
        this.loadTestRunListenersArray = null;
    }

    @Override
    public void removeLoadTestRunListener(LoadTestRunListener listener) {
        this.loadTestRunListeners.remove(listener);
        this.loadTestRunListenersArray = null;
    }

    public LoadTestRunListener[] getLoadTestRunListeners() {
        if (this.loadTestRunListenersArray == null) {
            this.loadTestRunListenersArray = this.loadTestRunListeners.toArray(new LoadTestRunListener[this.loadTestRunListeners.size()]);
        }
        return this.loadTestRunListenersArray;
    }

    @Override
    public void release() {
        super.release();
        this.statisticsModel.release();
        this.loadTestLog.release();
        for (LoadTestAssertion assertion : this.assertions) {
            assertion.release();
        }
        this.loadTestRunListeners.clear();
        this.loadTestListeners.clear();
    }

    public boolean isRunning() {
        return this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING;
    }

    public WsdlLoadTestRunner getRunner() {
        return this.runner;
    }

    public void resetConfigOnMove(LoadTestConfig config) {
        this.setConfig(config);
        this.loadStrategy.updateConfig(config.getLoadStrategy().getConfig());
        List<LoadTestAssertionConfig> assertionList = config.getAssertionList();
        for (int c = 0; c < assertionList.size(); ++c) {
            this.assertions.get(c).updateConfiguration(assertionList.get(c));
        }
    }

    public void setSetupScript(String script) {
        String oldScript = this.getSetupScript();
        if (!((LoadTestConfig)this.getConfig()).isSetSetupScript()) {
            ((LoadTestConfig)this.getConfig()).addNewSetupScript();
        }
        ((LoadTestConfig)this.getConfig()).getSetupScript().setStringValue(script);
        if (this.setupScriptEngine != null) {
            this.setupScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(SETUP_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getSetupScript() {
        return ((LoadTestConfig)this.getConfig()).isSetSetupScript() ? ((LoadTestConfig)this.getConfig()).getSetupScript().getStringValue() : null;
    }

    public void setTearDownScript(String script) {
        String oldScript = this.getTearDownScript();
        if (!((LoadTestConfig)this.getConfig()).isSetTearDownScript()) {
            ((LoadTestConfig)this.getConfig()).addNewTearDownScript();
        }
        ((LoadTestConfig)this.getConfig()).getTearDownScript().setStringValue(script);
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(TEARDOWN_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getTearDownScript() {
        return ((LoadTestConfig)this.getConfig()).isSetTearDownScript() ? ((LoadTestConfig)this.getConfig()).getTearDownScript().getStringValue() : null;
    }

    public Object runSetupScript(LoadTestRunContext runContext, LoadTestRunner runner) throws Exception {
        String script = this.getSetupScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.setupScriptEngine == null) {
            this.setupScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.setupScriptEngine.setScript(script);
        }
        this.setupScriptEngine.setVariable("context", runContext);
        this.setupScriptEngine.setVariable("loadTestRunner", runner);
        this.setupScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.setupScriptEngine.run();
    }

    public Object runTearDownScript(LoadTestRunContext runContext, LoadTestRunner runner) throws Exception {
        String script = this.getTearDownScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.tearDownScriptEngine == null) {
            this.tearDownScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.tearDownScriptEngine.setScript(script);
        }
        this.tearDownScriptEngine.setVariable("context", runContext);
        this.tearDownScriptEngine.setVariable("loadTestRunner", runner);
        this.tearDownScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.tearDownScriptEngine.run();
    }

    public int getStrategyInterval() {
        return ((LoadTestConfig)this.getConfig()).getStrategyInterval();
    }

    public void setStrategyInterval(int interval) {
        ((LoadTestConfig)this.getConfig()).setStrategyInterval(interval);
    }

    public boolean getUpdateStatisticsPerTestStep() {
        return ((LoadTestConfig)this.getConfig()).getUpdateStatisticsPerTestStep();
    }

    public void setUpdateStatisticsPerTestStep(boolean updateStatisticsPerTestStep) {
        ((LoadTestConfig)this.getConfig()).setUpdateStatisticsPerTestStep(updateStatisticsPerTestStep);
    }

    @Override
    public TestRunner run(StringToObjectMap context, boolean async) {
        return null;
    }

    public class StatisticsLogger
    implements Runnable {
        private boolean stopped;
        private List<PrintWriter> writers = new ArrayList<PrintWriter>();
        private long startTime;

        public void run() {
            this.stopped = false;
            while (!this.stopped && WsdlLoadTest.this.getStatisticsLogInterval() > 0L) {
                try {
                    long statisticsInterval = WsdlLoadTest.this.getStatisticsLogInterval();
                    Thread.sleep(statisticsInterval);
                    if (this.stopped) continue;
                    this.logStatistics("Interval");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void start() {
            new Thread((Runnable)this, "Statistics Logger for LoadTest [" + WsdlLoadTest.this.getName() + "]").start();
        }

        public void init(LoadTestRunContext context) {
            this.writers.clear();
            String statisticsLogFolder = context.expand(WsdlLoadTest.this.getStatisticsLogFolder());
            if (StringUtils.isNullOrEmpty(statisticsLogFolder)) {
                return;
            }
            File folder = new File(statisticsLogFolder);
            if (!folder.exists() && !folder.mkdirs()) {
                SoapUI.logError(new Exception("Failed to create statistics log folder [" + statisticsLogFolder + "]"));
                return;
            }
            for (int c = 0; c < WsdlLoadTest.this.testCase.getTestStepCount(); ++c) {
                try {
                    WsdlTestStep testStep = WsdlLoadTest.this.testCase.getTestStepAt(c);
                    String fileName = StringUtils.createFileName(testStep.getName(), '_') + ".log";
                    PrintWriter writer = new PrintWriter(new File(folder, fileName));
                    this.writers.add(writer);
                    this.addHeaders(writer);
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.writers.add(null);
                }
            }
            try {
                String fileName = StringUtils.createFileName(WsdlLoadTest.this.testCase.getName(), '_') + ".log";
                this.writers.add(new PrintWriter(new File(folder, fileName)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.startTime = System.nanoTime();
        }

        private void addHeaders(PrintWriter writer) {
            writer.print("date,threads,elapsed,min,max,avg,last,cnt,tps,bytes,bps,err,reason\n");
        }

        public void finish() {
            this.stopped = true;
            this.logStatistics("Finished");
            for (PrintWriter writer : this.writers) {
                if (writer == null) continue;
                writer.close();
            }
        }

        private synchronized void logStatistics(String trigger) {
            if (this.writers.isEmpty()) {
                return;
            }
            long timestamp = System.nanoTime();
            String elapsedString = String.valueOf((timestamp - this.startTime) / 1000000L);
            String dateString = new Date().toString();
            String threadCountString = String.valueOf(WsdlLoadTest.this.getThreadCount());
            StringList[] snapshot = WsdlLoadTest.this.statisticsModel.getSnapshot();
            for (int c = 0; c < snapshot.length; ++c) {
                PrintWriter writer = this.writers.get(c);
                if (writer == null) continue;
                StringList values = snapshot[c];
                writer.append(dateString).append(',');
                writer.append(threadCountString).append(',');
                writer.append(elapsedString);
                for (String value : values) {
                    writer.append(',').append(value);
                }
                writer.append(',').append(trigger).append('\n');
                writer.flush();
            }
        }
    }

    private class ConfigurationChangePropertyListener
    implements PropertyChangeListener {
        private ConfigurationChangePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int ix = WsdlLoadTest.this.assertions.indexOf(evt.getSource());
            if (ix >= 0) {
                ((LoadTestConfig)WsdlLoadTest.this.getConfig()).getAssertionArray(ix).set(((LoadTestAssertion)WsdlLoadTest.this.assertions.get(ix)).getConfiguration());
            }
        }
    }

    private class LoadStrategyConfigurationChangeListener
    implements PropertyChangeListener {
        private LoadStrategyConfigurationChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ((LoadTestConfig)WsdlLoadTest.this.getConfig()).getLoadStrategy().setConfig(WsdlLoadTest.this.loadStrategy.getConfig());
        }
    }

    private class InternalTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            WsdlLoadTest.this.statisticsLogger.finish();
        }

        public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            WsdlLoadTest.this.statisticsLogger.init(context);
            if (WsdlLoadTest.this.getStatisticsLogInterval() > 0L) {
                WsdlLoadTest.this.statisticsLogger.start();
            }
        }

        public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (!WsdlLoadTest.this.assertions.isEmpty()) {
                for (LoadTestAssertion assertion : WsdlLoadTest.this.assertions) {
                    String error = assertion.assertResults(loadTestRunner, context, testRunner, runContext);
                    if (error == null) continue;
                    int threadIndex = 0;
                    try {
                        threadIndex = Integer.parseInt(runContext.getProperty("ThreadIndex").toString());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    WsdlLoadTest.this.loadTestLog.addEntry(new LoadTestLogErrorEntry(assertion.getName(), error, assertion.getIcon(), threadIndex));
                    WsdlLoadTest.this.statisticsModel.addError(-1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            boolean added = false;
            if (!WsdlLoadTest.this.assertions.isEmpty()) {
                for (LoadTestAssertion assertion : WsdlLoadTest.this.assertions) {
                    String error = assertion.assertResult(loadTestRunner, context, result, testRunner, runContext);
                    if (error == null) continue;
                    int indexOfTestStep = testRunner.getTestCase().getIndexOfTestStep(result.getTestStep());
                    int threadIndex = 0;
                    try {
                        threadIndex = Integer.parseInt(runContext.getProperty("ThreadIndex").toString());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    LoadTestLogErrorEntry errorEntry = new LoadTestLogErrorEntry(assertion.getName(), error, result, assertion.getIcon(), threadIndex);
                    WsdlLoadTest.this.loadTestLog.addEntry(errorEntry);
                    WsdlLoadTest.this.statisticsModel.addError(indexOfTestStep);
                    long maxAssertionErrors = WsdlLoadTest.this.getMaxAssertionErrors();
                    if (maxAssertionErrors > 0L) {
                        List list = WsdlLoadTest.this.assertionErrors;
                        synchronized (list) {
                            WsdlLoadTest.this.assertionErrors.add(errorEntry);
                            while ((long)WsdlLoadTest.this.assertionErrors.size() > maxAssertionErrors) {
                                ((LoadTestLogErrorEntry)WsdlLoadTest.this.assertionErrors.remove(0)).discard();
                            }
                        }
                    }
                    added = true;
                }
            }
            if (!added) {
                if (WsdlLoadTest.this.getTestCase().getDiscardOkResults() || WsdlLoadTest.this.getTestCase().getMaxResults() == 0) {
                    result.discard();
                } else if (WsdlLoadTest.this.getTestCase().getMaxResults() > 0 && testRunner instanceof WsdlTestCaseRunner) {
                    ((WsdlTestCaseRunner)testRunner).enforceMaxResults(WsdlLoadTest.this.getTestCase().getMaxResults());
                }
            }
        }
    }
}

