/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MockRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MultipartMessageSupport;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockRequest
implements MockRequest {
    private StringToStringsMap requestHeaders;
    private String requestContent;
    private MultipartMessageSupport mmSupport;
    private XmlObject requestXmlObject;
    private SoapVersion soapVersion;
    private final HttpServletResponse response;
    private String protocol;
    private String path;
    private String soapAction;
    private final WsdlMockRunContext context;
    private final WsdlMockRunContext requestContext;
    private final HttpServletRequest request;
    private Vector<Object> wssResult;
    private MockRequestDataSource mockRequestDataSource;
    private String actualRequestContent;
    private boolean responseMessage;
    private String method;

    public WsdlMockRequest(HttpServletRequest request, HttpServletResponse response, WsdlMockRunContext context) throws Exception {
        this.request = request;
        this.response = response;
        this.context = context;
        this.requestContext = new WsdlMockRunContext(context.getMockService(), null);
        this.requestHeaders = new StringToStringsMap();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String lcHeader = header.toLowerCase();
            if (lcHeader.equals("soapaction")) {
                this.requestHeaders.put("SOAPAction", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-type")) {
                this.requestHeaders.put("Content-Type", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-length")) {
                this.requestHeaders.put("Content-Length", request.getHeader(header));
                continue;
            }
            if (lcHeader.equals("content-encoding")) {
                this.requestHeaders.put("Content-Encoding", request.getHeader(header));
                continue;
            }
            this.requestHeaders.put(header, request.getHeader(header));
        }
        this.protocol = request.getProtocol();
        this.path = request.getPathInfo();
        if (this.path == null) {
            this.path = "";
        }
        if (request.getMethod().equals("POST")) {
            this.initPostRequest(request, context);
        }
    }

    protected void initPostRequest(HttpServletRequest request, WsdlMockRunContext context) throws Exception {
        String contentType = request.getContentType();
        if (contentType != null && contentType.toUpperCase().startsWith("MULTIPART")) {
            this.readMultipartRequest(request);
            if (this.mmSupport != null && this.mmSupport.getRootPart() != null) {
                contentType = this.mmSupport.getRootPart().getContentType();
            }
        } else {
            IncomingWss incoming;
            this.requestContent = this.readRequestContent(request);
            if (StringUtils.hasContent(context.getMockService().getIncomingWss()) && (incoming = context.getMockService().getProject().getWssContainer().getIncomingWssByName(context.getMockService().getIncomingWss())) != null) {
                Document dom = XmlUtils.parseXml(this.requestContent);
                try {
                    this.wssResult = incoming.processIncoming(dom, context);
                    if (this.wssResult != null && this.wssResult.size() > 0) {
                        StringWriter writer = new StringWriter();
                        XmlUtils.serialize(dom, (Writer)writer);
                        this.actualRequestContent = this.requestContent;
                        this.requestContent = writer.toString();
                    }
                }
                catch (Exception e) {
                    if (this.wssResult == null) {
                        this.wssResult = new Vector();
                    }
                    this.wssResult.add(e);
                }
            }
        }
        try {
            this.soapVersion = SoapUtils.deduceSoapVersion(contentType, this.getRequestXmlObject());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.soapVersion == null) {
            this.soapVersion = SoapVersion.Soap11;
        }
        this.soapAction = SoapUtils.getSoapAction(this.soapVersion, this.requestHeaders);
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public Vector<?> getWssResult() {
        return this.wssResult;
    }

    private void readMultipartRequest(HttpServletRequest request) throws MessagingException {
        StringToStringMap values = StringToStringMap.fromHttpHeader(request.getContentType());
        this.mockRequestDataSource = new MockRequestDataSource(request);
        this.mmSupport = new MultipartMessageSupport(this.mockRequestDataSource, (String)values.get("start"), null, true, this.requestContext.getMockService().getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES));
    }

    private String readRequestContent(HttpServletRequest request) throws Exception {
        String compressionAlg;
        ServletInputStream is;
        String messageContent = null;
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            encoding = StringUtils.unquote(encoding);
        }
        if ((is = request.getInputStream()).markSupported() && request.getContentLength() > 0) {
            is.mark(request.getContentLength());
        }
        ByteArrayOutputStream out = Tools.readAll((InputStream)is, 0L);
        byte[] data = out.toByteArray();
        if (is.markSupported() && request.getContentLength() > 0) {
            try {
                is.reset();
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }
        if ((compressionAlg = HttpClientSupport.getCompressionType(request.getContentType(), this.requestHeaders.get("Content-Encoding", (String)null))) != null) {
            try {
                data = CompressionSupport.decompress(compressionAlg, data);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Decompression of response failed");
                ioe.initCause(e);
                throw ioe;
            }
        }
        int contentOffset = 0;
        String contentType = request.getContentType();
        if (contentType != null && data.length > 0) {
            if (contentType.toLowerCase().endsWith("xml") && data.length > 3 && data[0] == -17 && data[1] == -69 && data[2] == -65) {
                encoding = "UTF-8";
                contentOffset = 3;
            }
            String string = messageContent = (encoding = StringUtils.unquote(encoding)) == null ? new String(data) : new String(data, contentOffset, data.length - contentOffset, encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (messageContent == null) {
            messageContent = new String(data, encoding);
        }
        return messageContent;
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return this.mmSupport == null ? new Attachment[]{} : this.mmSupport.getAttachments();
    }

    @Override
    public String getRequestContent() {
        return this.mmSupport == null ? this.requestContent : this.mmSupport.getContentAsString();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
        this.requestXmlObject = null;
        try {
            this.soapVersion = SoapUtils.deduceSoapVersion(this.request.getContentType(), this.getRequestXmlObject());
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
        if (this.soapVersion == null) {
            this.soapVersion = SoapVersion.Soap11;
        }
    }

    public XmlObject getRequestXmlObject() throws XmlException {
        if (this.requestXmlObject == null && StringUtils.hasContent(this.getRequestContent())) {
            this.requestXmlObject = XmlUtils.createXmlObject(this.getRequestContent(), XmlUtils.createDefaultXmlOptions());
        }
        return this.requestXmlObject;
    }

    public HttpServletResponse getHttpResponse() {
        return this.response;
    }

    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public String getMethod() {
        return this.method == null ? this.request.getMethod() : this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public XmlObject getContentElement() throws XmlException {
        return SoapUtils.getContentElement(this.getRequestXmlObject(), this.soapVersion);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public WsdlMockRunContext getContext() {
        return this.context;
    }

    public void setOperation(WsdlOperation operation) {
        if (this.mmSupport != null) {
            this.mmSupport.setOperation(operation);
        }
    }

    public WsdlMockRunContext getRequestContext() {
        return this.requestContext;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.mockRequestDataSource == null ? (this.actualRequestContent == null ? this.requestContent.getBytes() : this.actualRequestContent.getBytes()) : this.mockRequestDataSource.getData();
    }

    public void setResponseMessage(boolean responseMessage) {
        this.responseMessage = responseMessage;
    }

    public boolean isResponseMessage() {
        return this.responseMessage;
    }
}

