/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.HeaderConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.MutableWsdlAttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlContentPart;
import com.eviware.soapui.impl.wsdl.WsdlHeaderPart;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.submit.filters.RemoveEmptyContentRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.BodyPartAttachment;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageMockResponseEntity;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MockResponseDataSource;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.MapTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.MessageXmlObject;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.MockFileAttachment;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaConfig;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaContainer;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.settings.CommonSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.swing.ImageIcon;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockResponse
extends AbstractWsdlModelItem<MockResponseConfig>
implements MockResponse,
MutableWsdlAttachmentContainer,
PropertyExpansionContainer,
TestPropertyHolder,
WsaContainer {
    public static final String AUTO_RESPONSE_COMPRESSION = "<auto>";
    public static final String NO_RESPONSE_COMPRESSION = "<none>";
    private static final Logger log = Logger.getLogger(WsdlMockResponse.class);
    public static final String MOCKRESULT_PROPERTY = WsdlMockResponse.class.getName() + "@mockresult";
    public static final String SCRIPT_PROPERTY = WsdlMockResponse.class.getName() + "@script";
    public static final String HEADERS_PROPERTY = WsdlMockResponse.class.getName() + "@headers";
    public static final String DISABLE_MULTIPART_ATTACHMENTS = WsdlMockResponse.class.getName() + "@disable-multipart-attachments";
    public static final String FORCE_MTOM = WsdlMockResponse.class.getName() + "@force_mtom";
    public static final String ENABLE_INLINE_FILES = WsdlMockResponse.class.getName() + "@enable_inline_files";
    public static final String RESPONSE_DELAY_PROPERTY = WsdlMockResponse.class.getName() + "@response-delay";
    public static final String STRIP_WHITESPACES = WsdlMockResponse.class.getName() + "@strip-whitespaces";
    public static final String REMOVE_EMPTY_CONTENT = WsdlMockResponse.class.getName() + "@remove_empty_content";
    public static final String ENCODE_ATTACHMENTS = WsdlMockResponse.class.getName() + "@encode_attachments";
    public static final String RESPONSE_HTTP_STATUS = WsdlMockResponse.class.getName() + "@response-http-status";
    public static final String OUGOING_WSS = WsdlMockResponse.class.getName() + "@outgoing-wss";
    protected List<FileAttachment<WsdlMockResponse>> attachments = new ArrayList<FileAttachment<WsdlMockResponse>>();
    private List<HttpAttachmentPart> definedAttachmentParts;
    private ModelItemIconAnimator<WsdlMockResponse> iconAnimator;
    private WsdlMockResult mockResult;
    private String responseContent;
    private ScriptEnginePool scriptEnginePool;
    private MapTestPropertyHolder propertyHolder;
    private WsaConfig wsaConfig;

    public WsdlMockResponse(WsdlMockOperation operation, MockResponseConfig config) {
        super(config, operation, "/mockResponse.gif");
        for (AttachmentConfig ac : ((MockResponseConfig)this.getConfig()).getAttachmentList()) {
            this.attachments.add(new MockFileAttachment(ac, this));
        }
        if (!config.isSetEncoding()) {
            config.setEncoding("UTF-8");
        }
        this.iconAnimator = new ModelItemIconAnimator<WsdlMockResponse>(this, "/mockResponse.gif", "/exec_request", 4, "gif");
        this.scriptEnginePool = new ScriptEnginePool(this);
        this.scriptEnginePool.setScript(this.getScript());
        this.propertyHolder = new MapTestPropertyHolder(this);
        this.propertyHolder.addProperty("Request");
    }

    @Override
    public void setConfig(MockResponseConfig config) {
        super.setConfig(config);
        if (this.wsaConfig != null) {
            if (config.isSetWsaConfig()) {
                this.wsaConfig.setConfig(config.getWsaConfig());
            } else {
                this.wsaConfig = null;
            }
        }
        if (this.scriptEnginePool != null) {
            this.scriptEnginePool.setScript(this.getScript());
        }
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    public String getScript() {
        return ((MockResponseConfig)this.getConfig()).isSetScript() ? ((MockResponseConfig)this.getConfig()).getScript().getStringValue() : null;
    }

    @Override
    public String getEncoding() {
        return ((MockResponseConfig)this.getConfig()).getEncoding();
    }

    public void setEncoding(String encoding) {
        String old = this.getEncoding();
        ((MockResponseConfig)this.getConfig()).setEncoding(encoding);
        this.notifyPropertyChanged(ENCODING_PROPERTY, old, encoding);
    }

    @Override
    public String getResponseContent() {
        if (((MockResponseConfig)this.getConfig()).getResponseContent() == null) {
            ((MockResponseConfig)this.getConfig()).addNewResponseContent();
        }
        if (this.responseContent == null) {
            this.responseContent = CompressedStringSupport.getString(((MockResponseConfig)this.getConfig()).getResponseContent());
        }
        return this.responseContent;
    }

    @Override
    public void setResponseContent(String responseContent) {
        String oldContent = this.getResponseContent();
        if (responseContent != null && responseContent.equals(oldContent)) {
            return;
        }
        this.responseContent = responseContent;
        this.notifyPropertyChanged(RESPONSE_CONTENT_PROPERTY, oldContent, responseContent);
    }

    public void setResponseCompression(String compression) {
        if ("deflate".equals(compression) || "gzip".equals(compression) || NO_RESPONSE_COMPRESSION.equals(compression)) {
            ((MockResponseConfig)this.getConfig()).setCompression(compression);
        } else if (((MockResponseConfig)this.getConfig()).isSetCompression()) {
            ((MockResponseConfig)this.getConfig()).unsetCompression();
        }
    }

    public String getResponseCompression() {
        if (((MockResponseConfig)this.getConfig()).isSetCompression()) {
            return ((MockResponseConfig)this.getConfig()).getCompression();
        }
        return AUTO_RESPONSE_COMPRESSION;
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    @Override
    public WsdlMockOperation getMockOperation() {
        return (WsdlMockOperation)this.getParent();
    }

    public WsdlMockResult execute(WsdlMockRequest request, WsdlMockResult result) throws DispatchException {
        try {
            OutgoingWss outgoing;
            String outgoingWss;
            String script;
            this.getProperty("Request").setValue(request.getRequestContent());
            long delay = this.getResponseDelay();
            if (delay > 0L) {
                Thread.sleep(delay);
            }
            if ((script = this.getScript()) != null && script.trim().length() > 0) {
                this.evaluateScript(request);
            }
            String responseContent = this.getResponseContent();
            WsdlMockRunContext context = new WsdlMockRunContext(request.getContext().getMockService(), null);
            context.setMockResponse(this);
            context.putAll(request.getContext());
            context.putAll(request.getRequestContext());
            StringToStringsMap responseHeaders = this.getResponseHeaders();
            for (String name : responseHeaders.keySet()) {
                for (String value : (List)responseHeaders.get(name)) {
                    result.addHeader(name, PropertyExpander.expandProperties(context, value));
                }
            }
            responseContent = PropertyExpander.expandProperties(context, responseContent, this.isEntitizeProperties());
            if (this.getWsaConfig().isWsaEnabled()) {
                responseContent = new WsaUtils(responseContent, this.getSoapVersion(), this.getMockOperation().getOperation(), context).addWSAddressingMockResponse(this, request);
            }
            if (StringUtils.isNullOrEmpty(outgoingWss = this.getOutgoingWss())) {
                outgoingWss = this.getMockOperation().getMockService().getOutgoingWss();
            }
            if (StringUtils.hasContent(outgoingWss) && (outgoing = this.getMockOperation().getMockService().getProject().getWssContainer().getOutgoingWssByName(outgoingWss)) != null) {
                Document dom = XmlUtils.parseXml(responseContent);
                outgoing.processOutgoing(dom, context);
                StringWriter writer = new StringWriter();
                XmlUtils.serialize(dom, (Writer)writer);
                responseContent = writer.toString();
            }
            if (!result.isCommitted()) {
                responseContent = this.writeResponse(result, responseContent);
            }
            result.setResponseContent(responseContent);
            this.setMockResult(result);
            return this.mockResult;
        }
        catch (Throwable e) {
            SoapUI.logError(e);
            throw new DispatchException(e);
        }
    }

    public void evaluateScript(WsdlMockRequest request) throws Exception {
        String script = this.getScript();
        if (script == null || script.trim().length() == 0) {
            return;
        }
        WsdlMockService mockService = this.getMockOperation().getMockService();
        WsdlMockRunner mockRunner = mockService.getMockRunner();
        WsdlMockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
        context.setMockResponse(this);
        SoapUIScriptEngine scriptEngine = this.scriptEnginePool.getScriptEngine();
        try {
            try {
                scriptEngine.setVariable("context", context);
                scriptEngine.setVariable("requestContext", request == null ? null : request.getRequestContext());
                scriptEngine.setVariable("mockContext", context);
                scriptEngine.setVariable("mockRequest", request);
                scriptEngine.setVariable("mockResponse", this);
                scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
                scriptEngine.run();
            }
            catch (RuntimeException e) {
                throw new Exception(e.getMessage(), e);
            }
            Object var9_7 = null;
            this.scriptEnginePool.returnScriptEngine(scriptEngine);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.scriptEnginePool.returnScriptEngine(scriptEngine);
            throw throwable;
        }
    }

    @Override
    public void release() {
        super.release();
        this.scriptEnginePool.release();
    }

    public void setScript(String script) {
        String oldScript = this.getScript();
        if (!script.equals(oldScript)) {
            if (!((MockResponseConfig)this.getConfig()).isSetScript()) {
                ((MockResponseConfig)this.getConfig()).addNewScript();
            }
            ((MockResponseConfig)this.getConfig()).getScript().setStringValue(script);
            this.scriptEnginePool.setScript(script);
            this.notifyPropertyChanged(SCRIPT_PROPERTY, oldScript, script);
        }
    }

    public void setResponseHeaders(StringToStringsMap headers) {
        StringToStringsMap oldHeaders = this.getResponseHeaders();
        ((MockResponseConfig)this.getConfig()).setHeaderArray(new HeaderConfig[0]);
        for (String header : headers.keySet()) {
            for (String value : (List)headers.get(header)) {
                HeaderConfig headerConfig = ((MockResponseConfig)this.getConfig()).addNewHeader();
                headerConfig.setName(header);
                headerConfig.setValue(value);
            }
        }
        this.notifyPropertyChanged(HEADERS_PROPERTY, oldHeaders, headers);
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        StringToStringsMap result = new StringToStringsMap();
        List<HeaderConfig> headerList = ((MockResponseConfig)this.getConfig()).getHeaderList();
        for (HeaderConfig header : headerList) {
            result.add(header.getName(), header.getValue());
        }
        return result;
    }

    public MessagePart[] getRequestParts() {
        try {
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            result.addAll(Arrays.asList(this.getMockOperation().getOperation().getDefaultRequestParts()));
            if (this.getMockResult() != null) {
                result.addAll(AttachmentUtils.extractAttachmentParts(this.getMockOperation().getOperation(), this.getMockResult().getMockRequest().getRequestContent(), true, false, this.isMtomEnabled()));
            }
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    public MessagePart[] getResponseParts() {
        try {
            WsdlOperation op = this.getMockOperation().getOperation();
            if (op == null || op.isUnidirectional()) {
                return new MessagePart[0];
            }
            ArrayList<MessagePart> result = new ArrayList<MessagePart>();
            WsdlContext wsdlContext = op.getInterface().getWsdlContext();
            BindingOperation bindingOperation = op.findBindingOperation(wsdlContext.getDefinition());
            if (bindingOperation == null) {
                return new MessagePart[0];
            }
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            List<Object> headers = bindingOutput == null ? new ArrayList() : WsdlUtils.getSoapHeaders(bindingOutput.getExtensibilityElements());
            for (int i = 0; i < headers.size(); ++i) {
                WsdlUtils.SoapHeader header = (WsdlUtils.SoapHeader)headers.get(i);
                Message message = wsdlContext.getDefinition().getMessage(header.getMessage());
                if (message == null) {
                    log.error((Object)("Missing message for header: " + header.getMessage()));
                    continue;
                }
                Part part = message.getPart(header.getPart());
                if (part != null) {
                    SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                    SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                    if (schemaType == null) continue;
                    result.add(new WsdlHeaderPart(part.getName(), schemaType, part.getElementName(), schemaElement));
                    continue;
                }
                log.error((Object)("Missing part for header; " + header.getPart()));
            }
            Part[] parts = WsdlUtils.getOutputParts(bindingOperation);
            for (int i = 0; i < parts.length; ++i) {
                Part part = parts[i];
                if (WsdlUtils.isAttachmentOutputPart(part, bindingOperation)) continue;
                SchemaType schemaType = WsdlUtils.getSchemaTypeForPart(wsdlContext, part);
                SchemaGlobalElement schemaElement = WsdlUtils.getSchemaElementForPart(wsdlContext, part);
                if (schemaType == null) continue;
                result.add(new WsdlContentPart(part.getName(), schemaType, part.getElementName(), schemaElement));
            }
            result.addAll(Arrays.asList(this.getDefinedAttachmentParts()));
            return result.toArray(new MessagePart[result.size()]);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new MessagePart[0];
        }
    }

    @Override
    public Attachment attachFile(File file, boolean cache) throws IOException {
        MockFileAttachment fileAttachment = new MockFileAttachment(file, cache, this);
        this.attachments.add(fileAttachment);
        this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
        return fileAttachment;
    }

    @Override
    public int getAttachmentCount() {
        return this.attachments.size();
    }

    @Override
    public WsdlAttachment getAttachmentAt(int index) {
        return this.attachments.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttachment(Attachment attachment) {
        int ix = this.attachments.indexOf(attachment);
        this.attachments.remove(ix);
        try {
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, attachment, null);
            Object var4_3 = null;
            ((MockResponseConfig)this.getConfig()).removeAttachment(ix);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((MockResponseConfig)this.getConfig()).removeAttachment(ix);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpAttachmentPart[] getDefinedAttachmentParts() {
        if (this.definedAttachmentParts != null) return this.definedAttachmentParts.toArray(new HttpAttachmentPart[this.definedAttachmentParts.size()]);
        try {
            try {
                WsdlOperation operation = this.getMockOperation().getOperation();
                if (operation == null) {
                    this.definedAttachmentParts = new ArrayList<HttpAttachmentPart>();
                }
                UISupport.setHourglassCursor();
                this.definedAttachmentParts = AttachmentUtils.extractAttachmentParts(operation, this.getResponseContent(), true, true, this.isMtomEnabled());
            }
            catch (Exception e) {
                log.warn((Object)e.toString());
                Object var3_4 = null;
                UISupport.resetCursor();
                return this.definedAttachmentParts.toArray(new HttpAttachmentPart[this.definedAttachmentParts.size()]);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            UISupport.resetCursor();
            throw throwable;
        }
        UISupport.resetCursor();
        return this.definedAttachmentParts.toArray(new HttpAttachmentPart[this.definedAttachmentParts.size()]);
    }

    @Override
    public HttpAttachmentPart getAttachmentPart(String partName) {
        HttpAttachmentPart[] parts;
        for (HttpAttachmentPart part : parts = this.getDefinedAttachmentParts()) {
            if (!part.getName().equals(partName)) continue;
            return part;
        }
        return null;
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!attachment.getPart().equals(partName)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public boolean isMtomEnabled() {
        return this.getSettings().getBoolean(WsdlSettings.ENABLE_MTOM);
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        boolean old = this.isMtomEnabled();
        this.getSettings().setBoolean(WsdlSettings.ENABLE_MTOM, mtomEnabled);
        this.definedAttachmentParts = null;
        this.notifyPropertyChanged(MTOM_NABLED_PROPERTY, old, mtomEnabled);
    }

    private String writeResponse(WsdlMockResult response, String responseContent) throws Exception {
        boolean isXOP;
        MimeMultipart mp = null;
        WsdlOperation operation = this.getMockOperation().getOperation();
        if (operation == null) {
            throw new Exception("Missing WsdlOperation for mock response");
        }
        SoapVersion soapVersion = operation.getInterface().getSoapVersion();
        StringToStringMap contentIds = new StringToStringMap();
        boolean bl = isXOP = this.isMtomEnabled() && this.isForceMtom();
        if (this.isMtomEnabled() || this.isInlineFilesEnabled() || this.getAttachmentCount() > 0) {
            try {
                MessageXmlPart[] requestParts;
                mp = new MimeMultipart();
                MessageXmlObject requestXmlObject = new MessageXmlObject(operation, responseContent, false);
                for (MessageXmlPart requestPart : requestParts = requestXmlObject.getMessageParts()) {
                    if (!AttachmentUtils.prepareMessagePart(this, mp, requestPart, contentIds)) continue;
                    isXOP = true;
                }
                responseContent = requestXmlObject.getMessageContent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isRemoveEmptyContent()) {
            responseContent = RemoveEmptyContentRequestFilter.removeEmptyContent(responseContent, this.getSoapVersion().getEnvelopeNamespace(), true);
        }
        if (this.isStripWhitespaces()) {
            responseContent = XmlUtils.stripWhitespaces(responseContent);
        }
        String status = this.getResponseHttpStatus();
        WsdlMockRequest request = response.getMockRequest();
        if (status == null || status.trim().length() == 0) {
            if (SoapUtils.isSoapFault(responseContent, request.getSoapVersion())) {
                request.getHttpResponse().setStatus(500);
                response.setResponseStatus(500);
            } else {
                request.getHttpResponse().setStatus(200);
                response.setResponseStatus(200);
            }
        } else {
            try {
                int statusCode = Integer.parseInt(status);
                request.getHttpResponse().setStatus(statusCode);
                response.setResponseStatus(statusCode);
            }
            catch (RuntimeException e) {
                SoapUI.logError(e);
            }
        }
        ByteArrayOutputStream outData = new ByteArrayOutputStream();
        String responseCompression = this.getResponseCompression();
        if (!(isXOP || mp != null && mp.getCount() != 0 || this.getAttachmentCount() != 0)) {
            byte[] content;
            String encoding = this.getEncoding();
            if (responseContent == null) {
                responseContent = "";
            }
            byte[] byArray = content = encoding == null ? responseContent.getBytes() : responseContent.getBytes(encoding);
            if (!response.getResponseHeaders().containsKeyIgnoreCase("Content-Type")) {
                response.setContentType(soapVersion.getContentTypeHttpHeader(encoding, null));
            }
            String acceptEncoding = response.getMockRequest().getRequestHeaders().get("Accept-Encoding", "");
            if (AUTO_RESPONSE_COMPRESSION.equals(responseCompression) && acceptEncoding != null && acceptEncoding.toUpperCase().contains("GZIP")) {
                response.addHeader("Content-Encoding", "gzip");
                outData.write(CompressionSupport.compress("gzip", content));
            } else if (AUTO_RESPONSE_COMPRESSION.equals(responseCompression) && acceptEncoding != null && acceptEncoding.toUpperCase().contains("DEFLATE")) {
                response.addHeader("Content-Encoding", "deflate");
                outData.write(CompressionSupport.compress("deflate", content));
            } else {
                outData.write(content);
            }
        } else {
            if (mp == null) {
                mp = new MimeMultipart();
            }
            this.initRootPart(responseContent, mp, isXOP);
            AttachmentUtils.addMimeParts(this, Arrays.asList(this.getAttachments()), mp, contentIds);
            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
            message.setContent((Multipart)mp);
            message.saveChanges();
            MimeMessageMockResponseEntity mimeMessageRequestEntity = new MimeMessageMockResponseEntity(message, isXOP, this);
            response.addHeader("Content-Type", mimeMessageRequestEntity.getContentType().getValue());
            response.addHeader("MIME-Version", "1.0");
            mimeMessageRequestEntity.writeTo(outData);
        }
        if (outData.size() > 0) {
            byte[] data = outData.toByteArray();
            if (responseCompression.equals("deflate") || responseCompression.equals("gzip")) {
                response.addHeader("Content-Encoding", responseCompression);
                data = CompressionSupport.compress(responseCompression, data);
            }
            response.writeRawResponseData(data);
        }
        return responseContent;
    }

    private void initRootPart(String requestContent, MimeMultipart mp, boolean isXOP) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        rootPart.setContentID("<rootpart@soapui.org>");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new MockResponseDataSource(this, requestContent, isXOP));
        rootPart.setDataHandler(dataHandler);
    }

    public Attachment addAttachment(Attachment attachment) {
        if (attachment instanceof BodyPartAttachment) {
            try {
                BodyPartAttachment att = (BodyPartAttachment)attachment;
                AttachmentConfig newConfig = ((MockResponseConfig)this.getConfig()).addNewAttachment();
                newConfig.setData(Tools.readAll(att.getInputStream(), 0L).toByteArray());
                newConfig.setContentId(att.getContentID());
                newConfig.setContentType(att.getContentType());
                newConfig.setName(att.getName());
                MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
                this.attachments.add(newAttachment);
                return newAttachment;
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        } else if (attachment instanceof FileAttachment) {
            AttachmentConfig oldConfig = ((FileAttachment)attachment).getConfig();
            AttachmentConfig newConfig = (AttachmentConfig)((MockResponseConfig)this.getConfig()).addNewAttachment().set(oldConfig);
            MockFileAttachment newAttachment = new MockFileAttachment(newConfig, this);
            this.attachments.add(newAttachment);
            return newAttachment;
        }
        return null;
    }

    public void setResponseDelay(long delay) {
        long oldDelay = this.getResponseDelay();
        if (delay == 0L) {
            this.getSettings().clearSetting(RESPONSE_DELAY_PROPERTY);
        } else {
            this.getSettings().setLong(RESPONSE_DELAY_PROPERTY, delay);
        }
        this.notifyPropertyChanged(RESPONSE_DELAY_PROPERTY, oldDelay, delay);
    }

    public long getResponseDelay() {
        return this.getSettings().getLong(RESPONSE_DELAY_PROPERTY, 0L);
    }

    public void setResponseHttpStatus(String httpStatus) {
        String oldStatus = this.getResponseHttpStatus();
        ((MockResponseConfig)this.getConfig()).setHttpResponseStatus(httpStatus);
        this.notifyPropertyChanged(RESPONSE_HTTP_STATUS, oldStatus, httpStatus);
    }

    public String getResponseHttpStatus() {
        return ((MockResponseConfig)this.getConfig()).getHttpResponseStatus();
    }

    public void setMockResult(WsdlMockResult mockResult) {
        WsdlMockResult oldResult = this.mockResult;
        this.mockResult = mockResult;
        this.notifyPropertyChanged(MOCKRESULT_PROPERTY, oldResult, mockResult);
    }

    @Override
    public WsdlMockResult getMockResult() {
        return this.mockResult;
    }

    public long getContentLength() {
        return this.getResponseContent() == null ? 0L : (long)this.getResponseContent().length();
    }

    @Override
    public boolean isMultipartEnabled() {
        return !this.getSettings().getBoolean(DISABLE_MULTIPART_ATTACHMENTS);
    }

    public void setMultipartEnabled(boolean multipartEnabled) {
        this.getSettings().setBoolean(DISABLE_MULTIPART_ATTACHMENTS, multipartEnabled);
    }

    public boolean isEntitizeProperties() {
        return this.getSettings().getBoolean(CommonSettings.ENTITIZE_PROPERTIES);
    }

    public void setEntitizeProperties(boolean entitizeProperties) {
        this.getSettings().setBoolean(CommonSettings.ENTITIZE_PROPERTIES, entitizeProperties);
    }

    public boolean isForceMtom() {
        return this.getSettings().getBoolean(FORCE_MTOM);
    }

    public void setForceMtom(boolean forceMtom) {
        boolean old = this.getSettings().getBoolean(FORCE_MTOM);
        this.getSettings().setBoolean(FORCE_MTOM, forceMtom);
        this.notifyPropertyChanged(FORCE_MTOM, old, forceMtom);
    }

    public boolean isRemoveEmptyContent() {
        return this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
    }

    public void setRemoveEmptyContent(boolean removeEmptyContent) {
        boolean old = this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
        this.getSettings().setBoolean(REMOVE_EMPTY_CONTENT, removeEmptyContent);
        this.notifyPropertyChanged(REMOVE_EMPTY_CONTENT, old, removeEmptyContent);
    }

    @Override
    public boolean isEncodeAttachments() {
        return this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
    }

    public void setEncodeAttachments(boolean encodeAttachments) {
        boolean old = this.getSettings().getBoolean(ENCODE_ATTACHMENTS);
        this.getSettings().setBoolean(ENCODE_ATTACHMENTS, encodeAttachments);
        this.notifyPropertyChanged(ENCODE_ATTACHMENTS, old, encodeAttachments);
    }

    public boolean isStripWhitespaces() {
        return this.getSettings().getBoolean(STRIP_WHITESPACES);
    }

    public void setStripWhitespaces(boolean stripWhitespaces) {
        boolean old = this.getSettings().getBoolean(STRIP_WHITESPACES);
        this.getSettings().setBoolean(STRIP_WHITESPACES, stripWhitespaces);
        this.notifyPropertyChanged(STRIP_WHITESPACES, old, stripWhitespaces);
    }

    @Override
    public boolean isInlineFilesEnabled() {
        return this.getSettings().getBoolean(ENABLE_INLINE_FILES);
    }

    public void setInlineFilesEnabled(boolean inlineFilesEnabled) {
        this.getSettings().setBoolean(ENABLE_INLINE_FILES, inlineFilesEnabled);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.responseContent != null) {
            CompressedStringSupport.setString(((MockResponseConfig)this.getConfig()).getResponseContent(), this.responseContent);
        }
    }

    @Override
    public void addAttachmentsChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    public SoapVersion getSoapVersion() {
        return this.getMockOperation().getOperation() == null ? SoapVersion.Soap11 : this.getMockOperation().getOperation().getInterface().getSoapVersion();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "responseContent"));
        StringToStringsMap responseHeaders = this.getResponseHeaders();
        for (String key : responseHeaders.keySet()) {
            for (String value : (List)responseHeaders.get(key)) {
                result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, new ResponseHeaderHolder(key, value, this), "value"));
            }
        }
        this.addWsaPropertyExpansions(result, this.getWsaConfig(), this);
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public void addWsaPropertyExpansions(List<PropertyExpansion> result, WsaConfig wsaConfig, ModelItem modelItem) {
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "action"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "from"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "to"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "replyToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "faultToRefParams"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relatesTo"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "relationshipType"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(modelItem, wsaConfig, "messageID"));
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolder.addTestPropertyListener(listener);
    }

    @Override
    public ModelItem getModelItem() {
        return this.propertyHolder.getModelItem();
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolder.getProperties();
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolder.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolder.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolder.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolder.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolder.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolder.setPropertyValue(name, value);
    }

    public String getOutgoingWss() {
        return ((MockResponseConfig)this.getConfig()).getOutgoingWss();
    }

    public void setOutgoingWss(String outgoingWss) {
        String old = this.getOutgoingWss();
        ((MockResponseConfig)this.getConfig()).setOutgoingWss(outgoingWss);
        this.notifyPropertyChanged(OUGOING_WSS, old, outgoingWss);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolder.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolder.getPropertyCount();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolder.getPropertyList();
    }

    @Override
    public String getPropertiesLabel() {
        return "Custom Properties";
    }

    @Override
    public Attachment.AttachmentEncoding getAttachmentEncoding(String partName) {
        HttpAttachmentPart attachmentPart = this.getAttachmentPart(partName);
        if (attachmentPart == null) {
            return AttachmentUtils.getAttachmentEncoding(this.getOperation(), partName, true);
        }
        return AttachmentUtils.getAttachmentEncoding(this.getOperation(), attachmentPart, true);
    }

    @Override
    public WsaConfig getWsaConfig() {
        if (this.wsaConfig == null) {
            if (!((MockResponseConfig)this.getConfig()).isSetWsaConfig()) {
                ((MockResponseConfig)this.getConfig()).addNewWsaConfig();
            }
            this.wsaConfig = new WsaConfig(((MockResponseConfig)this.getConfig()).getWsaConfig(), this);
        }
        return this.wsaConfig;
    }

    public boolean isWsAddressing() {
        return ((MockResponseConfig)this.getConfig()).getUseWsAddressing();
    }

    public void setWsAddressing(boolean wsAddressing) {
        boolean old = ((MockResponseConfig)this.getConfig()).getUseWsAddressing();
        ((MockResponseConfig)this.getConfig()).setUseWsAddressing(wsAddressing);
        this.notifyPropertyChanged("wsAddressing", old, wsAddressing);
    }

    @Override
    public boolean isWsaEnabled() {
        return this.isWsAddressing();
    }

    @Override
    public void setWsaEnabled(boolean arg0) {
        this.setWsAddressing(arg0);
    }

    @Override
    public WsdlOperation getOperation() {
        return this.getMockOperation().getOperation();
    }

    @Override
    public void setOperation(WsdlOperation operation) {
        this.getMockOperation().setOperation(operation);
    }

    public static class ResponseHeaderHolder {
        private final String key;
        private final String oldValue;
        private WsdlMockResponse mockResponse;

        public ResponseHeaderHolder(String key, String oldValue, WsdlMockResponse mockResponse) {
            this.key = key;
            this.oldValue = oldValue;
            this.mockResponse = mockResponse;
        }

        public String getValue() {
            return this.oldValue;
        }

        public void setValue(String value) {
            StringToStringsMap valueMap = this.mockResponse.getResponseHeaders();
            valueMap.replace(this.key, this.oldValue, value);
            this.mockResponse.setResponseHeaders(valueMap);
        }
    }
}

