/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.assertions;

import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.recent.RecentAssertionHandler;
import com.eviware.soapui.model.testsuite.Assertable;
import java.util.LinkedHashMap;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionCategoryMapping {
    public static final String VALIDATE_RESPONSE_CONTENT_CATEGORY = "Property Content";
    public static final String STATUS_CATEGORY = "Compliance, Status and Standards";
    public static final String SCRIPT_CATEGORY = "Script";
    public static final String SLA_CATEGORY = "SLA";
    public static final String JMS_CATEGORY = "JMS";
    public static final String SECURITY_CATEGORY = "Security";
    public static final String RECENTLY_USED = "Recently used";
    public static final String JDBC_CATEGORY = "JDBC";
    public static final String GROUPING = "GROUPING";

    public static String[] getAssertionCategories() {
        return new String[]{VALIDATE_RESPONSE_CONTENT_CATEGORY, STATUS_CATEGORY, SCRIPT_CATEGORY, SLA_CATEGORY, JMS_CATEGORY, JDBC_CATEGORY, SECURITY_CATEGORY};
    }

    private static SortedSet<AssertionListEntry> createRecentlyUsedSet(Assertable assertable, RecentAssertionHandler recentAssertionHandler) {
        TreeSet<AssertionListEntry> recentlyUsedSet = new TreeSet<AssertionListEntry>();
        for (String name : recentAssertionHandler.get()) {
            String type = recentAssertionHandler.getAssertionTypeByName(name);
            if (type == null || assertable != null && !recentAssertionHandler.canAssert(type, assertable)) continue;
            recentlyUsedSet.add(recentAssertionHandler.getAssertionListEntry(type));
        }
        return recentlyUsedSet;
    }

    public static LinkedHashMap<String, SortedSet<AssertionListEntry>> getCategoriesAssertionsMap(Assertable assertable, RecentAssertionHandler recentAssertionHandler) {
        LinkedHashMap<String, SortedSet<AssertionListEntry>> categoriesAssertionsMap = new LinkedHashMap<String, SortedSet<AssertionListEntry>>();
        SortedSet<AssertionListEntry> recentlyUsedSet = AssertionCategoryMapping.createRecentlyUsedSet(assertable, recentAssertionHandler);
        if (recentlyUsedSet.size() > 0) {
            categoriesAssertionsMap.put(RECENTLY_USED, recentlyUsedSet);
        }
        TestAssertionRegistry.getInstance().addAllCategoriesMap(categoriesAssertionsMap);
        return categoriesAssertionsMap;
    }
}

