/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFCredentials;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.SoapUIAMFConnection;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringsMap;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;
import java.util.List;
import java.util.concurrent.Future;

public class AMFSubmit
implements Submit,
Runnable {
    public static final String AMF_CONNECTION = "AMF_CONNECTION";
    private volatile Future<?> future;
    private SubmitContext context;
    private Submit.Status status;
    private SubmitListener[] listeners;
    private Exception error;
    private long timestamp;
    private final AMFRequest request;
    private AMFResponse response;
    private AMFCredentials credentials;

    public AMFSubmit(AMFRequest request, SubmitContext submitContext, boolean async) {
        int c;
        this.request = request;
        this.context = submitContext;
        List<SubmitListener> regListeners = SoapUI.getListenerRegistry().getListeners(SubmitListener.class);
        SubmitListener[] submitListeners = request.getSubmitListeners();
        this.listeners = new SubmitListener[submitListeners.length + regListeners.size()];
        for (c = 0; c < submitListeners.length; ++c) {
            this.listeners[c] = submitListeners[c];
        }
        for (c = 0; c < regListeners.size(); ++c) {
            this.listeners[submitListeners.length + c] = regListeners.get(c);
        }
        this.error = null;
        this.status = Submit.Status.INITIALIZED;
        this.timestamp = System.currentTimeMillis();
        if (async) {
            this.future = SoapUI.getThreadPool().submit(this);
        } else {
            this.run();
        }
    }

    public void cancel() {
        if (this.status == Submit.Status.CANCELED) {
            return;
        }
        SoapUI.log.info((Object)"Canceling request..");
        this.status = Submit.Status.CANCELED;
        for (int i = 0; i < this.listeners.length; ++i) {
            try {
                this.listeners[i].afterSubmit(this, this.context);
                continue;
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    public Submit.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block18: {
            block17: {
                try {
                    try {
                        for (i = 0; i < this.listeners.length; ++i) {
                            if (this.listeners[i].beforeSubmit(this, this.context)) continue;
                            this.status = Submit.Status.CANCELED;
                            SoapUI.log.error((Object)"listener cancelled submit..");
                            var3_4 = null;
                            if (this.status == Submit.Status.CANCELED) return;
                            break block17;
                        }
                        this.status = Submit.Status.RUNNING;
                        responseContent = this.executeAmfCall(this.getRequest());
                        this.createResponse(responseContent);
                        if (this.status != Submit.Status.CANCELED && this.status != Submit.Status.ERROR) {
                            this.status = Submit.Status.FINISHED;
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        UISupport.showErrorMessage("There's been an error in executing query " + e.toString());
                        this.error = e;
                        var3_6 = null;
                        if (this.status == Submit.Status.CANCELED) return;
                        for (i = 0; i < this.listeners.length; ++i) {
                            try {
                                this.listeners[i].afterSubmit(this, this.context);
                                continue;
                            }
                            catch (Throwable e) {
                                SoapUI.logError(e);
                            }
                        }
                        return;
                    }
                }
                catch (Throwable var2_16) {
                    var3_7 = null;
                    if (this.status == Submit.Status.CANCELED) throw var2_16;
                    for (i = 0; i < this.listeners.length; ++i) {
                        ** try [egrp 2[TRYBLOCK] [6 : 176->196)] { 
lbl37:
                        // 1 sources

                        this.listeners[i].afterSubmit(this, this.context);
                        continue;
lbl39:
                        // 1 sources

                        catch (Throwable e) {
                            SoapUI.logError(e);
                        }
                    }
                    throw var2_16;
                }
            }
            for (i = 0; i < this.listeners.length; ++i) {
                ** try [egrp 2[TRYBLOCK] [6 : 176->196)] { 
lbl46:
                // 1 sources

                this.listeners[i].afterSubmit(this, this.context);
                continue;
lbl48:
                // 1 sources

                catch (Throwable e) {
                    SoapUI.logError(e);
                }
            }
            return;
        }
        var3_5 = null;
        if (this.status == Submit.Status.CANCELED) return;
        for (i = 0; i < this.listeners.length; ++i) {
            ** try [egrp 2[TRYBLOCK] [6 : 176->196)] { 
lbl57:
            // 1 sources

            this.listeners[i].afterSubmit(this, this.context);
            continue;
lbl59:
            // 1 sources

            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    protected void createResponse(Object responseContent) {
        try {
            this.response = new AMFResponse(this.request, this.context, responseContent);
            this.response.setTimestamp(this.timestamp);
            this.response.setTimeTaken(System.currentTimeMillis() - this.timestamp);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAmfCall(AMFRequest amfRequest) throws ClientStatusException, ServerStatusException {
        block11: {
            Object object;
            SoapUIAMFConnection amfConnection = null;
            try {
                Object result;
                amfConnection = this.getConnection(amfRequest);
                this.addAmfHeaders(amfRequest, amfConnection);
                this.addHttpHeaders(amfRequest, amfConnection);
                object = result = amfConnection.call(this.context, amfRequest.getAmfCall(), amfRequest.argumentsToArray());
                Object var6_6 = null;
                amfRequest.clearArguments();
            }
            catch (Exception e) {
                try {
                    SoapUI.logError(e);
                    this.error = e;
                    this.status = Submit.Status.ERROR;
                    Object var6_7 = null;
                    amfRequest.clearArguments();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    amfRequest.clearArguments();
                    if (this.context.getModelItem() instanceof AMFRequestTestStep) {
                        if (this.credentials != null && this.credentials.isLoggedIn()) {
                            this.credentials.logout();
                            this.credentials = null;
                        } else {
                            amfConnection.close();
                        }
                    }
                    throw throwable;
                }
                if (!(this.context.getModelItem() instanceof AMFRequestTestStep)) break block11;
                if (this.credentials != null && this.credentials.isLoggedIn()) {
                    this.credentials.logout();
                    this.credentials = null;
                }
                amfConnection.close();
                {
                }
            }
            if (this.context.getModelItem() instanceof AMFRequestTestStep) {
                if (this.credentials != null && this.credentials.isLoggedIn()) {
                    this.credentials.logout();
                    this.credentials = null;
                } else {
                    amfConnection.close();
                }
            }
            return object;
        }
        return null;
    }

    private SoapUIAMFConnection getConnection(AMFRequest amfRequest) throws Exception {
        SoapUIAMFConnection amfConnection = null;
        if (this.isAuthorisationEnabled(amfRequest) && this.context.getModelItem() instanceof WsdlTestCase) {
            amfConnection = (SoapUIAMFConnection)this.context.getProperty(AMF_CONNECTION);
            if (amfConnection != null) {
                return amfConnection;
            }
            throw new Exception("amf session connection error! ");
        }
        if (this.isAuthorisationEnabled(amfRequest) && this.context.getModelItem() instanceof AMFRequestTestStep) {
            String endpoint = this.context.expand(this.getTestCaseConfig(amfRequest).getAmfEndpoint());
            String username = this.context.expand(this.getTestCaseConfig(amfRequest).getAmfLogin());
            String password = this.context.expand(this.getTestCaseConfig(amfRequest).getAmfPassword());
            if (StringUtils.hasContent(endpoint) && StringUtils.hasContent(username)) {
                this.credentials = new AMFCredentials(endpoint, username, password, this.context);
                amfConnection = this.credentials.login();
            } else {
                amfConnection = new SoapUIAMFConnection();
                amfConnection.connect(this.context.expand(amfRequest.getEndpoint()));
            }
            this.context.setProperty(AMF_CONNECTION, amfConnection);
            return amfConnection;
        }
        amfConnection = new SoapUIAMFConnection();
        amfConnection.connect(this.context.expand(amfRequest.getEndpoint()));
        return amfConnection;
    }

    private boolean isAuthorisationEnabled(AMFRequest amfRequest) {
        return this.getTestCaseConfig(amfRequest).getAmfAuthorisation();
    }

    private TestCaseConfig getTestCaseConfig(AMFRequest amfRequest) {
        return (TestCaseConfig)amfRequest.getTestStep().getTestCase().getConfig();
    }

    private void addHttpHeaders(AMFRequest amfRequest, SoapUIAMFConnection amfConnection) {
        StringToStringsMap httpHeaders = amfRequest.getHttpHeaders();
        if (httpHeaders != null) {
            for (String key : httpHeaders.getKeys()) {
                for (String value : (List)httpHeaders.get(key)) {
                    amfConnection.addHttpRequestHeader(key, this.context.expand(value));
                }
            }
        }
    }

    private void addAmfHeaders(AMFRequest amfRequest, SoapUIAMFConnection amfConnection) {
        if (amfRequest.getAmfHeaders() != null) {
            for (String key : amfRequest.getAmfHeaders().keySet()) {
                Object data = amfRequest.getAmfHeaders().get(key);
                if (data instanceof String) {
                    data = this.context.expand((String)data);
                }
                amfConnection.addAmfHeader(key, data);
            }
        }
    }

    public Exception getError() {
        return this.error;
    }

    public AMFRequest getRequest() {
        return this.request;
    }

    public AMFResponse getResponse() {
        return this.response;
    }

    public Submit.Status getStatus() {
        return this.status;
    }
}

