/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlRequestMimeMessageRequestEntity;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.MessageXmlObject;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

public class WsdlPackagingRequestFilter
extends AbstractRequestFilter {
    public void filterWsdlRequest(SubmitContext context, WsdlRequest request) {
        ExtendedPostMethod postMethod = (ExtendedPostMethod)context.getProperty("httpMethod");
        String requestContent = (String)context.getProperty("requestContent");
        try {
            String content = this.initWsdlRequest(request, postMethod, requestContent);
            if (content != null) {
                context.setProperty("requestContent", content);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected String initWsdlRequest(WsdlRequest wsdlRequest, ExtendedPostMethod postMethod, String requestContent) throws Exception {
        boolean isXOP;
        MimeMultipart mp = null;
        StringToStringMap contentIds = new StringToStringMap();
        boolean bl = isXOP = wsdlRequest.isMtomEnabled() && wsdlRequest.isForceMtom();
        if (wsdlRequest.isMtomEnabled() || wsdlRequest.isInlineFilesEnabled() || wsdlRequest.getAttachmentCount() > 0) {
            try {
                MessageXmlPart[] requestParts;
                mp = new MimeMultipart();
                MessageXmlObject requestXmlObject = new MessageXmlObject(wsdlRequest.getOperation(), requestContent, true);
                for (MessageXmlPart requestPart : requestParts = requestXmlObject.getMessageParts()) {
                    if (!AttachmentUtils.prepareMessagePart(wsdlRequest, mp, requestPart, contentIds)) continue;
                    isXOP = true;
                }
                requestContent = requestXmlObject.getMessageContent();
            }
            catch (Throwable e) {
                SoapUI.log.warn((Object)("Failed to process inline/MTOM attachments; " + e));
            }
        }
        if (!isXOP && (mp == null || mp.getCount() == 0) && this.hasContentAttachmentsOnly(wsdlRequest)) {
            String encoding = System.getProperty("soapui.request.encoding", StringUtils.unquote(wsdlRequest.getEncoding()));
            byte[] content = StringUtils.isNullOrEmpty(encoding) ? requestContent.getBytes() : requestContent.getBytes(encoding);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(content));
        } else {
            if (mp == null) {
                mp = new MimeMultipart();
            }
            this.initRootPart(wsdlRequest, requestContent, mp, isXOP);
            AttachmentUtils.addMimeParts(wsdlRequest, Arrays.asList(wsdlRequest.getAttachments()), mp, contentIds);
            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
            message.setContent((Multipart)mp);
            message.saveChanges();
            WsdlRequestMimeMessageRequestEntity mimeMessageRequestEntity = new WsdlRequestMimeMessageRequestEntity(message, isXOP, wsdlRequest);
            postMethod.setEntity((HttpEntity)mimeMessageRequestEntity);
            postMethod.setHeader(mimeMessageRequestEntity.getContentType());
            postMethod.setHeader("MIME-Version", "1.0");
        }
        return requestContent;
    }

    private boolean hasContentAttachmentsOnly(WsdlRequest wsdlRequest) {
        for (Attachment attachment : wsdlRequest.getAttachments()) {
            if (attachment.getAttachmentType() == Attachment.AttachmentType.CONTENT || attachment.getAttachmentType() == Attachment.AttachmentType.UNKNOWN && wsdlRequest.isInlineFilesEnabled()) continue;
            return false;
        }
        return true;
    }

    protected void initRootPart(WsdlRequest wsdlRequest, String requestContent, MimeMultipart mp, boolean isXOP) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart(System.getProperty("soapui.bodypart.encoding", "8bit"));
        rootPart.setContentID("<rootpart@soapui.org>");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new WsdlRequestDataSource(wsdlRequest, requestContent, isXOP));
        rootPart.setDataHandler(dataHandler);
    }
}

