/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.saml.callback;

import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.AbstractSAMLCallbackHandler;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

public class SAML2CallbackHandler
extends AbstractSAMLCallbackHandler {
    public SAML2CallbackHandler(Crypto crypto, String alias, String assertionTypeFriendlyName, String confirmationMethodFriendlyName) throws Exception {
        super(crypto, alias, assertionTypeFriendlyName, confirmationMethodFriendlyName);
        if (this.certs == null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(alias);
            this.certs = crypto.getX509Certificates(cryptoType);
        }
    }

    public SAML2CallbackHandler(String assertionTypeFriendlyName, String confirmationMethodFriendlyName) {
        super(assertionTypeFriendlyName, confirmationMethodFriendlyName);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            SubjectBean subjectBean;
            SAMLCallback callback;
            if (callbacks[i] instanceof SAMLCallback) {
                callback = (SAMLCallback)callbacks[i];
                callback.setSamlVersion(SAMLVersion.VERSION_20);
                callback.setIssuer(this.issuer);
                subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, this.confirmationMethod);
                if (this.subjectNameIDFormat != null) {
                    subjectBean.setSubjectNameIDFormat(this.subjectNameIDFormat);
                }
                if ("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(this.confirmationMethod)) {
                    try {
                        KeyInfoBean keyInfo = this.createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    }
                    catch (Exception ex) {
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            callback.setSubject(subjectBean);
            this.createAndSetStatement(null, callback);
        }
    }

    public void setConfirmationMethod(String confirmationMethodFriendlyName) {
        if (confirmationMethodFriendlyName.equals("Holder-of-key")) {
            this.confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        } else if (confirmationMethodFriendlyName.equals("Sender vouches")) {
            this.confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        }
    }
}

