/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.support;

import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAttributeValuesTable
extends JPanel {
    private final List<StringToStringMap> attributeValues;
    private WssEntryBase entry;
    private AttributeValuesTableModel attributeValuesTableModel;
    private JTable attributeValuesTable;
    private JButton removeAttributeValueButton;
    private JButton createAttributeValueButton;

    public SAMLAttributeValuesTable(List<StringToStringMap> attributeValues, WssEntryBase entry) {
        super(new BorderLayout());
        this.attributeValues = attributeValues;
        this.entry = entry;
        this.attributeValuesTableModel = new AttributeValuesTableModel();
        this.attributeValuesTable = new JTable(this.attributeValuesTableModel);
        this.attributeValuesTable.setTableHeader(null);
        this.attributeValuesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SAMLAttributeValuesTable.this.removeAttributeValueButton.setEnabled(SAMLAttributeValuesTable.this.attributeValuesTable.getSelectedRow() != -1);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.attributeValuesTable);
        scrollPane.setBackground(Color.WHITE);
        scrollPane.setOpaque(true);
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
        this.setPreferredSize(new Dimension(175, 150));
    }

    @Override
    public void setEnabled(boolean b) {
        this.attributeValuesTable.setEnabled(b);
        this.createAttributeValueButton.setEnabled(b);
        this.removeAttributeValueButton.setEnabled(b);
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.createAttributeValueButton = UISupport.createToolbarButton(new AddAttributeValueAction());
        toolbar.addFixed(this.createAttributeValueButton);
        this.removeAttributeValueButton = UISupport.createToolbarButton(new RemoveAttributeValueAction());
        toolbar.addFixed(this.removeAttributeValueButton);
        return toolbar;
    }

    private class RemoveAttributeValueAction
    extends AbstractAction {
        public RemoveAttributeValueAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the attribute value");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = SAMLAttributeValuesTable.this.attributeValuesTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Remove selected attribute value?", "Remove attribute value")) {
                SAMLAttributeValuesTable.this.attributeValuesTableModel.remove(row);
                SAMLAttributeValuesTable.this.entry.saveConfig();
            }
        }
    }

    private class AddAttributeValueAction
    extends AbstractAction {
        public AddAttributeValueAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new attribute value");
        }

        public void actionPerformed(ActionEvent e) {
            SAMLAttributeValuesTable.this.attributeValuesTableModel.addAttributeValues(new StringToStringMap());
            SAMLAttributeValuesTable.this.entry.saveConfig();
        }
    }

    private class AttributeValuesTableModel
    extends AbstractTableModel {
        private AttributeValuesTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return SAMLAttributeValuesTable.this.attributeValues.size();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            StringToStringMap attributeValue = (StringToStringMap)SAMLAttributeValuesTable.this.attributeValues.get(rowIndex);
            if (aValue == null) {
                aValue = "";
            }
            this.fireTableCellUpdated(rowIndex, 1);
            attributeValue.put("value", aValue.toString());
            SAMLAttributeValuesTable.this.entry.saveConfig();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            StringToStringMap attributeValue = (StringToStringMap)SAMLAttributeValuesTable.this.attributeValues.get(rowIndex);
            return attributeValue.get("value");
        }

        public void remove(int row) {
            SAMLAttributeValuesTable.this.attributeValues.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addAttributeValues(StringToStringMap map) {
            SAMLAttributeValuesTable.this.attributeValues.add(map);
            this.fireTableRowsInserted(SAMLAttributeValuesTable.this.attributeValues.size() - 1, SAMLAttributeValuesTable.this.attributeValues.size() - 1);
        }
    }
}

