/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.integration.loadui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.integration.impl.CajoClient;
import com.eviware.soapui.integration.loadui.ContextMapping;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationUtils {
    private static final String NOT_SELECTED = "-";
    public static final String CREATE_NEW_OPTION = "<Create New>";
    public static final String CREATE_ON_PROJECT_LEVEL = "<Project Level>";
    public static final int ADD_TO_PROJECT_LEVEL = 0;
    public static final int ADD_TO_SINGLE_TESTCASE = 1;
    public static final int ADD_TO_SEPARATE_TESTCASES = 2;
    public static final String LOADU_INFO_DIALOG_TITLE = "Target loadUI items info";

    public static String getIntegrationPort(String appName, String whichAppPort, String defaultPort) {
        String cajoPort = SoapUI.getSettings().getString(whichAppPort, defaultPort);
        try {
            Integer.parseInt(cajoPort);
        }
        catch (NumberFormatException nfe) {
            cajoPort = defaultPort;
            SoapUI.getSettings().setString(whichAppPort, cajoPort);
            SoapUI.log(appName + " integration port was reset to default value " + defaultPort + ", because its value was not correct!");
        }
        return cajoPort;
    }

    public static List<String> getProjectsNames() {
        return IntegrationUtils.invokeRemoteGettingStringList("getProjects", null);
    }

    public static List<String> getTestCasesNames() {
        return IntegrationUtils.invokeRemoteGettingStringList("getTestCases", null);
    }

    public static List<String> getSoapUISamplersNames(String projectName, String testCaseName) {
        return IntegrationUtils.invokeRemoteGettingStringList("getSoapUIRunners", new String[]{projectName, testCaseName});
    }

    public static List<String> getMockServiceRunnersNames(String projectName, String testCaseName) {
        return IntegrationUtils.invokeRemoteGettingStringList("getMockServiceRunners", new String[]{projectName, testCaseName});
    }

    private static List<String> invokeRemoteGettingStringList(String methodName, Object args) {
        try {
            return (List)CajoClient.getInstance().invoke(methodName, args);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static boolean isProjectOpened(String projectName) {
        boolean isOpened = false;
        try {
            isOpened = (Boolean)CajoClient.getInstance().invoke("isProjectOpened", new String[]{projectName});
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return isOpened;
    }

    public static String getOpenedProjectName() {
        String projectName = "";
        try {
            projectName = (String)CajoClient.getInstance().invoke("getOpenedProjectName", null);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return projectName;
    }

    public static void bringLoadUIToFront() {
        try {
            CajoClient.getInstance().invoke("bringToFront", null);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
    }

    public static void removeLoadUILoadedProject(File projectFile) {
        try {
            CajoClient.getInstance().invoke("removeLoadedSoapUIProject", projectFile);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
    }

    public static HashMap<String, String> createSoapUIRunner(String soapUIProjectPath, String soapUITestSuite, String soapUITestCase, String loadUIProject, String loadUITestCase, String loadUISoapUISampler, String generatorType, String analisysType) throws IOException {
        HashMap samplerSettings = new HashMap();
        try {
            SoapUI.log("createSoapUISampler for soapUIProjectPath=\"" + soapUIProjectPath + "\", soapUITestSuite=\"" + soapUITestSuite + "\", soapUITestCase=\"" + soapUITestCase + "\", loadUIProject=\"" + loadUIProject + "\", loadUITestCase=\"" + loadUITestCase + ", \"loadUISoapUISampler=\"" + loadUISoapUISampler + "\"");
            HashMap<String, Object> context = new ContextMapping(soapUIProjectPath, soapUITestSuite, soapUITestCase, loadUIProject, loadUITestCase, loadUISoapUISampler).setCreateSoapUIRunnerContext(generatorType, analisysType);
            samplerSettings = (HashMap)CajoClient.getInstance().invoke("createSoapUIRunner", context);
            IntegrationUtils.bringLoadUIToFront();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return samplerSettings;
    }

    public static HashMap<String, String> createMockServiceRunner(String soapUIProjectPath, String soapUIMockService, String path, String port, String loadUIProject, String loadUITestCase, String mockServiceRunner) throws IOException {
        HashMap mockServiceSettings = new HashMap();
        try {
            SoapUI.log("createMockRunner for soapUIProjectPath=\"" + soapUIProjectPath + "\", soapUIMockService=\"" + soapUIMockService + "\", path=\"" + path + "\", port=\"" + port + "\", loadUIProject=\"" + loadUIProject + "\", loadUITestCase=\"" + loadUITestCase + ", \"loadUIMockRunner=\"" + mockServiceRunner + "\"");
            HashMap<String, Object> context = new ContextMapping(soapUIProjectPath, soapUIMockService, "", "", loadUIProject, loadUITestCase, mockServiceRunner).setCreateMockServiceRunnerContext();
            mockServiceSettings = (HashMap)CajoClient.getInstance().invoke("createMockServiceRunner", context);
            IntegrationUtils.bringLoadUIToFront();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return mockServiceSettings;
    }

    public static HashMap<String, Object> exportLoadTestToLoadUI(WsdlLoadTest loadTest, String loadUIProject, String loadUITestCase, String loadUISoapUISampler) throws IOException {
        HashMap contextSettings = new HashMap();
        try {
            ContextMapping contextMapping = new ContextMapping(loadTest, loadUIProject, loadUITestCase, loadUISoapUISampler);
            HashMap<String, Object> context = contextMapping.setInitExportLoadTestToLoadUIContext();
            contextSettings = (HashMap)CajoClient.getInstance().invoke("exportSoapUILoadTestToLoadUI", context);
            if (contextMapping.isFinalTriggerMappingNeeded()) {
                CajoClient.getInstance().invoke("exportSoapUILoadTestToLoadUI", contextMapping.setFinalExportLoadTestToLoadUIContext(contextSettings));
            }
            IntegrationUtils.bringLoadUIToFront();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return contextSettings;
    }

    public static HashMap<String, String> exportMultipleLoadTestToLoadUI(WsdlTestCase testCase, String[] loadTests, String loadUIProject) throws IOException {
        HashMap<String, String> samplerSettings = new HashMap<String, String>();
        try {
            String loadTestName = loadTests[0];
            WsdlLoadTest loadTest = (WsdlLoadTest)testCase.getLoadTestByName(loadTestName);
            HashMap<String, Object> firstSamplerSettings = IntegrationUtils.exportLoadTestToLoadUI(loadTest, loadUIProject, CREATE_NEW_OPTION, CREATE_NEW_OPTION);
            String loadUIProjectAddedTo = (String)firstSamplerSettings.get("loaduiProjectName");
            for (int i = 1; i < loadTests.length; ++i) {
                loadTestName = loadTests[i];
                loadTest = (WsdlLoadTest)testCase.getLoadTestByName(loadTestName);
                IntegrationUtils.exportLoadTestToLoadUI(loadTest, loadUIProjectAddedTo, CREATE_NEW_OPTION, CREATE_NEW_OPTION);
            }
            IntegrationUtils.bringLoadUIToFront();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return samplerSettings;
    }

    public static HashMap<String, String> exportMultipleLoadTestToLoadUI(WsdlTestSuite testSuite, String[] loadTests, String loadUIProject) throws IOException {
        HashMap<String, String> samplerSettings = new HashMap<String, String>();
        try {
            WsdlLoadTest loadTest;
            String compositeLoadTestName = loadTests[0];
            String[] names = compositeLoadTestName.split(" - ");
            String testCaseName = names[0];
            String loadTestName = names[1];
            WsdlTestCase testCase = testSuite.getTestCaseByName(testCaseName);
            HashMap<Object, Object> firstSamplerSettings = new HashMap();
            String loadUIProjectAddedTo = "";
            if (testCase != null && (loadTest = (WsdlLoadTest)testCase.getLoadTestByName(loadTestName)) != null) {
                firstSamplerSettings = IntegrationUtils.exportLoadTestToLoadUI(loadTest, loadUIProject, CREATE_NEW_OPTION, CREATE_NEW_OPTION);
                loadUIProjectAddedTo = (String)firstSamplerSettings.get("loaduiProjectName");
            }
            for (int i = 1; i < loadTests.length; ++i) {
                compositeLoadTestName = loadTests[i];
                loadTestName = loadTests[i];
                WsdlLoadTest loadTest2 = (WsdlLoadTest)testCase.getLoadTestByName(loadTestName);
                testCaseName = names[0];
                loadTestName = names[1];
                testCase = testSuite.getTestCaseByName(testCaseName);
                if (testCase == null || (loadTest2 = (WsdlLoadTest)testCase.getLoadTestByName(loadTestName)) == null) continue;
                IntegrationUtils.exportLoadTestToLoadUI(loadTest2, loadUIProjectAddedTo, CREATE_NEW_OPTION, CREATE_NEW_OPTION);
            }
            IntegrationUtils.bringLoadUIToFront();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return samplerSettings;
    }

    public static void generateTestSuiteLoadTests(String soapUIProjectPath, String soapUITestSuite, String[] soapUITestCases, String loadUIProject, int levelToAdd) throws IOException {
        String firstTestCase = soapUITestCases[0];
        HashMap<Object, Object> firstSamplerSettings = new HashMap();
        String loadUITestCaseAddedTo = "";
        String loadUIProjectAddedTo = "";
        switch (levelToAdd) {
            case 0: {
                firstSamplerSettings = IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, firstTestCase, loadUIProject, null, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                loadUIProjectAddedTo = (String)firstSamplerSettings.get("loaduiProjectName");
                for (int i = 1; i < soapUITestCases.length; ++i) {
                    String testCase = soapUITestCases[i];
                    IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, testCase, loadUIProjectAddedTo, null, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                }
                break;
            }
            case 1: {
                firstSamplerSettings = IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, firstTestCase, loadUIProject, CREATE_NEW_OPTION, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                loadUITestCaseAddedTo = (String)firstSamplerSettings.get("loaduiTestCaseName");
                loadUIProjectAddedTo = (String)firstSamplerSettings.get("loaduiProjectName");
                for (int i = 1; i < soapUITestCases.length; ++i) {
                    String testCase = soapUITestCases[i];
                    IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, testCase, loadUIProjectAddedTo, loadUITestCaseAddedTo, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                }
                break;
            }
            case 2: {
                firstSamplerSettings = IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, firstTestCase, loadUIProject, CREATE_NEW_OPTION, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                loadUIProjectAddedTo = (String)firstSamplerSettings.get("loaduiProjectName");
                for (int i = 1; i < soapUITestCases.length; ++i) {
                    String testCase = soapUITestCases[i];
                    IntegrationUtils.createSoapUIRunner(soapUIProjectPath, soapUITestSuite, testCase, loadUIProjectAddedTo, CREATE_NEW_OPTION, CREATE_NEW_OPTION, NOT_SELECTED, NOT_SELECTED);
                }
                break;
            }
        }
    }

    public static void closeOpenedLoadUIProject(boolean saveProject) {
        try {
            if (saveProject) {
                CajoClient.getInstance().invoke("saveOpenedProject", null);
            }
            CajoClient.getInstance().invoke("closeOpenedProject", null);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
    }

    public static Boolean isOpenedProjectDirty() {
        Boolean result = null;
        try {
            result = (Boolean)CajoClient.getInstance().invoke("isOpenedProjectDirty", null);
        }
        catch (Exception e) {
            SoapUI.log.error((Object)"Error while invoking cajo server in loadui ", (Throwable)e);
        }
        return result;
    }

    public static boolean checkOpenedLoadUIProjectForClose() {
        String openedProjectName = IntegrationUtils.getOpenedProjectName();
        if (StringUtils.isNullOrEmpty(openedProjectName)) {
            return false;
        }
        Boolean close = null;
        Boolean saveProject = null;
        Boolean isDirty = IntegrationUtils.isOpenedProjectDirty();
        close = isDirty != null && isDirty != false ? Boolean.valueOf((saveProject = UISupport.confirmOrCancel("Save currently open [" + openedProjectName + "] loadUI project before closing?", "Save loadUI project")) != null) : Boolean.valueOf(UISupport.confirm("Currently open [" + openedProjectName + "] loadUI project will be closed. Continue?", "Close loadUI project"));
        boolean quit = true;
        if (close != null && close.booleanValue()) {
            IntegrationUtils.closeOpenedLoadUIProject(saveProject != null && saveProject != false);
            quit = false;
        }
        return quit;
    }

    public static String[] getAvailableProjects() {
        List<String> availableProjects = IntegrationUtils.getProjectsNames();
        availableProjects.add(CREATE_NEW_OPTION);
        String[] names = new String[availableProjects.size()];
        for (int c = 0; c < availableProjects.size(); ++c) {
            names[c] = availableProjects.get(c);
        }
        return names;
    }

    public static String[] getAvailableTestCases(String projectName) {
        ArrayList<String> availableTestCases = new ArrayList<String>();
        if (!projectName.equals(CREATE_NEW_OPTION) && IntegrationUtils.isProjectOpened(projectName)) {
            availableTestCases.addAll(IntegrationUtils.getTestCasesNames());
        }
        availableTestCases.add(CREATE_ON_PROJECT_LEVEL);
        availableTestCases.add(CREATE_NEW_OPTION);
        String[] names = new String[availableTestCases.size()];
        for (int c = 0; c < availableTestCases.size(); ++c) {
            names[c] = (String)availableTestCases.get(c);
        }
        return names;
    }

    public static String[] getAvailableRunners(String projectName, String testCaseName) {
        ArrayList<String> availableSamplers = new ArrayList<String>();
        if (!projectName.equals(CREATE_NEW_OPTION) && IntegrationUtils.isProjectOpened(projectName)) {
            availableSamplers.addAll(IntegrationUtils.getSoapUISamplersNames(projectName, testCaseName));
        }
        availableSamplers.add(CREATE_NEW_OPTION);
        String[] names = new String[availableSamplers.size()];
        for (int c = 0; c < availableSamplers.size(); ++c) {
            names[c] = (String)availableSamplers.get(c);
        }
        return names;
    }

    public static String[] getAvailableMockServiceRunners(String projectName, String testCaseName) {
        ArrayList<String> availableMockServiceRunners = new ArrayList<String>();
        if (!projectName.equals(CREATE_NEW_OPTION) && IntegrationUtils.isProjectOpened(projectName)) {
            availableMockServiceRunners.addAll(IntegrationUtils.getMockServiceRunnersNames(projectName, testCaseName));
        }
        availableMockServiceRunners.add(CREATE_NEW_OPTION);
        String[] names = new String[availableMockServiceRunners.size()];
        for (int c = 0; c < availableMockServiceRunners.size(); ++c) {
            names[c] = (String)availableMockServiceRunners.get(c);
        }
        return names;
    }

    public static boolean forceSaveProject(WsdlProject project) {
        if (UISupport.confirm("Project needs to be saved before it gets exported! Save it?", "Save Project")) {
            try {
                if (project.save()) {
                    return true;
                }
                UISupport.showInfoMessage("Export Operation Aborted!");
                return false;
            }
            catch (IOException e) {
                SoapUI.logError(e);
                UISupport.showErrorMessage("Error saving project file!. Export Operation Aborted!");
                return false;
            }
        }
        UISupport.showInfoMessage("Export Operation Aborted!");
        return false;
    }
}

