/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.monitor.PropertySupport;
import com.eviware.soapui.monitor.SoapUIJettyThreadPool;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.log.JettyLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.thread.ThreadPool;

public class JettyMockEngine
implements MockEngine {
    public static final Logger log = Logger.getLogger(JettyMockEngine.class);
    private Server server;
    private Map<Integer, Map<String, List<MockRunner>>> runners = new HashMap<Integer, Map<String, List<MockRunner>>>();
    private Map<Integer, SoapUIConnector> connectors = new HashMap<Integer, SoapUIConnector>();
    private List<MockRunner> mockRunners = new ArrayList<MockRunner>();
    private SslSocketConnector sslConnector;
    private boolean addedSslConnector;

    public JettyMockEngine() {
        System.setProperty("org.mortbay.log.class", JettyLogger.class.getName());
    }

    public boolean hasRunningMock(MockService mockService) {
        for (MockRunner runner : this.mockRunners) {
            if (runner.getMockService() != mockService) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startMockService(MockRunner runner) throws Exception {
        if (this.server == null) {
            this.initServer();
        }
        Server server = this.server;
        synchronized (server) {
            String path;
            Map<String, List<MockRunner>> map;
            WsdlMockService mockService = (WsdlMockService)runner.getMockService();
            int port = mockService.getPort();
            if (SoapUI.getSettings().getBoolean(SSLSettings.ENABLE_MOCK_SSL) && !this.addedSslConnector) {
                this.updateSslConnectorSettings();
                this.server.addConnector((Connector)this.sslConnector);
                this.addedSslConnector = true;
            } else {
                if (this.addedSslConnector) {
                    this.server.removeConnector((Connector)this.sslConnector);
                }
                this.addedSslConnector = false;
            }
            if (!this.runners.containsKey(port)) {
                SoapUIConnector connector;
                block14: {
                    boolean wasRunning;
                    String host;
                    connector = new SoapUIConnector();
                    PropertySupport.applySystemProperties((Object)connector, "soapui.mock.connector", runner.getMockService());
                    connector.setPort(port);
                    if (this.sslConnector != null) {
                        connector.setConfidentialPort(this.sslConnector.getPort());
                    }
                    if (mockService.getBindToHostOnly() && StringUtils.hasContent(host = PropertyExpander.expandProperties(mockService, mockService.getHost()))) {
                        connector.setHost(host);
                    }
                    if (wasRunning = this.server.isRunning()) {
                        this.server.stop();
                    }
                    this.server.addConnector((Connector)connector);
                    try {
                        this.server.start();
                    }
                    catch (RuntimeException e) {
                        UISupport.showErrorMessage(e);
                        this.server.removeConnector((Connector)connector);
                        if (!wasRunning) break block14;
                        this.server.start();
                        return;
                    }
                }
                this.connectors.put(new Integer(port), connector);
                this.runners.put(new Integer(port), new HashMap());
            }
            if (!(map = this.runners.get(port)).containsKey(path = mockService.getPath())) {
                map.put(path, new ArrayList());
            }
            map.get(path).add(runner);
            this.mockRunners.add(runner);
            log.info((Object)("Started mockService [" + mockService.getName() + "] on port [" + port + "] at path [" + path + "]"));
        }
    }

    private void initServer() throws Exception {
        this.server = new Server();
        this.server.setThreadPool((ThreadPool)new SoapUIJettyThreadPool());
        this.server.setHandler((Handler)new ServerHandler());
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)new MockRequestLog());
        this.server.addHandler((Handler)logHandler);
        this.sslConnector = new SslSocketConnector();
        this.sslConnector.setMaxIdleTime(30000);
    }

    private void updateSslConnectorSettings() {
        this.sslConnector.setKeystore(SoapUI.getSettings().getString(SSLSettings.MOCK_KEYSTORE, null));
        this.sslConnector.setPassword(SoapUI.getSettings().getString(SSLSettings.MOCK_PASSWORD, null));
        this.sslConnector.setKeyPassword(SoapUI.getSettings().getString(SSLSettings.MOCK_KEYSTORE_PASSWORD, null));
        String truststore = SoapUI.getSettings().getString(SSLSettings.MOCK_TRUSTSTORE, null);
        if (StringUtils.hasContent(truststore)) {
            this.sslConnector.setTruststore(truststore);
            this.sslConnector.setTrustPassword(SoapUI.getSettings().getString(SSLSettings.MOCK_TRUSTSTORE_PASSWORD, null));
        }
        this.sslConnector.setPort((int)SoapUI.getSettings().getLong(SSLSettings.MOCK_PORT, 443L));
        this.sslConnector.setNeedClientAuth(SoapUI.getSettings().getBoolean(SSLSettings.CLIENT_AUTHENTICATION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopMockService(MockRunner runner) {
        Server server = this.server;
        synchronized (server) {
            MockService mockService = runner.getMockService();
            Integer port = new Integer(mockService.getPort());
            Map<String, List<MockRunner>> map = this.runners.get(port);
            if (map == null || !map.containsKey(mockService.getPath())) {
                return;
            }
            map.get(mockService.getPath()).remove(runner);
            if (map.get(mockService.getPath()).isEmpty()) {
                map.remove(mockService.getPath());
            }
            this.mockRunners.remove(runner);
            log.info((Object)("Stopped MockService [" + mockService.getName() + "] on port [" + port + "]"));
            if (!map.isEmpty() || SoapUI.getSettings().getBoolean(HttpSettings.LEAVE_MOCKENGINE)) return;
            SoapUIConnector connector = this.connectors.get(port);
            if (connector == null) {
                log.warn((Object)("Missing connectors on port [" + port + "]"));
                return;
            }
            try {
                log.info((Object)("Stopping connector on port " + port));
                if (!connector.waitUntilIdle(5000L)) {
                    log.warn((Object)"Failed to wait for idle.. stopping connector anyway..");
                }
                connector.stop();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            this.server.removeConnector((Connector)connector);
            this.runners.remove(port);
            if (!this.runners.isEmpty()) return;
            try {
                log.info((Object)"No more connectors.. stopping server");
                this.server.stop();
                if (this.sslConnector == null) return;
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            {
                // empty if block
            }
            return;
        }
    }

    public MockRunner[] getMockRunners() {
        return this.mockRunners.toArray(new MockRunner[this.mockRunners.size()]);
    }

    private class MockRequestLog
    extends AbstractLifeCycle
    implements RequestLog {
        private MockRequestLog() {
        }

        public void log(Request request, Response response) {
            String line;
            BufferedReader reader;
            String str;
            ByteArrayOutputStream byteArrayOutputStream;
            if (!SoapUI.getSettings().getBoolean(HttpSettings.ENABLE_MOCK_WIRE_LOG)) {
                return;
            }
            if (SoapUI.getLogMonitor() == null || SoapUI.getLogMonitor().getLogArea("jetty log") == null || SoapUI.getLogMonitor().getLogArea("jetty log").getLoggers() == null) {
                return;
            }
            Logger logger = SoapUI.getLogMonitor().getLogArea("jetty log").getLoggers()[0];
            try {
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream instanceof CapturingServletInputStream) {
                    byteArrayOutputStream = ((CapturingServletInputStream)inputStream).captureOutputStream;
                    str = request.toString() + byteArrayOutputStream.toString();
                    reader = new BufferedReader(new StringReader(str));
                    ((CapturingServletInputStream)inputStream).captureOutputStream = new ByteArrayOutputStream();
                    line = reader.readLine();
                    while (line != null) {
                        logger.info((Object)(">> \"" + line + "\""));
                        line = reader.readLine();
                    }
                }
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
            try {
                ServletOutputStream outputStream = response.getOutputStream();
                if (outputStream instanceof CapturingServletOutputStream) {
                    byteArrayOutputStream = ((CapturingServletOutputStream)outputStream).captureOutputStream;
                    str = request.toString() + byteArrayOutputStream.toString();
                    reader = new BufferedReader(new StringReader(str));
                    ((CapturingServletOutputStream)outputStream).captureOutputStream = new ByteArrayOutputStream();
                    line = reader.readLine();
                    while (line != null) {
                        logger.info((Object)("<< \"" + line + "\""));
                        line = reader.readLine();
                    }
                }
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
    }

    private class ServerHandler
    extends AbstractHandler {
        private ServerHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            Map map = (Map)JettyMockEngine.this.runners.get(request.getLocalPort());
            if (map == null && JettyMockEngine.this.sslConnector != null && request.getLocalPort() == JettyMockEngine.this.sslConnector.getPort()) {
                for (Map runnerMap : JettyMockEngine.this.runners.values()) {
                    if (!runnerMap.containsKey(request.getPathInfo())) continue;
                    map = runnerMap;
                    break;
                }
            }
            if (map != null) {
                List wsdlMockRunners = (List)map.get(request.getPathInfo());
                if (wsdlMockRunners == null) {
                    for (String root : map.keySet()) {
                        if (!request.getPathInfo().startsWith(root)) continue;
                        wsdlMockRunners = (List)map.get(root);
                    }
                }
                if (wsdlMockRunners != null) {
                    try {
                        DispatchException ex = null;
                        MockResult result = null;
                        for (MockRunner wsdlMockRunner : wsdlMockRunners) {
                            if (!wsdlMockRunner.isRunning()) continue;
                            try {
                                result = wsdlMockRunner.dispatchRequest(request, response);
                                if (result == null) continue;
                                result.finish();
                                break;
                            }
                            catch (DispatchException e) {
                                ex = e;
                            }
                        }
                        if (ex != null && result == null) {
                            throw ex;
                        }
                    }
                    catch (Exception e) {
                        SoapUI.logError(e);
                        response.setStatus(500);
                        response.setContentType("text/html");
                        response.getWriter().print(SoapMessageBuilder.buildFault("Server", e.getMessage(), SoapVersion.Utils.getSoapVersionForContentType(request.getContentType(), SoapVersion.Soap11)));
                    }
                } else {
                    this.printMockServiceList(response);
                }
            } else {
                this.printMockServiceList(response);
            }
            response.flushBuffer();
        }

        private void printMockServiceList(HttpServletResponse response) throws IOException {
            response.setStatus(200);
            response.setContentType("text/html");
            MockRunner[] mockRunners = JettyMockEngine.this.getMockRunners();
            PrintWriter out = response.getWriter();
            out.print("<html><body><p>There are currently " + mockRunners.length + " running soapUI MockServices</p><ul>");
            for (MockRunner mockRunner : mockRunners) {
                out.print("<li><a href=\"");
                out.print(mockRunner.getMockService().getPath() + "?WSDL");
                out.print("\">" + mockRunner.getMockService().getName() + "</a></li>");
            }
            out.print("</ul></p></body></html>");
        }
    }

    private class CapturingServletInputStream
    extends ServletInputStream {
        private ServletInputStream inputStream;
        private ByteArrayOutputStream captureOutputStream = new ByteArrayOutputStream();

        public CapturingServletInputStream(ServletInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int read() throws IOException {
            int i = this.inputStream.read();
            this.captureOutputStream.write(i);
            return i;
        }

        public int readLine(byte[] bytes, int i, int i1) throws IOException {
            int result = this.inputStream.readLine(bytes, i, i1);
            this.captureOutputStream.write(bytes, i, i1);
            return result;
        }

        public int read(byte[] b) throws IOException {
            int i = this.inputStream.read(b);
            this.captureOutputStream.write(b);
            return i;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.inputStream.read(b, off, len);
            if (result != -1) {
                this.captureOutputStream.write(b, off, result);
            }
            return result;
        }

        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        public int available() throws IOException {
            return this.inputStream.available();
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        public void reset() throws IOException {
            this.inputStream.reset();
        }
    }

    private class CapturingServletOutputStream
    extends ServletOutputStream {
        private ServletOutputStream outputStream;
        private ByteArrayOutputStream captureOutputStream = new ByteArrayOutputStream();

        public CapturingServletOutputStream(ServletOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void print(String s) throws IOException {
            this.outputStream.print(s);
        }

        public void print(boolean b) throws IOException {
            this.outputStream.print(b);
        }

        public void print(char c) throws IOException {
            this.outputStream.print(c);
        }

        public void print(int i) throws IOException {
            this.outputStream.print(i);
        }

        public void print(long l) throws IOException {
            this.outputStream.print(l);
        }

        public void print(float v) throws IOException {
            this.outputStream.print(v);
        }

        public void print(double v) throws IOException {
            this.outputStream.print(v);
        }

        public void println() throws IOException {
            this.outputStream.println();
        }

        public void println(String s) throws IOException {
            this.outputStream.println(s);
        }

        public void println(boolean b) throws IOException {
            this.outputStream.println(b);
        }

        public void println(char c) throws IOException {
            this.outputStream.println(c);
        }

        public void println(int i) throws IOException {
            this.outputStream.println(i);
        }

        public void println(long l) throws IOException {
            this.outputStream.println(l);
        }

        public void println(float v) throws IOException {
            this.outputStream.println(v);
        }

        public void println(double v) throws IOException {
            this.outputStream.println(v);
        }

        public void write(int b) throws IOException {
            this.captureOutputStream.write(b);
            this.outputStream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.captureOutputStream.write(b);
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.captureOutputStream.write(b, off, len);
            this.outputStream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
        }
    }

    private class BufferedServletInputStream
    extends ServletInputStream {
        private InputStream source = null;
        private byte[] data = null;
        private InputStream buffer1 = null;

        public BufferedServletInputStream(InputStream is) {
            this.source = is;
        }

        public InputStream getBuffer() throws IOException {
            if (this.source.available() > 0) {
                this.data = null;
            }
            if (this.data == null) {
                ByteArrayOutputStream out = Tools.readAll(this.source, 0L);
                this.data = out.toByteArray();
            }
            if (this.buffer1 == null) {
                this.buffer1 = new ByteArrayInputStream(this.data);
            }
            return this.buffer1;
        }

        public int read() throws IOException {
            int i = this.getBuffer().read();
            return i;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int c;
            if (len <= 0) {
                return 0;
            }
            int count = 0;
            while ((c = this.read()) != -1) {
                b[off++] = (byte)c;
                if (c != 10 && ++count != len) continue;
            }
            return count > 0 ? count : -1;
        }

        public int read(byte[] b) throws IOException {
            int i = this.getBuffer().read(b);
            return i;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.getBuffer().read(b, off, len);
            return result;
        }

        public long skip(long n) throws IOException {
            return this.getBuffer().skip(n);
        }

        public int available() throws IOException {
            return this.getBuffer().available();
        }

        public void close() throws IOException {
            this.getBuffer().close();
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            this.buffer1 = null;
        }
    }

    private class SoapUIHttpConnection
    extends HttpConnection {
        private CapturingServletInputStream capturingServletInputStream;
        private BufferedServletInputStream bufferedServletInputStream;
        private CapturingServletOutputStream capturingServletOutputStream;

        public SoapUIHttpConnection(Connector connector, EndPoint endPoint, Server server) {
            super(connector, endPoint, server);
        }

        public ServletInputStream getInputStream() {
            if (SoapUI.getSettings().getBoolean(HttpSettings.ENABLE_MOCK_WIRE_LOG)) {
                if (this.capturingServletInputStream == null) {
                    this.capturingServletInputStream = new CapturingServletInputStream(super.getInputStream());
                    this.bufferedServletInputStream = new BufferedServletInputStream((InputStream)((Object)this.capturingServletInputStream));
                }
            } else {
                this.bufferedServletInputStream = new BufferedServletInputStream((InputStream)super.getInputStream());
            }
            return this.bufferedServletInputStream;
        }

        public ServletOutputStream getOutputStream() {
            if (SoapUI.getSettings().getBoolean(HttpSettings.ENABLE_MOCK_WIRE_LOG)) {
                if (this.capturingServletOutputStream == null) {
                    this.capturingServletOutputStream = new CapturingServletOutputStream(super.getOutputStream());
                }
                return this.capturingServletOutputStream;
            }
            return super.getOutputStream();
        }
    }

    private class SoapUIConnector
    extends SelectChannelConnector {
        private Set<HttpConnection> connections = new HashSet<HttpConnection>();

        private SoapUIConnector() {
        }

        protected void connectionClosed(HttpConnection arg0) {
            super.connectionClosed(arg0);
            this.connections.remove(arg0);
        }

        protected void connectionOpened(HttpConnection arg0) {
            super.connectionOpened(arg0);
            this.connections.add(arg0);
        }

        protected Connection newConnection(SocketChannel socketChannel, SelectChannelEndPoint selectChannelEndPoint) {
            return new SoapUIHttpConnection((Connector)this, (EndPoint)selectChannelEndPoint, this.getServer());
        }

        public boolean waitUntilIdle(long maxwait) throws Exception {
            while (maxwait > 0L && this.hasActiveConnections()) {
                System.out.println("Waiting for active connections to finish..");
                Thread.sleep(500L);
                maxwait -= 500L;
            }
            return !this.hasActiveConnections();
        }

        private boolean hasActiveConnections() {
            for (HttpConnection connection : this.connections) {
                if (connection.isIdle()) continue;
                return true;
            }
            return false;
        }
    }
}

