/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.GroovySecurityScanConfig;
import com.eviware.soapui.config.ScriptConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.GroovySecurityScanPanel;
import com.eviware.soapui.security.ui.SecurityScanConfigPanel;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import java.util.List;

public class GroovySecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String SCRIPT_PROPERTY = GroovySecurityScan.class.getName() + "@script";
    public static final String TYPE = "GroovySecurityScan";
    public static final String NAME = "Custom Script";
    private GroovySecurityScanConfig groovyscc;
    private Boolean hasNext = true;
    private Object scriptResult;
    private SoapUIScriptEngine scriptEngine;
    private StringToStringMap parameters;
    private static final String PARAMETERS_INITIALIZED = "parameterInitialized";

    public GroovySecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null) {
            this.groovyscc = GroovySecurityScanConfig.Factory.newInstance();
            this.groovyscc.setExecuteScript(ScriptConfig.Factory.newInstance());
            this.groovyscc.getExecuteScript().setLanguage("groovy");
            this.groovyscc.getExecuteScript().setStringValue("");
            config.setConfig(this.groovyscc);
        } else {
            this.groovyscc = (GroovySecurityScanConfig)config.getConfig();
            if (this.groovyscc.getExecuteScript() == null) {
                this.groovyscc.setExecuteScript(ScriptConfig.Factory.newInstance());
                this.groovyscc.getExecuteScript().setLanguage("groovy");
                this.groovyscc.getExecuteScript().setStringValue("");
            }
        }
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
        this.getExecutionStrategy().setImmutable(true);
    }

    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        if (!context.hasProperty(PARAMETERS_INITIALIZED)) {
            this.parameters = new StringToStringMap();
            this.initParameters(this.parameters);
            context.put(PARAMETERS_INITIALIZED, (Object)"true");
            this.hasNext = true;
        }
        if (!this.hasNext.booleanValue()) {
            context.remove(PARAMETERS_INITIALIZED);
            this.scriptEngine.clearVariables();
        }
        return this.hasNext;
    }

    private void initParameters(StringToStringMap parameters2) {
        List<SecurityCheckedParameter> scpList = this.getParameterHolder().getParameterList();
        for (SecurityCheckedParameter scp : scpList) {
            this.parameters.put(scp.getLabel(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        this.scriptEngine.setScript(this.groovyscc.getExecuteScript().getStringValue());
        this.scriptEngine.setVariable("context", context);
        this.scriptEngine.setVariable("testStep", testStep);
        this.scriptEngine.setVariable("securityScan", this);
        this.scriptEngine.setVariable("parameters", this.parameters);
        this.scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        try {
            try {
                this.scriptResult = this.scriptEngine.run();
                this.hasNext = this.castResultToBoolean(this.scriptResult);
                XmlObjectTreeModel model = null;
                for (SecurityCheckedParameter scp : this.getParameterHolder().getParameterList()) {
                    if (this.parameters.containsKey(scp.getLabel()) && this.parameters.get(scp.getLabel()) != null) {
                        if (scp.isChecked() && scp.getXpath().trim().length() > 0) {
                            model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
                            XmlObjectTreeModel.XmlTreeNode[] treeNodes = null;
                            treeNodes = model.selectTreeNodes(context.expand(scp.getXpath()));
                            if (treeNodes.length > 0) {
                                XmlObjectTreeModel.XmlTreeNode mynode = treeNodes[0];
                                mynode.setValue(1, this.parameters.get(scp.getLabel()));
                            }
                            this.updateRequestProperty(testStep, scp.getName(), model.getXmlObject().toString());
                            continue;
                        }
                        this.updateRequestProperty(testStep, scp.getName(), (String)this.parameters.get(scp.getLabel()));
                        continue;
                    }
                    if (!this.parameters.containsKey(scp.getLabel()) || this.parameters.get(scp.getLabel()) != null) continue;
                    this.parameters.remove(scp.getLabel());
                }
                MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)securityTestRunner), context));
                this.createMessageExchange(this.clearNullValues(this.parameters), message, context);
            }
            catch (Exception e) {
                SoapUI.logError(e);
                this.hasNext = false;
                Object var10_11 = null;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            throw throwable;
        }
    }

    private Boolean castResultToBoolean(Object scriptResult2) {
        try {
            this.hasNext = (Boolean)scriptResult2;
            if (this.hasNext == null) {
                this.hasNext = false;
                SoapUI.ensureGroovyLog().error((Object)"You must return Boolean value from groovy script!");
            }
        }
        catch (Exception e) {
            this.hasNext = false;
            SoapUI.ensureGroovyLog().error((Object)"You must return Boolean value from groovy script!");
        }
        return this.hasNext;
    }

    private StringToStringMap clearNullValues(StringToStringMap parameters) {
        StringToStringMap params = new StringToStringMap();
        for (String key : parameters.keySet()) {
            if (parameters.get(key) == null) continue;
            params.put(key, parameters.get(key));
        }
        return params;
    }

    private void updateRequestProperty(TestStep testStep, String propertyName, String propertyValue) {
        testStep.getProperty(propertyName).setValue(propertyValue);
    }

    public void setExecuteScript(String script) {
        String old = this.getExecuteScript();
        this.groovyscc.getExecuteScript().setStringValue(script);
        this.notifyPropertyChanged(SCRIPT_PROPERTY, old, script);
    }

    public String getExecuteScript() {
        return this.groovyscc.getExecuteScript().getStringValue();
    }

    public SecurityScanConfigPanel getComponent() {
        return new GroovySecurityScanPanel(this);
    }

    public String getType() {
        return TYPE;
    }

    public String getConfigDescription() {
        return "Configuration for Custom Script Security Scan";
    }

    public String getConfigName() {
        return "Configuration for Custom Script Security Scan";
    }

    public String getHelpURL() {
        return "http://soapui.org/Security/script-custom-scan.html";
    }
}

