/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.model.security.SecurityParametersTableModel;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.security.assertion.SecurityAssertionPanel;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.SecurityCheckedParametersTablePanel;
import com.eviware.soapui.security.ui.SecurityConfigurationDialogBuilder;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.XFormRadioGroup;
import com.eviware.x.impl.swing.JFormDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class SecurityConfigurationDialog
extends SimpleDialog {
    private SecurityScan securityCheck;
    private boolean result;
    private JTabbedPane tabs;
    private SecurityCheckedParametersTablePanel parametersTable;
    private SecurityAssertionPanel securityAssertionPanel;
    private XFormDialog strategyDialog;

    public SecurityConfigurationDialog(SecurityScan securityCheck) {
        super(securityCheck.getName(), securityCheck.getDescription(), securityCheck.getHelpURL());
        this.securityCheck = securityCheck;
    }

    public SecurityScan getSecurityScan() {
        return this.securityCheck;
    }

    protected Component buildContent() {
        JPanel mainPanel = new JPanel();
        if (this.securityCheck instanceof AbstractSecurityScanWithProperties) {
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel topPanel = UISupport.createEmptyPanel(0, 0, 10, 0);
            topPanel.add(this.buildParametersTable(), "Center");
            JPanel p = UISupport.createEmptyPanel(5, 0, 5, 0);
            JLabel jLabel = new JLabel("Parameters:");
            jLabel.setPreferredSize(new Dimension(72, 20));
            p.add((Component)jLabel, "North");
            topPanel.add((Component)p, "North");
            JComponent component = this.securityCheck.getComponent();
            if (component != null) {
                topPanel.add((Component)component, "South");
            }
            mainPanel.add(topPanel);
        } else {
            mainPanel.setLayout(new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JComponent component = this.securityCheck.getComponent();
            if (component != null) {
                JPanel topPanel = UISupport.createEmptyPanel(0, 0, 10, 10);
                topPanel.add((Component)component, "South");
                mainPanel.add((Component)topPanel, "North");
            }
        }
        Dimension prefSize = mainPanel.getPreferredSize();
        int prefHeight = (int)(prefSize.getHeight() + 170.0);
        int prefWidth = (int)Math.max(prefSize.getWidth(), 600.0);
        mainPanel.setPreferredSize(new Dimension(prefWidth, prefHeight));
        mainPanel.add(this.buildTabs(), "Center");
        return mainPanel;
    }

    protected Component buildParametersTable() {
        this.parametersTable = new SecurityCheckedParametersTablePanel(new SecurityParametersTableModel(((AbstractSecurityScanWithProperties)this.securityCheck).getParameterHolder()), this.securityCheck.getTestStep().getProperties(), (AbstractSecurityScanWithProperties)this.securityCheck);
        this.parametersTable.setPreferredSize(new Dimension(400, 150));
        this.parametersTable.setMinimumSize(new Dimension(400, 150));
        this.parametersTable.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        return this.parametersTable;
    }

    protected Component buildTabs() {
        this.tabs = new JTabbedPane();
        this.securityAssertionPanel = new SecurityAssertionPanel(this.securityCheck);
        this.tabs.addTab("Assertions", this.securityAssertionPanel);
        this.tabs.addTab("Strategy", this.buildStrategyTab());
        JComponent advancedSettingsPanel = this.securityCheck.getAdvancedSettingsPanel();
        if (advancedSettingsPanel != null) {
            this.tabs.addTab("Advanced", new JScrollPane(advancedSettingsPanel));
        }
        this.tabs.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.tabs.setPreferredSize(new Dimension(400, 150));
        return this.tabs;
    }

    protected Component buildStrategyTab() {
        this.strategyDialog = ADialogBuilder.buildDialog(SecurityConfigurationDialogBuilder.Strategy.class, null);
        XFormRadioGroup strategy = (XFormRadioGroup)this.strategyDialog.getFormField("Select strategy");
        Object[] strategyOptions = new String[]{"One by One", "All At Once"};
        strategy.setOptions(strategyOptions);
        if (this.securityCheck.getExecutionStrategy().getStrategy() == StrategyTypeConfig.NO_STRATEGY) {
            strategy.setEnabled(false);
        } else if (this.securityCheck.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ONE_BY_ONE) {
            strategy.setValue((String)strategyOptions[0]);
        } else {
            strategy.setValue((String)strategyOptions[1]);
        }
        if (this.securityCheck.getExecutionStrategy().getImmutable().booleanValue()) {
            strategy.setDisabled();
        }
        strategy.addFormFieldListener(new XFormFieldListener((String[])strategyOptions){
            final /* synthetic */ String[] val$strategyOptions;
            {
                this.val$strategyOptions = stringArray;
            }

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (newValue.equals(this.val$strategyOptions[0])) {
                    SecurityConfigurationDialog.this.securityCheck.getExecutionStrategy().setStrategy(StrategyTypeConfig.ONE_BY_ONE);
                } else {
                    SecurityConfigurationDialog.this.securityCheck.getExecutionStrategy().setStrategy(StrategyTypeConfig.ALL_AT_ONCE);
                }
            }
        });
        XFormField delay = this.strategyDialog.getFormField("Request Delay (ms)");
        delay.setValue(String.valueOf(this.securityCheck.getExecutionStrategy().getDelay()));
        delay.addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                try {
                    if ("".equals(newValue)) {
                        return;
                    }
                    Integer.valueOf(newValue);
                    SecurityConfigurationDialog.this.securityCheck.getExecutionStrategy().setDelay(Integer.valueOf(newValue));
                }
                catch (Exception e) {
                    UISupport.showErrorMessage("Delay value must be integer number");
                }
            }
        });
        XFormField applyToFailedTests = this.strategyDialog.getFormField("Apply to Failed TestSteps");
        applyToFailedTests.setValue(String.valueOf(this.securityCheck.isApplyForFailedStep()));
        applyToFailedTests.addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                SecurityConfigurationDialog.this.securityCheck.setApplyForFailedTestStep(Boolean.parseBoolean(newValue));
            }
        });
        XFormField runOnlyOnce = this.strategyDialog.getFormField("Run only once");
        runOnlyOnce.setValue(String.valueOf(this.securityCheck.isRunOnlyOnce()));
        runOnlyOnce.addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                SecurityConfigurationDialog.this.securityCheck.setRunOnlyOnce(Boolean.parseBoolean(newValue));
            }
        });
        return ((JFormDialog)this.strategyDialog).getPanel();
    }

    protected boolean handleOk() {
        this.result = true;
        return true;
    }

    public boolean configure() {
        this.result = false;
        this.setVisible(true);
        return this.result;
    }

    public void release() {
        if (this.strategyDialog != null) {
            this.strategyDialog.release();
            this.strategyDialog = null;
        }
        this.securityAssertionPanel.release();
        this.securityAssertionPanel = null;
        this.securityCheck = null;
        this.tabs.removeAll();
        this.tabs = null;
        this.dispose();
    }
}

