/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.AbstractEditorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelItemPropertyEditorModel<T extends ModelItem>
extends AbstractEditorModel
implements PropertyChangeListener {
    private T modelItem;
    private String propertyName;

    public ModelItemPropertyEditorModel(T modelItem, String propertyName) {
        this.modelItem = modelItem;
        this.propertyName = propertyName;
        modelItem.addPropertyChangeListener(propertyName, this);
    }

    @Override
    public Settings getSettings() {
        return this.modelItem.getSettings();
    }

    @Override
    public String getEditorText() {
        try {
            Object value = PropertyUtils.getSimpleProperty(this.modelItem, (String)this.propertyName);
            return value == null ? "" : String.valueOf(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setEditorText(String text) {
        try {
            PropertyUtils.setSimpleProperty(this.modelItem, (String)this.propertyName, (Object)text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        super.release();
        this.modelItem.removePropertyChangeListener(this.propertyName, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireEditorTextChanged(String.valueOf(evt.getOldValue()), String.valueOf(evt.getNewValue()));
    }
}

