/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFormComponent;
import com.eviware.soapui.support.types.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StringListFormComponent
extends JPanel
implements JFormComponent,
ActionListener {
    private DefaultListModel listModel;
    private String defaultValue = null;
    private JButton addButton;
    private JButton removeButton;
    private JList list;
    private JButton editButton;
    private Box buttonBox;
    private List<JButton> buttons = new ArrayList<JButton>();

    public StringListFormComponent(String tooltip) {
        this(tooltip, false, null);
    }

    public StringListFormComponent(String tooltip, boolean editOnly) {
        this(tooltip, editOnly, null);
    }

    public StringListFormComponent(String tooltip, boolean editOnly, String defaultValue) {
        super(new BorderLayout());
        this.defaultValue = defaultValue;
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setToolTipText(tooltip);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(300, 70));
        this.add((Component)scrollPane, "Center");
        this.buttonBox = new Box(1);
        this.buttonBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        if (!editOnly) {
            this.addButton = new JButton("Add..");
            this.addButton.addActionListener(this);
            this.buttonBox.add(this.addButton);
            this.buttonBox.add(Box.createVerticalStrut(5));
        }
        this.editButton = new JButton("Edit..");
        this.editButton.addActionListener(this);
        this.buttons.add(this.editButton);
        this.buttonBox.add(this.editButton);
        if (!editOnly) {
            this.buttonBox.add(Box.createVerticalStrut(5));
            this.removeButton = new JButton("Remove..");
            this.removeButton.addActionListener(this);
            this.buttonBox.add(this.removeButton);
            this.buttons.add(this.removeButton);
        }
        this.add((Component)this.buttonBox, "East");
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                StringListFormComponent.this.setButtonState();
            }
        });
        this.setButtonState();
    }

    public void addButton(Action action, boolean requireSelection) {
        this.buttonBox.add(Box.createVerticalStrut(5));
        JButton button = new JButton(action);
        this.buttonBox.add(button);
        if (requireSelection) {
            this.buttons.add(button);
            this.setButtonState();
        }
    }

    public void setValue(String value) {
        String[] oldData = this.getData();
        this.listModel.clear();
        try {
            String[] files;
            StringList stringList = StringList.fromXml(value);
            for (String file : files = stringList.toStringArray()) {
                if (file.trim().length() <= 0) continue;
                this.listModel.addElement(file);
            }
            this.firePropertyChange("data", oldData, this.getData());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public String getValue() {
        StringList result = new StringList(this.listModel.toArray());
        return result.toXml();
    }

    public JList getList() {
        return this.list;
    }

    public void actionPerformed(ActionEvent e) {
        String[] oldData = this.getData();
        if (e.getSource() == this.addButton) {
            String value = UISupport.prompt("Specify value to add", "Add..", this.defaultValue);
            if (value != null) {
                this.listModel.addElement(value);
                this.firePropertyChange("options", oldData, this.getData());
            }
        } else {
            String elm;
            String value;
            int selectedIndex = this.list.getSelectedIndex();
            if (e.getSource() == this.removeButton && selectedIndex != -1) {
                Object elm2 = this.listModel.getElementAt(selectedIndex);
                if (UISupport.confirm("Remove [" + elm2.toString() + "] from list", "Remove")) {
                    this.listModel.remove(selectedIndex);
                    this.firePropertyChange("options", oldData, this.getData());
                }
            } else if (e.getSource() == this.editButton && selectedIndex != -1 && (value = UISupport.prompt("Specify value", "Edit..", elm = (String)this.listModel.getElementAt(selectedIndex))) != null) {
                this.listModel.setElementAt(value, selectedIndex);
                this.firePropertyChange("options", oldData, this.getData());
            }
        }
    }

    public void setButtonState() {
        boolean b = this.list.getSelectedIndex() != -1;
        for (JButton button : this.buttons) {
            button.setEnabled(b);
        }
    }

    public String[] getData() {
        String[] result = new String[this.listModel.size()];
        for (int c = 0; c < result.length; ++c) {
            result[c] = (String)this.listModel.get(c);
        }
        return result;
    }

    public void setData(String[] strings) {
        String[] oldData = this.getData();
        this.listModel.clear();
        if (strings != null) {
            for (String str : strings) {
                this.listModel.addElement(str);
            }
        }
        this.firePropertyChange("options", oldData, this.getData());
    }

    public String[] getOptions() {
        return this.getData();
    }

    public void setOptions(String[] options) {
        this.setData(options);
    }

    public void setEnabled(boolean b) {
        this.addButton.setEnabled(b);
        this.list.setEnabled(b);
        if (b) {
            this.setButtonState();
        }
    }

    public void addItem(String valueOf) {
        this.listModel.addElement(valueOf);
    }
}

