/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.dnd.handlers.AbstractAfterModelItemDropHandler;
import com.eviware.soapui.support.dnd.handlers.DragAndDropSupport;
import com.eviware.soapui.support.dnd.handlers.TestCaseToTestSuiteDropHandler;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseToProjectDropHandler
extends AbstractAfterModelItemDropHandler<WsdlTestCase, WsdlProject> {
    public TestCaseToProjectDropHandler() {
        super(WsdlTestCase.class, WsdlProject.class);
    }

    @Override
    boolean canCopyAfter(WsdlTestCase source, WsdlProject target) {
        return true;
    }

    @Override
    boolean canMoveAfter(WsdlTestCase source, WsdlProject target) {
        return true;
    }

    @Override
    boolean copyAfter(WsdlTestCase testCase, WsdlProject target) {
        WsdlTestSuite testSuite = this.getTargetTestSuite(target, "Copy TestCase");
        if (testSuite == null) {
            return false;
        }
        if ((testCase = TestCaseToTestSuiteDropHandler.copyTestCase(testCase, testSuite, -1)) != null) {
            UISupport.select(testCase);
        }
        return testCase != null;
    }

    private WsdlTestSuite getTargetTestSuite(WsdlProject target, String title) {
        String[] names;
        String name = "TestSuite 1";
        if (target.getTestSuiteCount() > 0 && (name = UISupport.prompt("Specify target TestSuite for TestCase", title, names = ModelSupport.getNames(target.getTestSuiteList(), new String[]{"<Create New>"}))) == null) {
            return null;
        }
        WsdlTestSuite testSuite = target.getTestSuiteByName(name);
        if (testSuite == null) {
            name = UISupport.prompt("Specify name for new TestSuite", title, "TestSuite " + (target.getTestSuiteCount() + 1));
            if (name == null) {
                return null;
            }
            testSuite = target.addNewTestSuite(name);
        }
        HashSet<Interface> requiredInterfaces = new HashSet<Interface>();
        for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
            WsdlTestCase testCase = testSuite.getTestCaseAt(i);
            for (int y = 0; y < testCase.getTestStepCount(); ++y) {
                WsdlTestStep testStep = testCase.getTestStepAt(y);
                requiredInterfaces.addAll(testStep.getRequiredInterfaces());
            }
        }
        if (!DragAndDropSupport.importRequiredInterfaces(target, requiredInterfaces, title)) {
            return null;
        }
        return testSuite;
    }

    @Override
    boolean moveAfter(WsdlTestCase testCase, WsdlProject target) {
        WsdlTestSuite testSuite = this.getTargetTestSuite(target, "Move TestCase");
        if (testSuite == null) {
            return false;
        }
        if ((testCase = TestCaseToTestSuiteDropHandler.moveTestCase(testCase, testSuite, -1)) != null) {
            UISupport.select(testCase);
        }
        return testCase != null;
    }

    @Override
    String getCopyAfterInfo(WsdlTestCase source, WsdlProject target) {
        return "Copy TestCase [" + source.getName() + "] to TestSuite in Project [" + target.getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlTestCase source, WsdlProject target) {
        return "Move TestCase [" + source.getName() + "] to TestSuite in Project [" + target.getName() + "]";
    }
}

