/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views.xml.source;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.components.PreviewCorner;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.editor.xml.XmlLocation;
import com.eviware.soapui.support.editor.xml.support.ValidationError;
import com.eviware.soapui.support.propertyexpansion.PropertyExpansionPopupListener;
import com.eviware.soapui.support.swing.JTextComponentPopupMenu;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.support.xml.actions.EnableLineNumbersAction;
import com.eviware.soapui.support.xml.actions.FormatXmlAction;
import com.eviware.soapui.support.xml.actions.GoToLineAction;
import com.eviware.soapui.support.xml.actions.InsertBase64FileTextAreaAction;
import com.eviware.soapui.support.xml.actions.LoadXmlTextAreaAction;
import com.eviware.soapui.support.xml.actions.SaveXmlTextAreaAction;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSourceEditorView<T extends ModelItem>
extends AbstractXmlEditorView<XmlDocument> {
    private RSyntaxTextArea editArea;
    private RTextScrollPane editorScrollPane;
    private ValidateMessageXmlAction validateXmlAction;
    private JSplitPane splitter;
    private JScrollPane errorScrollPane;
    private DefaultListModel errorListModel;
    private boolean updating;
    public boolean isLocating;
    private JPopupMenu inputPopup;
    private PreviewCorner previewCorner;
    private T modelItem;
    private EnableLineNumbersAction enableLineNumbersAction;
    private GoToLineAction goToLineAction;
    private SaveXmlTextAreaAction saveXmlTextAreaAction;
    private FormatXmlAction formatXmlAction;
    private LoadXmlTextAreaAction loadXmlTextAreaAction;
    private InsertBase64FileTextAreaAction insertBase64FileTextAreaAction;
    private FindAndReplaceDialogView findAndReplaceDialog;
    private final boolean readOnly;

    public XmlSourceEditorView(XmlEditor<XmlDocument> xmlEditor, T modelItem, boolean readOnly) {
        super("XML", xmlEditor, "Source");
        this.modelItem = modelItem;
        this.readOnly = readOnly;
    }

    protected void buildUI() {
        this.editArea = new RSyntaxTextArea(20, 60);
        this.editArea.setSyntaxEditingStyle("text/xml");
        this.editArea.setFont(UISupport.getEditorFont());
        this.editArea.setCodeFoldingEnabled(true);
        this.editArea.setAntiAliasingEnabled(true);
        this.editArea.setMinimumSize(new Dimension(50, 50));
        this.editArea.setCaretPosition(0);
        this.editArea.setEnabled(!this.readOnly);
        this.editArea.setEditable(!this.readOnly);
        this.editArea.setBorder((Border)BorderFactory.createMatteBorder(0, 2, 0, 0, Color.WHITE));
        this.errorListModel = new DefaultListModel();
        JList list = new JList(this.errorListModel);
        list.addMouseListener(new ValidationListMouseAdapter(list, this.editArea));
        this.errorScrollPane = new JScrollPane(list);
        this.errorScrollPane.setVisible(false);
        this.splitter = new JSplitPane(0){

            public void requestFocus() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XmlSourceEditorView.this.editArea.requestFocusInWindow();
                    }
                });
            }

            public boolean hasFocus() {
                return XmlSourceEditorView.this.editArea.hasFocus();
            }
        };
        this.splitter.setUI(new SoapUISplitPaneUI());
        this.splitter.setDividerSize(0);
        this.splitter.setOneTouchExpandable(true);
        this.editArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!XmlSourceEditorView.this.updating && XmlSourceEditorView.this.getDocument() != null) {
                    XmlSourceEditorView.this.updating = true;
                    XmlSourceEditorView.this.getDocument().setXml(XmlSourceEditorView.this.editArea.getText());
                    XmlSourceEditorView.this.updating = false;
                }
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        this.editorScrollPane = new RTextScrollPane((RTextArea)this.editArea);
        JTextComponentPopupMenu.add((JTextComponent)this.editArea);
        this.buildPopup(this.editArea.getPopupMenu(), this.editArea);
        if (UISupport.isMac()) {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("shift meta V"), this.validateXmlAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("meta S"), this.saveXmlTextAreaAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("control L"), this.enableLineNumbersAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("control meta L"), this.goToLineAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("meta F"), this.findAndReplaceDialog);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("shift meta F"), this.formatXmlAction);
            if (!this.readOnly) {
                this.editArea.getInputMap().put(KeyStroke.getKeyStroke("meta L"), this.loadXmlTextAreaAction);
            }
        } else {
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt V"), this.validateXmlAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl S"), this.saveXmlTextAreaAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt L"), this.enableLineNumbersAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("control alt L"), this.goToLineAction);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl F"), this.findAndReplaceDialog);
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke("alt F"), this.formatXmlAction);
            if (!this.readOnly) {
                this.editArea.getInputMap().put(KeyStroke.getKeyStroke("ctrl L"), this.loadXmlTextAreaAction);
            }
        }
        this.editorScrollPane.setLineNumbersEnabled(SoapUI.getSettings().getBoolean(UISettings.SHOW_XML_LINE_NUMBERS));
        this.editorScrollPane.setFoldIndicatorEnabled(true);
        p.add((Component)this.editorScrollPane, "Center");
        this.splitter.setTopComponent((Component)this.editorScrollPane);
        this.splitter.setBottomComponent(this.errorScrollPane);
        this.splitter.setDividerLocation(1.0);
        this.splitter.setBorder(null);
        this.previewCorner = UISupport.addPreviewCorner(this.getEditorScrollPane(), true);
        if (!this.readOnly) {
            PropertyExpansionPopupListener.enable(this.editArea, this.modelItem);
        }
    }

    public JScrollPane getEditorScrollPane() {
        return this.editorScrollPane;
    }

    public T getModelItem() {
        return this.modelItem;
    }

    protected void buildPopup(JPopupMenu inputPopup, RSyntaxTextArea editArea) {
        this.inputPopup = inputPopup;
        this.validateXmlAction = new ValidateMessageXmlAction();
        this.saveXmlTextAreaAction = new SaveXmlTextAreaAction(editArea, "Save");
        this.enableLineNumbersAction = new EnableLineNumbersAction(this.editorScrollPane, "Toggle Line Numbers");
        this.goToLineAction = new GoToLineAction(editArea, "Go To Line");
        this.findAndReplaceDialog = new FindAndReplaceDialogView("Find / Replace");
        if (!this.readOnly) {
            this.loadXmlTextAreaAction = new LoadXmlTextAreaAction(editArea, "Load");
            this.insertBase64FileTextAreaAction = new InsertBase64FileTextAreaAction(editArea, "Insert File as Base64");
        }
        int cnt = inputPopup.getComponentCount();
        for (int i = cnt - 1; i >= 0; --i) {
            if (!(inputPopup.getComponent(i) instanceof JSeparator)) continue;
            inputPopup.remove(inputPopup.getComponent(i));
        }
        inputPopup.insert(this.validateXmlAction, 0);
        this.formatXmlAction = new FormatXmlAction(editArea);
        inputPopup.insert(this.formatXmlAction, 1);
        inputPopup.addSeparator();
        inputPopup.add(this.findAndReplaceDialog);
        inputPopup.addSeparator();
        inputPopup.add(this.goToLineAction);
        inputPopup.add(this.enableLineNumbersAction);
        inputPopup.addSeparator();
        inputPopup.add(this.saveXmlTextAreaAction);
        if (!this.readOnly) {
            inputPopup.add(this.loadXmlTextAreaAction);
            inputPopup.add(this.insertBase64FileTextAreaAction);
        }
    }

    @Override
    public void release() {
        super.release();
        this.inputPopup.removeAll();
        this.previewCorner.release();
        this.modelItem = null;
    }

    public RSyntaxTextArea getInputArea() {
        this.getComponent();
        return this.editArea;
    }

    @Override
    public void setEditable(boolean enabled) {
        this.getComponent();
        this.editArea.setEditable(enabled);
    }

    protected ValidationError[] validateXml(String xml) {
        try {
            XmlUtils.createXmlObject(xml, new XmlOptions().setLoadLineNumbers());
        }
        catch (XmlException e) {
            ArrayList<AssertionError> result = new ArrayList<AssertionError>();
            if (e.getErrors() != null) {
                for (Object error : e.getErrors()) {
                    if (error instanceof XmlError) {
                        result.add(new AssertionError((XmlError)error));
                        continue;
                    }
                    result.add(new AssertionError(error.toString()));
                }
            }
            if (result.isEmpty()) {
                result.add(new AssertionError(e.toString()));
            }
            return result.toArray(new ValidationError[result.size()]);
        }
        return null;
    }

    public boolean activate(XmlLocation location) {
        super.activate(location);
        if (location != null) {
            this.setLocation(location);
        }
        this.editArea.requestFocus();
        return true;
    }

    @Override
    public JComponent getComponent() {
        if (this.splitter == null) {
            this.buildUI();
        }
        return this.splitter;
    }

    public XmlLocation getEditorLocation() {
        return new XmlLocation(this.getCurrentLine() + 1, this.getCurrentColumn());
    }

    public void setLocation(XmlLocation location) {
        int line = location.getLine() - 1;
        if (location != null && line >= 0) {
            try {
                int caretLine = this.editArea.getCaretLineNumber();
                int offset = this.editArea.getLineStartOffset(line);
                this.editArea.setCaretPosition(offset + location.getColumn());
                int scrollLine = line + (line > caretLine ? 3 : -3);
                if (scrollLine >= this.editArea.getLineCount()) {
                    scrollLine = this.editArea.getLineCount() - 1;
                } else if (scrollLine < 0) {
                    scrollLine = 0;
                }
                this.editArea.scrollRectToVisible(new Rectangle(scrollLine, location.getColumn()));
            }
            catch (RuntimeException e) {
            }
            catch (BadLocationException e) {
                SoapUI.logError(e, "Unable to set the location in the XML document.");
            }
        }
    }

    public int getCurrentLine() {
        if (this.editArea == null) {
            return -1;
        }
        return this.editArea.getCaretLineNumber();
    }

    public int getCurrentColumn() {
        if (this.editArea == null) {
            return -1;
        }
        try {
            int pos = this.editArea.getCaretPosition();
            int line = this.editArea.getLineOfOffset(pos);
            return pos - this.editArea.getLineStartOffset(line);
        }
        catch (BadLocationException e) {
            SoapUI.logError(e, "Unable to get the current column. ");
            return -1;
        }
    }

    public String getText() {
        if (this.editArea == null) {
            return null;
        }
        return this.editArea.getText();
    }

    public boolean validate() {
        ValidationError[] errors = this.validateXml(PropertyExpander.expandProperties(this.getModelItem(), this.editArea.getText()));
        this.errorListModel.clear();
        if (errors == null || errors.length == 0) {
            this.splitter.setDividerLocation(1.0);
            this.splitter.setDividerSize(0);
            this.errorScrollPane.setVisible(false);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        for (int c = 0; c < errors.length; ++c) {
            this.errorListModel.addElement(errors[c]);
        }
        this.errorScrollPane.setVisible(true);
        this.splitter.setDividerLocation(0.8);
        this.splitter.setDividerSize(10);
        return false;
    }

    @Override
    public void setXml(String xml) {
        if (!this.updating) {
            this.updating = true;
            if (xml == null) {
                this.editArea.setText("");
                this.editArea.setEnabled(false);
            } else {
                int caretPosition = this.editArea.getCaretPosition();
                this.editArea.setEnabled(true);
                this.editArea.setText(xml);
                this.editArea.setCaretPosition(caretPosition < xml.length() ? caretPosition : 0);
            }
            this.updating = false;
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return validate ? this.validate() : true;
    }

    @Override
    public void locationChanged(EditorLocation<XmlDocument> location) {
        this.isLocating = true;
        this.setLocation(location);
        this.isLocating = false;
    }

    public JPopupMenu getEditorPopup() {
        return this.editArea.getPopupMenu();
    }

    public boolean hasFocus() {
        return this.editArea.hasFocus();
    }

    public boolean isInspectable() {
        return true;
    }

    public ValidateMessageXmlAction getValidateXmlAction() {
        return this.validateXmlAction;
    }

    public class ValidateMessageXmlAction
    extends AbstractAction {
        public ValidateMessageXmlAction() {
            super("Validate");
            if (UISupport.isMac()) {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("shift meta V"));
            } else {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt V"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (XmlSourceEditorView.this.validate()) {
                UISupport.showInfoMessage("Validation OK");
            }
        }
    }

    public static class JEditorStatusBarTargetProxy
    implements JEditorStatusBar.JEditorStatusBarTarget {
        private final RSyntaxTextArea textArea;

        public JEditorStatusBarTargetProxy(RSyntaxTextArea area) {
            this.textArea = area;
        }

        public void addCaretListener(CaretListener listener) {
            this.textArea.addCaretListener(listener);
        }

        public int getCaretPosition() {
            return this.textArea.getCaretPosition();
        }

        public void removeCaretListener(CaretListener listener) {
            this.textArea.removeCaretListener(listener);
        }

        public int getLineStartOffset(int line) throws Exception {
            return this.textArea.getLineStartOffset(line);
        }

        public int getLineOfOffset(int offset) throws Exception {
            return this.textArea.getLineOfOffset(offset);
        }
    }

    private static final class ValidationListMouseAdapter
    extends MouseAdapter {
        private final JList list;
        private final RSyntaxTextArea textArea;

        public ValidationListMouseAdapter(JList list, RSyntaxTextArea editArea) {
            this.list = list;
            this.textArea = editArea;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int ix = this.list.getSelectedIndex();
            if (ix == -1) {
                return;
            }
            Object obj = this.list.getModel().getElementAt(ix);
            if (obj instanceof ValidationError) {
                ValidationError error = (ValidationError)obj;
                if (error.getLineNumber() >= 0) {
                    try {
                        this.textArea.setCaretPosition(this.textArea.getLineStartOffset(error.getLineNumber() - 1));
                    }
                    catch (BadLocationException e1) {
                        SoapUI.logError(e1, "Unable to set the caret position. This is most likely a bug.");
                    }
                    this.textArea.requestFocus();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private final class FindAndReplaceDialogView
    extends AbstractAction {
        private JDialog dialog;
        private JCheckBox caseCheck;
        private JRadioButton allButton;
        private JRadioButton selectedLinesButton;
        private JRadioButton forwardButton;
        private JRadioButton backwardButton;
        private JCheckBox wholeWordCheck;
        private JButton findButton;
        private JButton replaceButton;
        private JButton replaceAllButton;
        private JComboBox findCombo;
        private JComboBox replaceCombo;
        private JCheckBox wrapCheck;
        private final String title;

        public FindAndReplaceDialogView(String title) {
            super(title);
            this.title = title;
            if (UISupport.isMac()) {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("meta F"));
            } else {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl F"));
            }
        }

        public void actionPerformed(ActionEvent arg0) {
            this.show();
        }

        public void show() {
            if (this.dialog == null) {
                this.buildDialog();
            }
            XmlSourceEditorView.this.editArea.requestFocusInWindow();
            this.replaceCombo.setEnabled(!XmlSourceEditorView.this.readOnly);
            this.replaceAllButton.setEnabled(!XmlSourceEditorView.this.readOnly);
            this.replaceButton.setEnabled(!XmlSourceEditorView.this.readOnly);
            UISupport.showDialog(this.dialog);
            this.findCombo.getEditor().selectAll();
            this.findCombo.requestFocus();
        }

        private void buildDialog() {
            Window window = SwingUtilities.windowForComponent((Component)XmlSourceEditorView.this.editArea);
            this.dialog = new JDialog(window, this.title);
            this.dialog.setModal(false);
            JPanel panel = new JPanel(new BorderLayout());
            this.findCombo = new JComboBox();
            this.findCombo.setEditable(true);
            this.replaceCombo = new JComboBox();
            this.replaceCombo.setEditable(!XmlSourceEditorView.this.readOnly);
            GridLayout gridLayout = new GridLayout(2, 2);
            gridLayout.setVgap(5);
            JPanel inputPanel = new JPanel(gridLayout);
            inputPanel.add(new JLabel("Find:"));
            inputPanel.add(this.findCombo);
            inputPanel.add(new JLabel("Replace with:"));
            inputPanel.add(this.replaceCombo);
            inputPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            ButtonGroup directionGroup = new ButtonGroup();
            this.forwardButton = new JRadioButton("Forward", true);
            this.forwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            directionGroup.add(this.forwardButton);
            this.backwardButton = new JRadioButton("Backward");
            this.backwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            directionGroup.add(this.backwardButton);
            JPanel directionPanel = new JPanel(new GridLayout(2, 1));
            directionPanel.add(this.forwardButton);
            directionPanel.add(this.backwardButton);
            directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
            ButtonGroup scopeGroup = new ButtonGroup();
            this.allButton = new JRadioButton("All", true);
            this.allButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.selectedLinesButton = new JRadioButton("Selected Lines");
            this.selectedLinesButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            scopeGroup.add(this.allButton);
            scopeGroup.add(this.selectedLinesButton);
            JPanel scopePanel = new JPanel(new GridLayout(2, 1));
            scopePanel.add(this.allButton);
            scopePanel.add(this.selectedLinesButton);
            scopePanel.setBorder(BorderFactory.createTitledBorder("Scope"));
            this.caseCheck = new JCheckBox("Case Sensitive");
            this.caseCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.wholeWordCheck = new JCheckBox("Whole Word");
            this.wholeWordCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.wrapCheck = new JCheckBox("Wrap Search");
            this.wrapCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JPanel optionsPanel = new JPanel(new GridLayout(3, 1));
            optionsPanel.add(this.caseCheck);
            optionsPanel.add(this.wholeWordCheck);
            optionsPanel.add(this.wrapCheck);
            optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            JPanel options = new JPanel(new GridLayout(1, 2));
            JPanel radios = new JPanel(new GridLayout(2, 1));
            radios.add(directionPanel);
            radios.add(scopePanel);
            options.add(optionsPanel);
            options.add(radios);
            options.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.findButton = new JButton(new FindAction(this.findCombo));
            builder.addFixed((JComponent)this.findButton);
            builder.addRelatedGap();
            this.replaceButton = new JButton(new ReplaceAction());
            builder.addFixed((JComponent)this.replaceButton);
            builder.addRelatedGap();
            this.replaceAllButton = new JButton(new ReplaceAllAction());
            builder.addFixed((JComponent)this.replaceAllButton);
            builder.addUnrelatedGap();
            builder.addFixed((JComponent)new JButton(new CloseAction(this.dialog)));
            builder.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            panel.add((Component)inputPanel, "North");
            panel.add((Component)options, "Center");
            panel.add((Component)builder.getPanel(), "South");
            this.dialog.getContentPane().add(panel);
            this.dialog.pack();
            UISupport.initDialogActions(this.dialog, null, this.findButton);
        }

        protected SearchContext createSearchAndReplaceContext() {
            if (this.findCombo.getSelectedItem() == null) {
                return null;
            }
            if (this.replaceCombo.getSelectedItem() == null) {
                return null;
            }
            String searchExpression = this.findCombo.getSelectedItem().toString();
            String replacement = this.replaceCombo.getSelectedItem().toString();
            SearchContext context = new SearchContext();
            context.setSearchFor(searchExpression);
            context.setReplaceWith(replacement);
            context.setRegularExpression(false);
            context.setMatchCase(this.caseCheck.isSelected());
            context.setSearchForward(this.forwardButton.isSelected());
            context.setWholeWord(false);
            return context;
        }

        protected SearchContext createSearchContext() {
            if (this.findCombo.getSelectedItem() == null) {
                return null;
            }
            String searchExpression = this.findCombo.getSelectedItem().toString();
            SearchContext context = new SearchContext();
            context.setSearchFor(searchExpression);
            context.setRegularExpression(false);
            context.setSearchForward(this.forwardButton.isSelected());
            context.setMatchCase(this.caseCheck.isSelected());
            context.setWholeWord(false);
            return context;
        }

        private class CloseAction
        extends AbstractAction {
            final JDialog dialog;

            public CloseAction(JDialog d) {
                super("Close");
                this.dialog = d;
            }

            public void actionPerformed(ActionEvent e) {
                this.dialog.setVisible(false);
            }
        }

        private class ReplaceAllAction
        extends AbstractAction {
            public ReplaceAllAction() {
                super("Replace All");
            }

            public void actionPerformed(ActionEvent e) {
                SearchContext context = FindAndReplaceDialogView.this.createSearchAndReplaceContext();
                if (context == null) {
                    return;
                }
                int replaceCount = SearchEngine.replaceAll((RTextArea)XmlSourceEditorView.this.editArea, (SearchContext)context);
                if (replaceCount <= 0) {
                    UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
                }
            }
        }

        private class ReplaceAction
        extends AbstractAction {
            public ReplaceAction() {
                super("Replace/Replace Next");
            }

            public void actionPerformed(ActionEvent e) {
                SearchContext context = FindAndReplaceDialogView.this.createSearchAndReplaceContext();
                if (context == null) {
                    return;
                }
                boolean found = SearchEngine.replace((RTextArea)XmlSourceEditorView.this.editArea, (SearchContext)context);
                if (!found) {
                    UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
                }
            }
        }

        private class FindAction
        extends AbstractAction {
            public FindAction(JComboBox findCombo) {
                super("Find/Find Next");
            }

            public void actionPerformed(ActionEvent e) {
                SearchContext context = FindAndReplaceDialogView.this.createSearchContext();
                if (context == null) {
                    return;
                }
                boolean found = SearchEngine.find((JTextArea)XmlSourceEditorView.this.editArea, (SearchContext)context);
                if (!found) {
                    UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
                }
            }
        }
    }
}

