/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.swing.ModelItemListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public abstract class ChangeRestMethodResolver
implements ResolveContext.Resolver {
    private boolean resolved = false;
    private WsdlProject project;
    private RestMethod selectedMethod;

    public ChangeRestMethodResolver(RestTestRequestStep testStep) {
        this.project = testStep.getTestCase().getTestSuite().getProject();
    }

    public String getResolvedPath() {
        return "";
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        PropertyChangeDialog pDialog = new PropertyChangeDialog("Resolve REST Method");
        pDialog.setVisible(true);
        this.resolved = this.update();
        return this.resolved;
    }

    public abstract boolean update();

    protected abstract Interface[] getInterfaces(WsdlProject var1);

    public String getDescription() {
        return "Resolve: Select another REST Method";
    }

    public String toString() {
        return this.getDescription();
    }

    public RestMethod getSelectedRestMethod() {
        return this.selectedMethod;
    }

    private class PropertyChangeDialog
    extends SimpleDialog {
        private JComboBox serviceCombo;
        private JComboBox resourceCombo;
        private JComboBox methodCombo;

        public PropertyChangeDialog(String title) {
            super(title, ChangeRestMethodResolver.this.getDescription(), null);
        }

        protected Component buildContent() {
            SimpleForm form = new SimpleForm();
            form.addSpace(5);
            Interface[] ifaces = ChangeRestMethodResolver.this.getInterfaces(ChangeRestMethodResolver.this.project);
            DefaultComboBoxModel<Interface> serviceComboModel = new DefaultComboBoxModel<Interface>();
            this.serviceCombo = form.appendComboBox("REST Services", serviceComboModel, "Target Service");
            this.serviceCombo.setRenderer(new ModelItemListCellRenderer());
            for (Interface element : ifaces) {
                if (!(element instanceof RestService)) continue;
                serviceComboModel.addElement(element);
            }
            this.resourceCombo = form.appendComboBox("REST Resources", ((RestService)this.serviceCombo.getSelectedItem()).getOperationList().toArray(), "Target Resource");
            this.resourceCombo.setRenderer(new ModelItemListCellRenderer());
            this.methodCombo = form.appendComboBox("REST Methods", ((RestResource)this.resourceCombo.getSelectedItem()).getRestMethodList().toArray(), "Target Method");
            this.methodCombo.setRenderer(new ModelItemListCellRenderer());
            this.serviceCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Interface iface = ChangeRestMethodResolver.this.project.getInterfaceByName(((Interface)PropertyChangeDialog.this.serviceCombo.getSelectedItem()).getName());
                    PropertyChangeDialog.this.resourceCombo.removeAllItems();
                    if (iface != null) {
                        PropertyChangeDialog.this.resourceCombo.setEnabled(true);
                        for (Operation op : iface.getOperationList()) {
                            PropertyChangeDialog.this.resourceCombo.addItem(op);
                        }
                    } else {
                        PropertyChangeDialog.this.resourceCombo.setEnabled(false);
                    }
                }
            });
            this.resourceCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RestResource resource = (RestResource)PropertyChangeDialog.this.resourceCombo.getSelectedItem();
                    PropertyChangeDialog.this.methodCombo.removeAllItems();
                    if (resource != null) {
                        PropertyChangeDialog.this.methodCombo.setEnabled(true);
                        for (RestMethod method : resource.getRestMethodList()) {
                            PropertyChangeDialog.this.methodCombo.addItem(method);
                        }
                    } else {
                        PropertyChangeDialog.this.methodCombo.setEnabled(false);
                    }
                }
            });
            form.addSpace(5);
            return form.getPanel();
        }

        protected boolean handleOk() {
            ChangeRestMethodResolver.this.selectedMethod = (RestMethod)this.methodCombo.getSelectedItem();
            return true;
        }
    }
}

