/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.types;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.StringToStringMapConfig;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToStringMap
extends HashMap<String, String> {
    private boolean equalsOnThis;

    public StringToStringMap() {
    }

    public StringToStringMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public StringToStringMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringToStringMap(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public String get(String key, String defaultValue) {
        String value = (String)this.get(key);
        return value == null ? defaultValue : value;
    }

    public StringToStringMap inverse() {
        StringToStringMap inverse = new StringToStringMap();
        for (String key : this.keySet()) {
            String value = (String)this.get(key);
            inverse.put(value, key);
        }
        return inverse;
    }

    public String toXml() {
        StringToStringMapConfig xmlConfig = StringToStringMapConfig.Factory.newInstance();
        for (String key : this.keySet()) {
            StringToStringMapConfig.Entry entry = xmlConfig.addNewEntry();
            entry.setKey(key);
            entry.setValue((String)this.get(key));
        }
        return xmlConfig.toString();
    }

    public static StringToStringMap fromXml(String value) {
        if (value == null || value.trim().length() == 0 || value.equals("<xml-fragment/>")) {
            return new StringToStringMap();
        }
        try {
            StringToStringMapConfig nsMapping = StringToStringMapConfig.Factory.parse(value);
            return StringToStringMap.fromXml(nsMapping);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new StringToStringMap();
        }
    }

    public static StringToStringMap fromXml(StringToStringMapConfig nsMapping) {
        StringToStringMap result = new StringToStringMap();
        for (StringToStringMapConfig.Entry entry : nsMapping.getEntryList()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public final boolean getBoolean(String key) {
        return Boolean.parseBoolean((String)this.get(key));
    }

    public boolean hasValue(String key) {
        return this.containsKey(key) && ((String)this.get(key)).length() > 0;
    }

    public void putIfMissing(String key, String value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public static StringToStringMap fromHttpHeader(String value) {
        StringToStringMap result = new StringToStringMap();
        int ix = value.indexOf(59);
        while (ix > 0) {
            StringToStringMap.extractNVPair(value.substring(0, ix), result);
            value = value.substring(ix + 1);
            ix = value.indexOf(59);
        }
        if (value.length() > 2) {
            StringToStringMap.extractNVPair(value, result);
        }
        return result;
    }

    private static void extractNVPair(String value, StringToStringMap result) {
        int ix = value.indexOf(61);
        if (ix != -1) {
            String str = value.substring(ix + 1).trim();
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            result.put(value.substring(0, ix).trim(), str);
        }
    }

    public void setEqualsOnThis(boolean equalsOnThis) {
        this.equalsOnThis = equalsOnThis;
    }

    @Override
    public boolean equals(Object o) {
        return this.equalsOnThis ? this == o : super.equals(o);
    }

    public int getInt(String key, int def) {
        try {
            return Integer.parseInt((String)this.get(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public boolean containsKeyIgnoreCase(String string) {
        for (String key : this.keySet()) {
            if (!key.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

