/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.types;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.StringToStringMapConfig;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToStringsMap
extends HashMap<String, List<String>> {
    private boolean equalsOnThis;

    public StringToStringsMap() {
    }

    public StringToStringsMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public StringToStringsMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringToStringsMap(Map<? extends String, ? extends List<String>> m) {
        super(m);
    }

    public StringToStringsMap(StringToStringMap map) {
        for (String key : map.keySet()) {
            this.put(key, (String)map.get(key));
        }
    }

    public List<String> get(String key, List<String> defaultValue) {
        List value = (List)this.get(key);
        return value == null ? defaultValue : value;
    }

    public String toXml() {
        StringToStringMapConfig xmlConfig = StringToStringMapConfig.Factory.newInstance();
        for (String key : this.keySet()) {
            for (String value : (List)this.get(key)) {
                StringToStringMapConfig.Entry entry = xmlConfig.addNewEntry();
                entry.setKey(key);
                entry.setValue(value);
            }
        }
        return xmlConfig.toString();
    }

    public static StringToStringsMap fromXml(String value) {
        if (value == null || value.trim().length() == 0 || value.equals("<xml-fragment/>")) {
            return new StringToStringsMap();
        }
        try {
            StringToStringMapConfig nsMapping = StringToStringMapConfig.Factory.parse(value);
            return StringToStringsMap.fromXml(nsMapping);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return new StringToStringsMap();
        }
    }

    public static StringToStringsMap fromXml(StringToStringMapConfig nsMapping) {
        StringToStringsMap result = new StringToStringsMap();
        for (StringToStringMapConfig.Entry entry : nsMapping.getEntryList()) {
            result.add(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public boolean hasValues(String key) {
        return this.containsKey(key) && ((List)this.get(key)).size() > 0;
    }

    public void add(String key, boolean value) {
        this.add(key, Boolean.toString(value));
    }

    public void add(String key, String string) {
        if (!this.containsKey(key)) {
            this.put(key, new ArrayList());
        }
        ((List)this.get(key)).add(string);
    }

    public static StringToStringsMap fromHttpHeader(String value) {
        StringToStringsMap result = new StringToStringsMap();
        int ix = value.indexOf(59);
        while (ix > 0) {
            StringToStringsMap.extractNVPair(value.substring(0, ix), result);
            value = value.substring(ix + 1);
            ix = value.indexOf(59);
        }
        if (value.length() > 2) {
            StringToStringsMap.extractNVPair(value, result);
        }
        return result;
    }

    private static void extractNVPair(String value, StringToStringsMap result) {
        int ix = value.indexOf(61);
        if (ix != -1) {
            String str = value.substring(ix + 1).trim();
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            result.add(value.substring(0, ix).trim(), str);
        }
    }

    public void setEqualsOnThis(boolean equalsOnThis) {
        this.equalsOnThis = equalsOnThis;
    }

    @Override
    public boolean equals(Object o) {
        return this.equalsOnThis ? this == o : super.equals(o);
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public boolean containsKeyIgnoreCase(String string) {
        for (String key : this.keySet()) {
            if (!key.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void put(String name, String value) {
        this.add(name, value);
    }

    public String get(String key, String defaultValue) {
        List value = (List)this.get(key);
        if (value == null || value.size() == 0) {
            return defaultValue;
        }
        return (String)value.get(0);
    }

    public StringToStringMap toStringToStringMap() {
        StringToStringMap result = new StringToStringMap();
        for (String key : this.keySet()) {
            List list = (List)this.get(key);
            if (list.size() == 1) {
                result.put(key, list.get(0));
                continue;
            }
            result.put(key, list.toString());
        }
        return result;
    }

    public void replace(String key, String oldValue, String value) {
        List values = (List)this.get(key);
        if (values == null) {
            return;
        }
        int ix = values.indexOf(oldValue);
        if (ix >= 0) {
            values.set(ix, value);
        }
    }

    public void remove(String key, String data) {
        List values = (List)this.get(key);
        if (values == null) {
            return;
        }
        values.remove(data);
    }

    public int valueCount() {
        int result = 0;
        for (String key : this.keySet()) {
            result += ((List)this.get(key)).size();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (String key : this.keySet()) {
            for (String value : (List)this.get(key)) {
                result.append(key).append(" : ").append(value).append("\r\n");
            }
        }
        return result.toString();
    }
}

