/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.testondemand;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestOnDemandCommandConfig;
import com.eviware.soapui.config.TestOnDemandContentConfig;
import com.eviware.soapui.config.TestOnDemandFileConfig;
import com.eviware.soapui.config.TestOnDemandHeaderConfig;
import com.eviware.soapui.config.TestOnDemandKeystoreConfig;
import com.eviware.soapui.config.TestOnDemandKeystorePasswordConfig;
import com.eviware.soapui.config.TestOnDemandLocationsRequestDocumentConfig;
import com.eviware.soapui.config.TestOnDemandProjectPasswordConfig;
import com.eviware.soapui.config.TestOnDemandTestCaseConfig;
import com.eviware.soapui.config.TestOnDemandTestSuiteConfig;
import com.eviware.soapui.config.TestOnDemandTxnConfig;
import com.eviware.soapui.config.TestOnDemandUploadBodyConfig;
import com.eviware.soapui.config.TestOnDemandUploadRequestDocumentConfig;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.testondemand.Location;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOnDemandCaller {
    private static final String DEFAULT_PROTOCOL = "https";
    private static final String PROTOCOL_DELIMITER = "://";
    private static final String PROD_HOST = "www.alertsite.com";
    private static final String LOCATIONS_PATH = "/restapi/v2/devices/list/locations";
    private static final String UPLOAD_PATH = "/restapi/v2/devices/upload/testondemand";
    private static final String TEST_ON_DEMAND_DOMAIN = TestOnDemandCaller.getDomain();
    private static final String LOCATIONS_URI = TestOnDemandCaller.getProtocol() + "://" + TEST_ON_DEMAND_DOMAIN + "/restapi/v2/devices/list/locations";
    private static final String UPLOAD_URI = TestOnDemandCaller.getProtocol() + "://" + TEST_ON_DEMAND_DOMAIN + "/restapi/v2/devices/upload/testondemand";
    private static final String REDIRECT_URL_XPATH_EXPRESSION = "//RedirectURL";
    private static final String LOCATION_XPATH_EXPRESSION = "//Location";
    private static final String LOCATION_CODE_XPATH_EXPRESSION = "LocCode";
    private static final String LOCATION_NAME_XPATH_EXPRESSION = "LocName";
    private static final String LOCATION_SERVER_IP_ADDRESSES_XPATH_EXPRESSION = "LocIPs";
    private static final String API_VERSION = "2";
    private static final String APPLICATION_ZIP = "application/zip";
    private static final String BASE64 = "base64";
    private static final String USER_AGENT = "soapUI-" + SoapUI.SOAPUI_VERSION;
    private static final String LOCATIONS_NAME = "ListLocations";
    private static final String LOCATIONS_PARAMETER = "server_attrib=ITEST";
    private static final String UPLOAD_NAME = "TestOnDemand";
    private static final String UPLOAD_PARAMETER_LOCATION_PREFIX = "test_location=";
    private static final String SERVER_IP_ADDRESSES_DELIMETER = ",";
    protected static final String COULD_NOT_SAVE_TEMPORARY_PROJECT_MESSAGE = "Could not save temporary project file before sending TestCase";
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final Logger log = Logger.getLogger(TestOnDemandCaller.class);

    @NonNull
    public List<Location> getLocations() throws Exception {
        Document responseDocument = this.makeCall(LOCATIONS_URI, this.generateLocationsRequestXML());
        NodeList locationNodes = (NodeList)this.xpath.evaluate(LOCATION_XPATH_EXPRESSION, responseDocument, XPathConstants.NODESET);
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < locationNodes.getLength(); ++i) {
            Node locationNode = locationNodes.item(i);
            String name = (String)this.xpath.evaluate(LOCATION_NAME_XPATH_EXPRESSION, locationNode, XPathConstants.STRING);
            String code = (String)this.xpath.evaluate(LOCATION_CODE_XPATH_EXPRESSION, locationNode, XPathConstants.STRING);
            String unformattedServerIPAddresses = (String)this.xpath.evaluate(LOCATION_SERVER_IP_ADDRESSES_XPATH_EXPRESSION, locationNode, XPathConstants.STRING);
            String[] serverIPAddresses = new String[]{};
            if (!unformattedServerIPAddresses.isEmpty()) {
                serverIPAddresses = unformattedServerIPAddresses.split(SERVER_IP_ADDRESSES_DELIMETER);
            }
            locations.add(new Location(code, name, serverIPAddresses));
        }
        return locations;
    }

    @NonNull
    public String sendTestCase(@NonNull WsdlTestCase testCase, @NonNull Location location) throws Exception {
        ExtendedPostMethod post = new ExtendedPostMethod();
        post.setURI(new URI(UPLOAD_URI));
        String locationCode = location.getCode();
        String encodedTestSuiteName = TestOnDemandCaller.getBase64EncodedString(testCase.getTestSuite().getName().getBytes());
        String encodedTestCaseName = TestOnDemandCaller.getBase64EncodedString(testCase.getName().getBytes());
        File tempProjectFile = this.saveTemporaryProject(testCase.getTestSuite().getProject());
        byte[] projectFileData = TestOnDemandCaller.getBytes(tempProjectFile.getAbsolutePath());
        byte[] zipedProjectFileData = TestOnDemandCaller.zipBytes(testCase.getTestSuite().getProject().getName(), projectFileData);
        String encodedZipedProjectFile = TestOnDemandCaller.getBase64EncodedString(zipedProjectFileData);
        String projectPassword = testCase.getTestSuite().getProject().getShadowPassword();
        String encodedProjectPassword = TestOnDemandCaller.getBase64EncodedString(Strings.nullToEmpty((String)projectPassword).getBytes());
        String keystoreFilePath = SoapUI.getSettings().getString(SSLSettings.KEYSTORE, "");
        byte[] keystoreFileData = TestOnDemandCaller.getBytes(keystoreFilePath);
        String encodedKeystoreFile = TestOnDemandCaller.getBase64EncodedString(keystoreFileData);
        String encodedKeystorePassword = TestOnDemandCaller.getBase64EncodedString(SoapUI.getSettings().getString(SSLSettings.KEYSTORE_PASSWORD, "").getBytes());
        String requestContent = this.generateUploadRequestXML(locationCode, encodedTestSuiteName, encodedTestCaseName, encodedZipedProjectFile, encodedProjectPassword, encodedKeystoreFile, encodedKeystorePassword);
        byte[] compressedRequestContent = CompressionSupport.compress("gzip", requestContent.getBytes());
        post.setEntity((HttpEntity)new ByteArrayEntity(compressedRequestContent));
        Document responseDocument = this.makeCall(UPLOAD_URI, requestContent);
        String redirectURL = (String)this.xpath.evaluate(REDIRECT_URL_XPATH_EXPRESSION, responseDocument, XPathConstants.STRING);
        if (Strings.isNullOrEmpty((String)redirectURL)) {
            throw new RuntimeException("The RedirectURL element is missing in the response message");
        }
        return redirectURL;
    }

    protected File saveTemporaryProject(WsdlProject project) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("project-temp-", ".xml", null);
            project.saveIn(tempFile);
        }
        catch (IOException e) {
            SoapUI.logError(e, COULD_NOT_SAVE_TEMPORARY_PROJECT_MESSAGE);
        }
        return tempFile;
    }

    private Document makeCall(String uri, String requestContent) throws Exception {
        ExtendedPostMethod post = new ExtendedPostMethod();
        post.setURI(new URI(uri));
        post.setEntity((HttpEntity)new StringEntity(requestContent));
        log.debug((Object)("Sending request to " + uri));
        log.debug((Object)requestContent);
        HttpClientSupport.execute(post);
        byte[] responseBody = post.getResponseBody();
        log.debug((Object)("Got response from " + uri));
        log.debug((Object)new String(responseBody));
        String reponseBodyAsString = new String(responseBody);
        return XmlUtils.parseXml(reponseBodyAsString);
    }

    private String generateLocationsRequestXML() {
        TestOnDemandLocationsRequestDocumentConfig.TestOnDemandLocationsRequest locationsRequest = TestOnDemandLocationsRequestDocumentConfig.Factory.newInstance().addNewTestOnDemandLocationsRequest();
        TestOnDemandLocationsRequestDocumentConfig.TestOnDemandLocationsRequest.Request request = locationsRequest.addNewRequest();
        request.setApiVersion(API_VERSION);
        TestOnDemandHeaderConfig header = request.addNewHeader();
        header.setUserAgent(USER_AGENT);
        TestOnDemandCommandConfig command = request.addNewBody().addNewCommand();
        command.setName(LOCATIONS_NAME);
        command.setParameters(LOCATIONS_PARAMETER);
        return locationsRequest.xmlText(this.getXmlOptionsWithoutNamespaces());
    }

    private String generateUploadRequestXML(String locationCode, String encodedTestSuiteName, String encodedTestCaseName, String encodedZipedProjectFile, String encodedProjectPassword, String encodedKeystoreFile, String encodedKeystorePassword) {
        TestOnDemandUploadRequestDocumentConfig.TestOnDemandUploadRequest uploadRequestConfig = TestOnDemandUploadRequestDocumentConfig.Factory.newInstance().addNewTestOnDemandUploadRequest();
        TestOnDemandUploadRequestDocumentConfig.TestOnDemandUploadRequest.Request requestConfig = uploadRequestConfig.addNewRequest();
        requestConfig.setApiVersion(API_VERSION);
        TestOnDemandHeaderConfig headerConfig = requestConfig.addNewHeader();
        headerConfig.setUserAgent(USER_AGENT);
        TestOnDemandUploadBodyConfig bodyConfig = requestConfig.addNewBody();
        TestOnDemandCommandConfig commandConfig = bodyConfig.addNewCommand();
        commandConfig.setName(UPLOAD_NAME);
        commandConfig.setParameters(UPLOAD_PARAMETER_LOCATION_PREFIX + locationCode);
        TestOnDemandTxnConfig txnConfig = bodyConfig.addNewTxn();
        TestOnDemandTestSuiteConfig testSuiteConfig = txnConfig.addNewTestSuite();
        testSuiteConfig.setEnctype(BASE64);
        testSuiteConfig.setStringValue(encodedTestSuiteName);
        TestOnDemandTestCaseConfig testCaseConfig = txnConfig.addNewTestCase();
        testCaseConfig.setEnctype(BASE64);
        testCaseConfig.setStringValue(encodedTestCaseName);
        TestOnDemandContentConfig contentConfig = txnConfig.addNewContent();
        contentConfig.setEnctype(BASE64);
        contentConfig.setType(APPLICATION_ZIP);
        contentConfig.setStringValue(encodedZipedProjectFile);
        TestOnDemandProjectPasswordConfig projectPasswordConfig = txnConfig.addNewPassword();
        projectPasswordConfig.setEnctype(BASE64);
        projectPasswordConfig.setStringValue(encodedProjectPassword);
        TestOnDemandKeystoreConfig keystoreConfig = bodyConfig.addNewKeystore();
        TestOnDemandFileConfig fileConfig = keystoreConfig.addNewFile();
        fileConfig.setEnctype(BASE64);
        fileConfig.setStringValue(encodedKeystoreFile);
        TestOnDemandKeystorePasswordConfig keystorePasswordConfig = keystoreConfig.addNewPassword();
        keystorePasswordConfig.setEnctype(BASE64);
        keystorePasswordConfig.setStringValue(encodedKeystorePassword);
        return uploadRequestConfig.xmlText(this.getXmlOptionsWithoutNamespaces());
    }

    private XmlOptions getXmlOptionsWithoutNamespaces() {
        XmlOptions options = new XmlOptions();
        options.setUseDefaultNamespace();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("", "http://eviware.com/soapui/config");
        options.setSaveImplicitNamespaces(namespaces);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(String filePath) throws IOException {
        byte[] byteArray = new byte[]{};
        if (!Strings.isNullOrEmpty((String)filePath)) {
            File file = new File(filePath);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                byteArray = ByteStreams.toByteArray((InputStream)inputStream);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            {
            }
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] zipBytes(String filename, byte[] dataToBeZiped) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zipedOutputStream = new ZipOutputStream(outputStream);
        ZipEntry entry = new ZipEntry(filename);
        entry.setSize(dataToBeZiped.length);
        try {
            zipedOutputStream.putNextEntry(entry);
            zipedOutputStream.write(dataToBeZiped);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            zipedOutputStream.closeEntry();
            zipedOutputStream.close();
            throw throwable;
        }
        zipedOutputStream.closeEntry();
        zipedOutputStream.close();
        return outputStream.toByteArray();
    }

    private static String getDomain() {
        String customEndpoint = System.getProperty("soapui.testondemand.host");
        if (customEndpoint == null) {
            return PROD_HOST;
        }
        return customEndpoint;
    }

    private static String getProtocol() {
        return System.getProperty("soapui.testondemand.protocol", DEFAULT_PROTOCOL);
    }

    private static String getBase64EncodedString(byte[] bytesToEncode) {
        return new String(Base64.encodeBase64((byte[])bytesToEncode));
    }
}

