/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.MockAsWar;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public class SoapUIMockAsWarGenerator
extends AbstractSoapUIRunner {
    public static String TITLE = "soapUI " + SoapUI.SOAPUI_VERSION + " War Generator";
    private boolean includeActions;
    private boolean includeListeners;
    private boolean includeLibraries;
    private boolean enableWebUI;
    private String localEndpoint;
    private String warFile;

    public SoapUIMockAsWarGenerator() {
        super(TITLE);
    }

    public SoapUIMockAsWarGenerator(String title) {
        super(title);
    }

    public static void main(String[] args) throws Exception {
        System.exit(new SoapUIMockAsWarGenerator().runFromCommandLine(args));
    }

    protected boolean processCommandLine(CommandLine cmd) {
        this.setEnableWebUI(cmd.hasOption('w'));
        this.setIncludeActions(cmd.hasOption('a'));
        this.setIncludeLibraries(cmd.hasOption('x'));
        this.setIncludeListeners(cmd.hasOption('l'));
        if (cmd.hasOption("s")) {
            this.setSettingsFile(this.getCommandLineOptionSubstSpace(cmd, "s"));
        }
        if (cmd.hasOption("p")) {
            this.setProjectPassword(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("v")) {
            this.setSoapUISettingsPassword(cmd.getOptionValue("v"));
        }
        if (cmd.hasOption("d")) {
            this.setOutputFolder(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("f")) {
            this.setWarFile(cmd.getOptionValue("f"));
        }
        if (cmd.hasOption("e")) {
            this.setLocalEndpoint(cmd.getOptionValue("e"));
        }
        return true;
    }

    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = new AbstractSoapUIRunner.SoapUIOptions("wargenerator");
        options.addOption("x", true, "Specify if libraries in ext folder should be included");
        options.addOption("a", true, "Specify if custom actions should be included");
        options.addOption("l", true, "Specify if custom listeners should be included");
        options.addOption("w", true, "Specify if web UI should be enabled");
        options.addOption("e", true, "Set the local endpoint of the MockService");
        options.addOption("f", true, "Specify the name of the generated WAR file");
        options.addOption("d", true, "Sets the local folder to use for war generation");
        options.addOption("s", true, "Sets the soapui-settings.xml file to use");
        options.addOption("p", true, "Sets project password for decryption if project is encrypted");
        options.addOption("v", true, "Sets password for soapui-settings.xml file");
        return options;
    }

    protected boolean runRunner() throws Exception {
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(this.getProjectFile(), this.getProjectPassword());
        String pFile = this.getProjectFile();
        project.getSettings().setString(ProjectSettings.SHADOW_PASSWORD, null);
        File tmpProjectFile = new File(System.getProperty("java.io.tmpdir"));
        tmpProjectFile = new File(tmpProjectFile, project.getName() + "-project.xml");
        project.beforeSave();
        project.saveIn(tmpProjectFile);
        pFile = tmpProjectFile.getAbsolutePath();
        String endpoint = StringUtils.hasContent(this.localEndpoint) ? this.localEndpoint : project.getName();
        this.log.info((Object)("Creating WAR file with endpoint [" + endpoint + "]"));
        MockAsWar mockAsWar = new MockAsWar(pFile, this.getSettingsFile(), this.getOutputFolder(), this.warFile, this.includeLibraries, this.includeActions, this.includeListeners, endpoint, this.enableWebUI);
        mockAsWar.createMockAsWarArchive();
        this.log.info((Object)"WAR Generation complete");
        return true;
    }

    public boolean isIncludeActions() {
        return this.includeActions;
    }

    public void setIncludeActions(boolean includeActions) {
        this.includeActions = includeActions;
    }

    public boolean isIncludeListeners() {
        return this.includeListeners;
    }

    public void setIncludeListeners(boolean includeListeners) {
        this.includeListeners = includeListeners;
    }

    public boolean isIncludeLibraries() {
        return this.includeLibraries;
    }

    public void setIncludeLibraries(boolean includeLibraries) {
        this.includeLibraries = includeLibraries;
    }

    public boolean isEnableWebUI() {
        return this.enableWebUI;
    }

    public void setEnableWebUI(boolean enableWebUI) {
        this.enableWebUI = enableWebUI;
    }

    public String getLocalEndpoint() {
        return this.localEndpoint;
    }

    public void setLocalEndpoint(String localEndpoint) {
        this.localEndpoint = localEndpoint;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public void setWarFile(String warFile) {
        this.warFile = warFile;
    }
}

