/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.support.MockRunListenerAdapter;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.tools.AbstractSoapUIRunner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;

public class SoapUIMockServiceRunner
extends AbstractSoapUIRunner {
    private String mockService;
    private String port;
    private String path;
    private List<MockRunner> runners = new ArrayList<MockRunner>();
    private boolean block;
    private String projectPassword;
    private WsdlProject project;
    private boolean saveAfterRun;
    public static String TITLE = "soapUI " + SoapUI.SOAPUI_VERSION + " MockService Runner";

    public static void main(String[] args) throws Exception {
        System.exit(new SoapUIMockServiceRunner().runFromCommandLine(args));
    }

    public void setMockService(String mockService) {
        this.mockService = mockService;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public SoapUIMockServiceRunner() {
        super(TITLE);
    }

    public SoapUIMockServiceRunner(String title) {
        super(title);
    }

    public boolean runRunner() throws Exception {
        int c;
        this.initGroovyLog();
        String projectFile = this.getProjectFile();
        this.project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile, this.getProjectPassword());
        if (this.project.isDisabled()) {
            throw new Exception("Failed to load soapUI project file [" + projectFile + "]");
        }
        this.initProject();
        if (this.mockService == null) {
            this.log.info((Object)("Running all MockServices in project [" + this.project.getName() + "]"));
        } else {
            this.log.info((Object)("Running MockService [" + this.mockService + "] in project [" + this.project.getName() + "]"));
        }
        this.log.info((Object)"Press any key to terminate");
        long startTime = System.nanoTime();
        for (c = 0; c < this.project.getMockServiceCount(); ++c) {
            WsdlMockService ms = this.project.getMockServiceAt(c);
            if (this.mockService != null && !ms.getName().equals(this.mockService)) continue;
            this.runMockService(ms);
        }
        this.log.info((Object)("Started " + this.runners.size() + " runner" + (this.runners.size() == 1 ? "" : "s")));
        if (this.block) {
            System.out.println("Press any key to terminate...");
            while (System.in.available() == 0) {
                Thread.sleep(1000L);
                for (c = 0; c < this.runners.size(); ++c) {
                    if (this.runners.get(c).isRunning()) continue;
                    this.runners.remove(c);
                    --c;
                }
                if (!this.runners.isEmpty()) continue;
            }
            if (System.in.available() > 0) {
                System.in.read();
            }
            for (MockRunner runner : this.runners) {
                runner.stop();
            }
            if (this.saveAfterRun && !this.project.isRemote()) {
                try {
                    this.project.save();
                }
                catch (Throwable t) {
                    this.log.error((Object)"Failed to save project", t);
                }
            }
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        this.log.info((Object)("time taken: " + timeTaken + "ms"));
        this.exportReports();
        return this.block;
    }

    protected void initProject() throws Exception {
        this.initProjectProperties(this.project);
    }

    protected void exportReports() throws Exception {
    }

    public void runMockService(WsdlMockService mockService) {
        try {
            if (this.path != null) {
                mockService.setPath(this.path);
            }
            if (this.port != null) {
                mockService.setPort(Integer.parseInt(this.port));
            }
            mockService.addMockRunListener(new LogListener());
            WsdlMockRunner runner = mockService.start();
            runner.setLogEnabled(false);
            this.runners.add(runner);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected AbstractSoapUIRunner.SoapUIOptions initCommandLineOptions() {
        AbstractSoapUIRunner.SoapUIOptions options = new AbstractSoapUIRunner.SoapUIOptions("mockservicerunner");
        options.addOption("m", true, "Specified the name of the MockService to run");
        options.addOption("p", true, "Sets the local port to listen on");
        options.addOption("a", true, "Sets the url path to listen on");
        options.addOption("s", true, "Sets the soapui-settings.xml file to use");
        options.addOption("b", false, "Turns off blocking read for termination");
        options.addOption("x", true, "Sets project password for decryption if project is encrypted");
        options.addOption("v", true, "Sets password for soapui-settings.xml file");
        options.addOption("D", true, "Sets system property with name=value");
        options.addOption("G", true, "Sets global property with name=value");
        options.addOption("P", true, "Sets or overrides project property with name=value");
        options.addOption("S", false, "Saves the project after running the mockService(s)");
        return options;
    }

    protected boolean processCommandLine(CommandLine cmd) {
        if (cmd.hasOption("m")) {
            this.setMockService(this.getCommandLineOptionSubstSpace(cmd, "m"));
        }
        if (cmd.hasOption("a")) {
            this.setPath(this.getCommandLineOptionSubstSpace(cmd, "a"));
        }
        if (cmd.hasOption("p")) {
            this.setPort(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("s")) {
            this.setSettingsFile(this.getCommandLineOptionSubstSpace(cmd, "s"));
        }
        this.setBlock(!cmd.hasOption('b'));
        this.setSaveAfterRun(cmd.hasOption('S'));
        if (cmd.hasOption("x")) {
            this.setProjectPassword(cmd.getOptionValue("x"));
        }
        if (cmd.hasOption("v")) {
            this.setSoapUISettingsPassword(cmd.getOptionValue("v"));
        }
        if (cmd.hasOption("D")) {
            this.setSystemProperties(cmd.getOptionValues("D"));
        }
        if (cmd.hasOption("G")) {
            this.setGlobalProperties(cmd.getOptionValues("G"));
        }
        if (cmd.hasOption("P")) {
            this.setProjectProperties(cmd.getOptionValues("P"));
        }
        return true;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public String getProjectPassword() {
        return this.projectPassword;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public void setSaveAfterRun(boolean saveAfterRun) {
        this.saveAfterRun = saveAfterRun;
    }

    public WsdlProject getProject() {
        return this.project;
    }

    public void stopAll() {
        for (MockRunner runner : this.runners) {
            runner.stop();
        }
    }

    public class LogListener
    extends MockRunListenerAdapter {
        private int responseCount;

        public void onMockRunnerStart(MockRunner mockRunner) {
            SoapUIMockServiceRunner.this.log.info((Object)("MockService started on port " + mockRunner.getMockService().getPort() + " at path [" + mockRunner.getMockService().getPath() + "]"));
        }

        public void onMockRunnerStop(MockRunner mockRunner) {
            SoapUIMockServiceRunner.this.log.info((Object)("MockService stopped, handled " + this.responseCount + " requests"));
        }

        public void onMockResult(MockResult result) {
            ++this.responseCount;
            if (result.getMockResponse() == null) {
                SoapUIMockServiceRunner.this.log.info((Object)("Handled request " + this.responseCount + " - [missing mockResponse] in [" + result.getTimeTaken() + "ms] at [" + DateUtil.formatExtraFull(new Date(result.getTimestamp())) + "]"));
            } else {
                SoapUIMockServiceRunner.this.log.info((Object)("Handled request " + this.responseCount + "; [" + result.getMockResponse().getMockOperation().getName() + "] with [" + result.getMockResponse().getName() + "] in [" + result.getTimeTaken() + "ms] at [" + DateUtil.formatExtraFull(new Date(result.getTimestamp())) + "]"));
            }
        }
    }
}

