/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.cookie;

import com.jniwrapper.IntegerParameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.Cookie;
import com.jniwrapper.win32.wininet.InternetCacheEntry;
import com.jniwrapper.win32.wininet.InternetCacheEntryInfo;
import com.jniwrapper.win32.wininet.InternetFunctions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager {
    private static final Logger a = LoggerFactory.getLogger(CookieManager.class);
    private static CookieManager b;

    public static CookieManager getInstance() {
        if (b == null) {
            b = new CookieManager();
            return b;
        }
        return b;
    }

    private CookieManager() {
    }

    public Set<Cookie> getPersistentCookies() {
        HashSet<Cookie> hashSet = new HashSet<Cookie>();
        Iterator<a> iterator = ((CookieManager)((Object)iterator)).a();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            a a2 = iterator.next();
            hashSet.addAll(a2.c());
        }
        return hashSet;
    }

    private List<a> a() {
        LinkedList<a> linkedList = new LinkedList<a>();
        UInt32 uInt32 = new UInt32(4096L);
        InternetCacheEntryInfo internetCacheEntryInfo = null;
        Handle handle = new Handle();
        boolean bl2 = false;
        int n2 = 122;
        do {
            switch (n2) {
                case 122: {
                    internetCacheEntryInfo = InternetCacheEntryInfo.createInternetCacheEntryInfo((int)uInt32.getValue());
                    internetCacheEntryInfo.setStructSize(uInt32.getValue());
                    Object object = new UInt32(uInt32.getValue());
                    try {
                        if (handle.isNull()) {
                            handle = InternetFunctions.findFirstUrlCacheEntry(null, internetCacheEntryInfo, (UInt32)object);
                        } else {
                            InternetFunctions.findNextUrlCacheEntry(handle, internetCacheEntryInfo, (UInt32)object);
                        }
                        n2 = 0;
                    }
                    catch (LastErrorException lastErrorException) {
                        LastErrorException lastErrorException2 = lastErrorException;
                        n2 = (int)lastErrorException.getErrorCode();
                        uInt32 = new UInt32(object.getValue());
                    }
                    break;
                }
                case 259: {
                    bl2 = true;
                    break;
                }
                case 0: {
                    long l2 = internetCacheEntryInfo.getCacheEntryType();
                    Object object = new FlagSet(l2);
                    if (object.contains((long)InternetCacheEntry.COOKIE_CACHE_ENTRY.getValue())) {
                        String string = internetCacheEntryInfo.getSourceUrlName();
                        object = internetCacheEntryInfo.getLocalFileName();
                        linkedList.add(new a(this, (String)object, string));
                    }
                    object = new UInt32((IntegerParameter)uInt32);
                    try {
                        if (!InternetFunctions.findNextUrlCacheEntry(handle, internetCacheEntryInfo, (UInt32)object)) break;
                        n2 = 0;
                    }
                    catch (LastErrorException lastErrorException) {
                        LastErrorException lastErrorException3 = lastErrorException;
                        n2 = (int)lastErrorException.getErrorCode();
                        uInt32 = new UInt32(object.getValue());
                    }
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (!bl2 || handle.isNull()) continue;
            InternetFunctions.findCloseUrlCache(handle);
        } while (!bl2);
        return linkedList;
    }

    private static URL a(File file) {
        try {
            Closeable closeable = new FileInputStream(file);
            closeable = new InputStreamReader((InputStream)closeable);
            closeable = new BufferedReader((Reader)closeable);
            ((BufferedReader)closeable).readLine();
            ((BufferedReader)closeable).readLine();
            String string = ((BufferedReader)closeable).readLine();
            ((BufferedReader)closeable).close();
            return new URL("http://" + (string.endsWith("/") ? string : string + "/"));
        }
        catch (Exception exception) {
            a.error("Cannot read data from cookie file " + file.getName());
            return null;
        }
    }

    public Set<Cookie> getCookies(URL uRL) {
        Object object = InternetFunctions.getCookie(uRL.toString());
        if (object == null) {
            return new HashSet<Cookie>();
        }
        object = Cookie.create((String)object);
        Iterator<Cookie> iterator = object.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = iterator.next();
            cookie.setDomain(uRL.toString());
        }
        return object;
    }

    public Set<Cookie> getCookies(URL uRL, WebBrowser webBrowser) {
        return webBrowser.getCookies(uRL);
    }

    public void setCookies(URL uRL, Set<Cookie> set) {
        Iterator iterator = new HashSet<Cookie>(set);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            cookie.setDomain(null);
        }
        InternetFunctions.setCookie(uRL.toString(), null, Cookie.makeString(set));
    }

    public void setCookies(URL uRL, Set<Cookie> set, WebBrowser webBrowser) {
        webBrowser.setCookies(uRL, set);
    }

    public void setCookie(URL uRL, Cookie cookie) {
        HashSet<Cookie> hashSet = new HashSet<Cookie>();
        hashSet.add(cookie);
        this.setCookies(uRL, hashSet);
    }

    public void deletePersistentCookie(Cookie cookie) {
        Object object = this.a();
        object = object.iterator();
        while (object.hasNext()) {
            a a2 = (a)object.next();
            Set<Cookie> set = a2.c();
            if (!set.contains(cookie)) continue;
            this.deleteCookie(a2.b(), cookie);
        }
    }

    public void deleteAllPersistentCookies() {
        Iterator<a> iterator = ((CookieManager)((Object)iterator)).a();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            a a2 = iterator.next();
            InternetFunctions.deleteUrlChashEntry(a2.a());
        }
    }

    public void deleteCookie(URL uRL, Cookie cookie) {
        if (uRL != null && cookie != null) {
            cookie.setExpireDate(new Date(-1L));
            HashSet<Cookie> hashSet = new HashSet<Cookie>();
            hashSet.add(cookie);
            this.setCookies(uRL, hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a {
        private String a;
        private URL b;
        private /* synthetic */ CookieManager c;

        private a(CookieManager cookieManager, String string, String string2) {
            this.c = cookieManager;
            this.a = string2;
            this.b = CookieManager.a(new File(string));
        }

        public final String a() {
            return this.a;
        }

        public final URL b() {
            return this.b;
        }

        public final Set<Cookie> c() {
            if (this.b != null) {
                return this.c.getCookies(this.b);
            }
            return new HashSet<Cookie>();
        }
    }
}

