/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class AutoRefreshCheckBox
extends JCheckBox
implements DocumentComponentListener {
    private static AutoRefreshCheckBox singleton = new AutoRefreshCheckBox();

    private AutoRefreshCheckBox() {
        this.setSelectedIcon(IconCache.getIcon("hermes.messages.autorefresh.off"));
        this.setIcon(IconCache.getIcon("hermes.messages.autorefresh.on"));
        this.setEnabled(false);
        this.setSelected(false);
        this.setOpaque(false);
        this.setToolTipText("Enable auto refresh.");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof BrowserAction) {
                    BrowserAction action = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
                    action.setAutoBrowse(AutoRefreshCheckBox.this.isSelected());
                    if (AutoRefreshCheckBox.this.isSelected()) {
                        AutoRefreshCheckBox.this.setToolTipText("Disable auto refresh.");
                    } else {
                        AutoRefreshCheckBox.this.setToolTipText("Enable auto refresh.");
                    }
                }
            }
        });
    }

    public static AutoRefreshCheckBox getInstance() {
        return singleton;
    }

    protected void checkEnabled(Object object) {
        if (object instanceof BrowserAction) {
            BrowserAction browseAction = (BrowserAction)object;
            if (browseAction.isRefreshable()) {
                this.setEnabled(true);
                this.setSelected(browseAction.isAutoBrowse());
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentActivated(DocumentComponentEvent event) {
        this.checkEnabled(event.getSource());
    }

    public void documentComponentClosed(DocumentComponentEvent event) {
        this.setEnabled(false);
    }

    public void documentComponentClosing(DocumentComponentEvent event) {
        this.setEnabled(false);
    }

    public void documentComponentDeactivated(DocumentComponentEvent event) {
        this.setEnabled(false);
    }

    public void documentComponentOpened(DocumentComponentEvent event) {
        this.checkEnabled(event.getSource());
    }
}

