/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBar;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.status.TimeStatusBarItem;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.SplashScreen;
import com.jidesoft.utils.Lm;
import hermes.ConnectionListener;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesConfigurationListener;
import hermes.HermesException;
import hermes.HermesInitialContextFactory;
import hermes.HermesLoader;
import hermes.HermesRepositoryManager;
import hermes.JAXBHermesLoader;
import hermes.JNDIContextFactory;
import hermes.SingletonManager;
import hermes.browser.AutoRefreshCheckBox;
import hermes.browser.BrowserTreeDockableFrame;
import hermes.browser.ConfigurationToolBar;
import hermes.browser.DateComparator;
import hermes.browser.DocumentComponetListenerSupport;
import hermes.browser.HermesUI;
import hermes.browser.IconCache;
import hermes.browser.IntegerComparator;
import hermes.browser.JNDIToolBar;
import hermes.browser.LongComparator;
import hermes.browser.MainDocumentPane;
import hermes.browser.MainToolBar;
import hermes.browser.MenuBar;
import hermes.browser.MessageToolBar;
import hermes.browser.UIMessageSink;
import hermes.browser.actions.ActionFactory;
import hermes.browser.actions.BrowserAction;
import hermes.browser.components.ActionsPanel;
import hermes.browser.components.BrowserTree;
import hermes.browser.components.DockableToolPanel;
import hermes.browser.components.Log4JOutputViewer;
import hermes.browser.components.NavigableComponent;
import hermes.browser.components.WatchDockableFrame;
import hermes.browser.dialog.ClasspathIdCellEdtitor;
import hermes.browser.dialog.DirectoryCellEditor;
import hermes.browser.dialog.DomainCellEditor;
import hermes.browser.dialog.HermesCellEditor;
import hermes.browser.dialog.SelectorImpl;
import hermes.browser.dialog.SelectorImplCellEditor;
import hermes.browser.jython.JythonDockableFrame;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.tasks.HermesBrowserTaskListener;
import hermes.browser.tasks.TaskSupport;
import hermes.browser.tasks.ThreadPool;
import hermes.config.DestinationConfig;
import hermes.config.HermesConfig;
import hermes.config.NamingConfig;
import hermes.config.WatchConfig;
import hermes.fix.FIXPrettyPrinter;
import hermes.fix.FIXUtils;
import hermes.impl.ConfigDAO;
import hermes.impl.ConfigDAOImpl;
import hermes.impl.FileRepositoryManager;
import hermes.impl.SimpleClassLoaderManager;
import hermes.renderers.RendererManager;
import hermes.util.JVMUtils;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jsyntaxpane.DefaultSyntaxKit;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;
import org.python.core.PyException;

public class HermesBrowser
extends DefaultDockableBarDockableHolder
implements HermesUI {
    public static final int DEFAULT_MAX_CACHED_MESSAGES = 1000;
    public static final long DEFAULT_QUEUE_BROWSE_CONSUMER_TIMEOUT = 10000L;
    private static final String DEFAULT_PROFILE_NAME = "hermes.layout";
    private static final String HERMES_TITLE = "Hermes v1.14 SoapUI beta1";
    private static final Logger log = Logger.getLogger(HermesBrowser.class);
    private static final RendererManager rendererManager = new RendererManager();
    private static final ConfigDAO configDAO = new ConfigDAOImpl();
    private static final long serialVersionUID = 995079090594726460L;
    private static HermesBrowser ui;
    private static final String USER_PROFILE_NAME;
    private boolean restricted = System.getProperty("hermes.restricted") != null;
    private ActionFactory actionFactory = new ActionFactory(this);
    private ActionsPanel actionsPane;
    private DocumentPane browserPane;
    private JythonDockableFrame jythonFrame;
    private BrowserTreeDockableFrame browserTreePane;
    private Context context;
    private String currentConfig;
    private UIMessageSink defaultMessageSink;
    private boolean firstLoad = true;
    private File lastOpenConfigDirectory;
    private File lastUploadDirectory;
    private HermesLoader loader;
    private JMenuBar menuBar;
    private ProgressStatusBarItem progressStatus;
    private Map<String, WatchDockableFrame> queueWatchFrames = new HashMap<String, WatchDockableFrame>();
    private HermesRepositoryManager repManager;
    private StatusBar statusBar;
    private DockableToolPanel toolsPane;
    private Set<DocumentComponentListener> documentComponentListeners = new HashSet<DocumentComponentListener>();
    private Set<ListSelectionListener> messageSelectionListeners = new HashSet<ListSelectionListener>();

    public static HermesBrowser getBrowser() {
        return ui;
    }

    public static ConfigDAO getConfigDAO() {
        return configDAO;
    }

    public static RendererManager getRendererManager() {
        return rendererManager;
    }

    @Override
    public void setConfig(HermesConfig config) {
    }

    public static void main(String[] args) {
        log.debug((Object)"Hermes Browser v1.14 SoapUI beta1 starting...");
        Hermes.events.addConnectionListener(new ConnectionListener(){

            @Override
            public void onConnectionOpen(Hermes hermes) {
                log.debug((Object)("Connection " + hermes.getId() + " opened"));
            }

            @Override
            public void onConnectionClosed(Hermes hermes) {
                log.debug((Object)("Connection " + hermes.getId() + " closed"));
            }
        });
        JVMUtils.forceInit(SingletonManager.class);
        JVMUtils.forceInit(ThreadPool.class);
        JVMUtils.forceInit(SimpleClassLoaderManager.class);
        Lm.verifyLicense((String)"Colin Crist", (String)"Hermes", (String)"9vkNAfxF1lvVyW7uZXYjpxFskycSGLw1");
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class arg0, Object filename) {
                return new File((String)filename);
            }
        }, File.class);
        SplashScreen.create((ImageIcon)IconCache.getIcon("hermes.splash"));
        SplashScreen.show();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ui = new HermesBrowser(HermesBrowser.HERMES_TITLE);
                    ui.initJIDE();
                    try {
                        ui.loadConfig();
                    }
                    catch (NamingException ex) {
                        log.fatal((Object)("cannot initialise hermes: " + ex.getMessage()), (Throwable)ex);
                        System.exit(1);
                    }
                    catch (HeadlessException ex) {
                        log.fatal((Object)("cannot initialise hermes browser, no head: " + ex.getMessage()), (Throwable)ex);
                        System.exit(1);
                    }
                    ui.initUI();
                    ui.init();
                    ui.getLayoutPersistence().setProfileKey(ui.getUserProfileName());
                    ui.getLayoutPersistence().loadLayoutData();
                    ArrayList<WatchConfig> tmpList = new ArrayList<WatchConfig>(ui.getConfig().getWatch());
                    ui.getLoader().getConfig().getWatch().clear();
                    for (WatchConfig wConfig : tmpList) {
                        ui.createWatch(wConfig);
                    }
                    ui.firstLoad = false;
                }
                catch (Exception ex) {
                    log.fatal((Object)("cannot initialise hermes browser: " + ex.getMessage()), (Throwable)ex);
                }
            }
        });
    }

    private static void setStatusMessage(final String statusMessage) {
        if (ui != null && HermesBrowser.ui.progressStatus != null && statusMessage != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                HermesBrowser.ui.progressStatus.setStatus(statusMessage);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.progressStatus.setStatus(statusMessage);
                    }
                });
            }
        }
    }

    public HermesBrowser(String arg0) throws HeadlessException {
        super(arg0);
        this.defaultMessageSink = new UIMessageSink(){

            @Override
            public void add(String message) {
                HermesBrowser.setStatusMessage(message);
            }

            @Override
            public void add(StringBuffer message) {
                HermesBrowser.setStatusMessage(message.toString());
            }
        };
        TaskSupport.addGlobalListener(new HermesBrowserTaskListener(this));
    }

    public HermesRepositoryManager getRepositoryManager() {
        return this.repManager;
    }

    public void addDestinationConfig(Hermes hermes, DestinationConfig dConfig) throws JMSException {
        this.loader.addDestinationConfig(hermes, dConfig);
    }

    public void addMessageSelectionListener(ListSelectionListener listener) {
        this.messageSelectionListeners.add(listener);
    }

    public void addDocumentComponentListener(DocumentComponentListener listener) {
        this.documentComponentListeners.add(listener);
    }

    public int getSendPersistence() {
        return 2;
    }

    public void setCurrentConfig(String currentConfig) {
        this.currentConfig = currentConfig;
    }

    public void addDocumentComponent(final DocumentComponent document) {
        DocumentComponent existing;
        log.debug((Object)("addDocument() name=" + document.getName()));
        if (this.getDocumentPane().isDocumentOpened(document.getName()) && document != (existing = this.getDocumentPane().getDocument(document.getName()))) {
            this.getDocumentPane().closeDocument(document.getName());
        }
        for (DocumentComponentListener listener : this.documentComponentListeners) {
            document.addDocumentComponentListener(listener);
        }
        document.addDocumentComponentListener((DocumentComponentListener)AutoRefreshCheckBox.getInstance());
        document.addDocumentComponentListener((DocumentComponentListener)new DocumentComponetListenerSupport(){

            @Override
            public void documentComponentClosed(DocumentComponentEvent arg0) {
                for (DocumentComponentListener listener : HermesBrowser.this.documentComponentListeners) {
                    document.removeDocumentComponentListener(listener);
                }
                document.removeDocumentComponentListener((DocumentComponentListener)AutoRefreshCheckBox.getInstance());
            }
        });
        if (document instanceof NavigableComponent) {
            final NavigableComponent component = (NavigableComponent)document;
            for (ListSelectionListener listener : this.messageSelectionListeners) {
                component.getListSelectionModel().addListSelectionListener(listener);
            }
            document.addDocumentComponentListener((DocumentComponentListener)new DocumentComponetListenerSupport(){

                @Override
                public void documentComponentClosed(DocumentComponentEvent arg0) {
                    for (ListSelectionListener listener : HermesBrowser.this.messageSelectionListeners) {
                        component.getListSelectionModel().removeListSelectionListener(listener);
                    }
                }
            });
        }
        this.getDocumentPane().openDocument(document);
        this.getDocumentPane().setActiveDocument(document.getName());
    }

    public synchronized void addOrCreateWatch(String watchId, Hermes hermes) {
        WatchDockableFrame frame = null;
        if (this.queueWatchFrames.containsKey(watchId)) {
            frame = this.queueWatchFrames.get(watchId);
        } else {
            WatchConfig wConfig = HermesBrowser.getConfigDAO().createWatchConfig();
            wConfig.setId(watchId);
            frame = this.createWatch(wConfig);
        }
        frame.addWatch(hermes);
    }

    public synchronized void addOrCreateWatch(String watchId, Hermes hermes, DestinationConfig destination) {
        WatchDockableFrame frame = null;
        if (this.queueWatchFrames.containsKey(watchId)) {
            frame = this.queueWatchFrames.get(watchId);
        } else {
            WatchConfig wConfig = HermesBrowser.getConfigDAO().createWatchConfig();
            wConfig.setId(watchId);
            frame = this.createWatch(wConfig);
        }
        DestinationConfig dConfig = HermesBrowser.getConfigDAO().duplicateForWatch(destination, hermes);
        frame.addWatch(hermes.getId(), dConfig);
    }

    public void backupConfig() throws HermesException {
        this.loader.backup();
    }

    private void closeWatches() {
        for (Map.Entry<String, WatchDockableFrame> entry : this.queueWatchFrames.entrySet()) {
            WatchDockableFrame frame = entry.getValue();
            frame.close();
            this.getDockingManager().removeFrame(entry.getKey());
        }
    }

    private WatchDockableFrame createWatch(final WatchConfig wConfig) {
        final WatchDockableFrame frame = new WatchDockableFrame(wConfig);
        this.queueWatchFrames.put(wConfig.getId(), frame);
        frame.addDockableFrameListener((DockableFrameListener)new DockableFrameAdapter(){

            public void dockableFrameHidden(DockableFrameEvent arg0) {
                log.debug((Object)("watch frame " + wConfig.getId() + " removed, clearing up"));
                try {
                    HermesBrowser.this.getConfig().getWatch().remove(wConfig);
                    HermesBrowser.this.queueWatchFrames.remove(wConfig.getId());
                }
                catch (HermesException ex) {
                    Hermes.ui.getDefaultMessageSink().add("Unable to remove watch " + wConfig.getId() + " from configuration: " + ex.getMessage());
                }
                HermesBrowser.this.getDockingManager().removeFrame(wConfig.getId());
                frame.close();
            }
        });
        this.getDockingManager().addFrame((DockableFrame)frame);
        frame.setVisible(true);
        try {
            this.getConfig().getWatch().add(wConfig);
        }
        catch (HermesException ex) {
            Hermes.ui.getDefaultMessageSink().add("Unable to add watch " + wConfig.getId() + " to configuration: " + ex.getMessage());
        }
        frame.updateNow();
        return frame;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public ActionsPanel getActionsPanel() {
        return this.actionsPane;
    }

    public BrowserTree getBrowserTree() {
        return this.browserTreePane.getBrowserTree();
    }

    public Context createContext(String id) throws JMSException, NamingException, InvocationTargetException, IOException, IllegalAccessException, NoSuchMethodException {
        NamingConfig config = this.getBrowserTree().getBrowserModel().getNamingConfigTreeNode(id).getConfig();
        JNDIContextFactory factory = new JNDIContextFactory(config);
        return factory.createContext();
    }

    @Override
    public HermesConfig getConfig() throws HermesException {
        return this.loader.getConfig();
    }

    public Context getContext() {
        return this.context;
    }

    public String getCurrentConfigURL() {
        if (this.currentConfig == null) {
            String rval = System.getProperty("hermes");
            if (rval == null) {
                File dotHermes = new File(JVMUtils.getUserHome() + File.separator + ".hermes");
                if (!dotHermes.exists()) {
                    if (dotHermes.mkdir()) {
                        log.debug((Object)("created new directory: " + dotHermes.getAbsolutePath()));
                    } else {
                        log.error((Object)("could not create directory: " + dotHermes.getAbsolutePath()));
                        log.error((Object)"properties set are listed to stdout.");
                        System.getProperties().list(System.out);
                        System.exit(1);
                    }
                }
                File hermesXML = new File(dotHermes, "hermes-config.xml");
                try {
                    if (!hermesXML.exists()) {
                        int i;
                        hermesXML.createNewFile();
                        InputStream istream = this.getClass().getClassLoader().getResourceAsStream("hermes/bootstrap/default-hermes-config.xml");
                        FileOutputStream ostream = new FileOutputStream(hermesXML);
                        while ((i = istream.read()) != -1) {
                            ((OutputStream)ostream).write(i);
                        }
                        ((OutputStream)ostream).close();
                        log.debug((Object)("bootstrapped empty config to " + hermesXML.getPath()));
                    }
                    return hermesXML.toURI().getPath();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            return rval;
        }
        return this.currentConfig;
    }

    @Override
    public UIMessageSink getDefaultMessageSink() {
        return this.defaultMessageSink;
    }

    public DocumentPane getDocumentPane() {
        return this.browserPane;
    }

    public HermesLoader getLoader() {
        return this.loader;
    }

    public int getMaxMessagesInBrowserPane() throws HermesException {
        return this.loader.getConfig().getMaxMessagesInBrowserPane() == 0 ? 1000 : this.loader.getConfig().getMaxMessagesInBrowserPane();
    }

    public long getQueueBrowseConsumerTimeout() throws HermesException {
        return this.loader.getConfig().getQueueBrowseConsumerTimeout() == 0L ? 10000L : this.loader.getConfig().getQueueBrowseConsumerTimeout();
    }

    public HermesRepositoryManager getMessageRepository() {
        return this.repManager;
    }

    @Override
    public ThreadPool getThreadPool() {
        return ThreadPool.get();
    }

    public String getUserProfileName() {
        return USER_PROFILE_NAME;
    }

    public WatchDockableFrame getWatchFrame(String id) {
        return this.queueWatchFrames.get(id);
    }

    private void init() throws NamingException, JMSException, IOException {
        HermesConfig config = (HermesConfig)this.context.lookup("/conf/hermes");
        if (config.getMessageFilesDir() == null) {
            config.setMessageFilesDir("./messages");
        }
        File repDir = new File(TextUtils.replaceClasspathVariables(config.getMessageFilesDir()));
        try {
            this.loader.save();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!repDir.exists()) {
            repDir.mkdir();
        }
        this.repManager = new FileRepositoryManager(repDir, 5000L);
        this.repManager.addRepositoryListener((BrowserTreeModel)this.getBrowserTree().getModel());
        log.debug((Object)"setting maxThreadPoolSize");
        if (config.getMaxThreadPoolSize() == 0) {
            config.setMaxThreadPoolSize(1);
        }
        ThreadPool.get().setThreads(config.getMaxThreadPoolSize());
    }

    private void initJIDE() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            LookAndFeelFactory.installJideExtension();
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("l&f incompatible with JIDE, trying metal: " + e.getMessage()), (Throwable)e);
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            LookAndFeelFactory.installJideExtension();
        }
        ObjectConverterManager.initDefaultConverter();
        CellEditorManager.initDefaultEditor();
        CellRendererManager.initDefaultRenderer();
        ObjectComparatorManager.initDefaultComparator();
        LookAndFeelFactory.UIDefaultsCustomizer uiDefaultsCustomizer = new LookAndFeelFactory.UIDefaultsCustomizer(){

            public void customize(UIDefaults defaults) {
                Map painter = (Map)defaults.get("Theme.painter");
                defaults.put("OptionPaneUI", "com.jidesoft.plaf.basic.BasicJideOptionPaneUI");
                defaults.put("OptionPane.showBanner", Boolean.FALSE);
                defaults.put("OptionPane.bannerBackgroundDk", painter.get("OptionPane.bannerBackgroundDk"));
                defaults.put("OptionPane.bannerBackgroundLt", painter.get("OptionPane.bannerBackgroundLt"));
                defaults.put("OptionPane.bannerBackgroundDirection", Boolean.TRUE);
                defaults.put("OptionPane.bannerBackgroundPaint", (Object)null);
                defaults.put("OptionPane.buttonAreaBorder", BorderFactory.createEmptyBorder(6, 6, 6, 6));
                defaults.put("OptionPane.buttonOrientation", new Integer(4));
            }
        };
        uiDefaultsCustomizer.customize(UIManager.getDefaults());
    }

    private void initUI() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException, HermesException {
        if (System.getProperty("swing.defaultlaf") == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable e) {
                log.error((Object)("cannot load l&f, trying metal: " + e.getMessage()), e);
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        } else {
            UIManager.setLookAndFeel(System.getProperty("swing.defaultlaf"));
        }
        if (this.getConfig().isEnableJython() && this.jythonFrame == null) {
            this.jythonFrame = new JythonDockableFrame();
            this.getDockingManager().addFrame((DockableFrame)this.jythonFrame);
        }
        if (!this.getConfig().isEnableJython() && this.jythonFrame != null) {
            this.getDockingManager().removeFrame(this.jythonFrame.getKey());
            this.jythonFrame = null;
        }
        CellEditorManager.registerEditor(Domain.class, (CellEditor)((Object)new DomainCellEditor()));
        CellEditorManager.registerEditor(SelectorImpl.class, (CellEditor)((Object)new SelectorImplCellEditor()));
        CellEditorManager.registerEditor(File.class, (CellEditor)((Object)new DirectoryCellEditor()), (EditorContext)DirectoryCellEditor.CONTEXT);
        CellEditorManager.registerEditor(String.class, (CellEditor)((Object)new ClasspathIdCellEdtitor()), (EditorContext)ClasspathIdCellEdtitor.CONTEXT);
        CellEditorManager.registerEditor(Hermes.class, (CellEditor)((Object)new HermesCellEditor()));
        ObjectComparatorManager.registerComparator(Date.class, (Comparator)new DateComparator());
        ObjectComparatorManager.registerComparator(Integer.class, (Comparator)new IntegerComparator());
        ObjectComparatorManager.registerComparator(Long.class, (Comparator)new LongComparator());
        DefaultSyntaxKit.initKit();
        this.browserPane = new MainDocumentPane();
        MemoryStatusBarItem memoryStatusBar = new MemoryStatusBarItem();
        memoryStatusBar.setPreferredWidth(100);
        this.progressStatus = new ProgressStatusBarItem();
        this.statusBar = new StatusBar();
        this.statusBar.add((Component)this.progressStatus, (Object)"vary");
        this.statusBar.add((Component)new TimeStatusBarItem(), (Object)"flexible");
        this.statusBar.add((Component)memoryStatusBar, (Object)"flexible");
        this.actionsPane = new ActionsPanel();
        this.toolsPane = new DockableToolPanel();
        this.toolsPane.addToolPanel("Tasks", (JComponent)new JideScrollPane((Component)this.actionsPane));
        this.toolsPane.addToolPanel("Log", new Log4JOutputViewer(""));
        this.browserTreePane = new BrowserTreeDockableFrame();
        this.browserTreePane.setLoader(this.loader);
        this.setJMenuBar((JMenuBar)((Object)new MenuBar(this)));
        this.setIconImage(IconCache.getIcon("hermes.icon").getImage());
        this.getDockingManager().setUsePref(false);
        this.getDockingManager().setProfileKey(USER_PROFILE_NAME);
        this.getDockingManager().setInitSplitPriority(1);
        this.getDockingManager().getWorkspace().add((Component)this.browserPane, (Object)"Center");
        this.getDockingManager().addFrame((DockableFrame)this.browserTreePane);
        this.getDockingManager().addFrame((DockableFrame)this.toolsPane);
        this.getDockableBarManager().addDockableBar((DockableBar)new MainToolBar());
        this.getDockableBarManager().addDockableBar((DockableBar)new MessageToolBar());
        this.getDockableBarManager().addDockableBar((DockableBar)new ConfigurationToolBar());
        this.getDockableBarManager().addDockableBar((DockableBar)new JNDIToolBar());
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.setDefaultCloseOperation(3);
        this.toFront();
        HermesBrowser.setStatusMessage("Ready");
        SplashScreen.hide();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
            }
        });
    }

    public boolean isBrowseActionSelected() {
        BrowserAction action;
        return this.browserPane.getActiveDocument() instanceof BrowserAction && (action = (BrowserAction)this.browserPane.getActiveDocument()).getSelectedMessages().size() > 0;
    }

    public void loadConfig() throws NamingException, HermesException {
        Properties props = new Properties();
        Context oldContext = this.context;
        HermesConfig oldConfig = null;
        props.put("java.naming.factory.initial", HermesInitialContextFactory.class.getName());
        props.put("java.naming.provider.url", this.getCurrentConfigURL());
        props.put("hermes.loader", JAXBHermesLoader.class.getName());
        log.debug((Object)("props=" + props));
        Iterator listeners = null;
        if (this.loader != null) {
            listeners = this.loader.getConfigurationListeners();
            oldConfig = this.loader.getConfig();
        }
        if (oldConfig != null) {
            HashSet<NamingConfig> naming = new HashSet<NamingConfig>();
            naming.addAll(oldConfig.getNaming());
            for (NamingConfig oldNaming : naming) {
                this.loader.notifyNamingRemoved(oldNaming);
            }
        }
        this.context = new InitialContext(props);
        this.loader = (HermesLoader)this.context.lookup("/conf/loader");
        if (listeners != null) {
            while (listeners.hasNext()) {
                this.loader.addConfigurationListener((HermesConfigurationListener)listeners.next());
            }
        }
        if (oldContext != null) {
            NamingEnumeration<Binding> iter = oldContext.listBindings("");
            while (iter.hasMoreElements()) {
                Binding binding = iter.next();
                try {
                    if (!(oldContext.lookup(binding.getName()) instanceof Hermes)) continue;
                    Hermes hermes = (Hermes)oldContext.lookup(binding.getName());
                    Hermes newHermes = null;
                    try {
                        newHermes = (Hermes)this.context.lookup(hermes.getId());
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                    if (newHermes != null) continue;
                    this.loader.notifyHermesRemoved(hermes);
                }
                catch (NamingException ex) {}
            }
        }
        if (!this.firstLoad) {
            this.closeWatches();
            ArrayList<WatchConfig> tmpList = new ArrayList<WatchConfig>();
            tmpList.addAll(this.loader.getConfig().getWatch());
            this.loader.getConfig().getWatch().clear();
            for (WatchConfig wConfig : tmpList) {
                this.createWatch(wConfig);
            }
        }
        this.setTitle("HermesJMS - " + TextUtils.crumble(this.getCurrentConfigURL(), 100));
    }

    public void replaceDestinationConfigs(Hermes hermes, Collection dConfigs) throws JMSException {
        this.loader.replaceDestinationConfigs(hermes, dConfigs);
    }

    public void restoreConfig() throws HermesException {
        this.loader.restore();
    }

    public void saveConfig() throws HermesException {
        if (!this.isRestrictedWithWarning()) {
            this.loader.save();
        }
    }

    public void showInformationDialog(final String message) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.this), message, "Information", 1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void showErrorDialog(final String message) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.this), message, "Error", 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void showErrorDialog2(final String message, final Throwable t) {
        log.error((Object)t.getMessage(), t);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (t instanceof PyException) {
                    PyException pyT = (PyException)t;
                    JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.this), message + ": " + pyT.traceback.dumpStack(), "Error", 0);
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)HermesBrowser.this), message + ": " + t.getMessage(), "Error", 0);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void showErrorDialog(final String message, final Throwable t) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Appendable s;
                String detail = null;
                if (t instanceof PyException) {
                    s = new StringBuffer();
                    PyException pyT = (PyException)t;
                    pyT.traceback.dumpStack((StringBuffer)s);
                    detail = ((StringBuffer)s).toString();
                } else {
                    s = new StringWriter();
                    PrintWriter p = new PrintWriter((Writer)s);
                    t.printStackTrace(p);
                    detail = ((StringWriter)s).toString();
                }
                JideOptionPane optionPane = new JideOptionPane((Object)message, 0, 3, UIManager.getIcon("OptionPane.errorIcon"));
                optionPane.setTitle((Object)message);
                if (detail != null) {
                    optionPane.setDetails((Object)detail);
                }
                JDialog dialog = optionPane.createDialog((Component)((Object)HermesBrowser.this), "Error");
                dialog.setResizable(true);
                dialog.pack();
                dialog.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void showErrorDialog(Throwable t) {
        this.showErrorDialog("Error: ", t);
    }

    public boolean isRestrictedWithWarning() {
        if (this.isRestricted()) {
            this.showErrorDialog("You do not have permissions to perform this action.");
        }
        return this.isRestricted();
    }

    public boolean isMessageStoresDisabled() {
        return System.getProperty("hermes.disableMessageStores") != null;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public CommandBar createDockableBar(String name) {
        return new CommandBar(name);
    }

    public Hermes getHermes() {
        if (this.getDocumentPane().getActiveDocument() instanceof BrowserAction) {
            BrowserAction action = (BrowserAction)this.getDocumentPane().getActiveDocument();
            return action.getHermes();
        }
        return null;
    }

    public static void browseQueue(String hermesId, String queue) throws NamingException, JMSException {
        Hermes hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(hermesId);
        DestinationConfig config = hermes.getDestinationConfig(queue, Domain.QUEUE);
        HermesBrowser.getBrowser().getActionFactory().createQueueBrowseAction(hermes, config);
    }

    public void setFIXPrettyPrinter(FIXPrettyPrinter printer) {
        FIXUtils.setPrettyPrinter(printer);
    }

    public FIXPrettyPrinter getFIXPrettyPrinter() {
        return FIXUtils.getPrettyPrinter() == null ? FIXUtils.getDefaultPrettyPrinter() : FIXUtils.getPrettyPrinter();
    }

    public Collection<Message> getSelectedMessages() {
        if (this.getDocumentPane().getActiveDocument() instanceof BrowserAction) {
            BrowserAction action = (BrowserAction)this.getDocumentPane().getActiveDocument();
            return action.getSelectedMessages();
        }
        return Collections.EMPTY_LIST;
    }

    static {
        USER_PROFILE_NAME = "hermes.layout." + System.getProperty("user.name");
    }
}

