/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.actions;

import com.codestreet.selector.parser.InvalidSelectorException;
import hermes.browser.actions.AbstractFIXBrowserDocumentComponent;
import hermes.browser.actions.FilterableAction;
import hermes.browser.components.NavigableComponent;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageListener;
import hermes.fix.FIXMessageTable;
import hermes.fix.FIXMessageTableModel;
import hermes.fix.SessionKey;
import java.awt.Component;
import java.util.Collection;
import java.util.TimerTask;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FIXMessageBrowserDocumentComponent
extends AbstractFIXBrowserDocumentComponent
implements FIXMessageListener,
FilterableAction,
NavigableComponent {
    private final FIXMessageTableModel tableModel;
    private final FIXMessageTable table;
    private boolean firstMessage = true;

    public FIXMessageBrowserDocumentComponent(SessionKey sessionKey, String title) {
        super(title);
        this.tableModel = new FIXMessageTableModel(sessionKey);
        this.table = new FIXMessageTable(sessionKey, this.tableModel);
        this.init();
    }

    @Override
    public ListSelectionModel getListSelectionModel() {
        return this.table.getSelectionModel();
    }

    @Override
    public boolean isNavigableForward() {
        return this.table.getSelectedRow() < this.table.getRowCount() - 1;
    }

    @Override
    public boolean isNavigableBackward() {
        return this.table.getSelectedRow() > 0 && this.table.getRowCount() > 1;
    }

    @Override
    public void navigateBackward() {
        int currentRow = this.table.getSelectedRow();
        this.table.getSelectionModel().setSelectionInterval(currentRow - 1, currentRow - 1);
    }

    @Override
    public void navigateForward() {
        int currentRow = this.table.getSelectedRow();
        this.table.getSelectionModel().setSelectionInterval(currentRow + 1, currentRow + 1);
    }

    @Override
    public Collection<Object> getSelectedMessages() {
        return this.table.getSelectedMessages();
    }

    public FIXMessageTable getTable() {
        return this.table;
    }

    @Override
    public void setSelector(String selector) throws InvalidSelectorException {
        this.table.setSelector(selector);
    }

    @Override
    protected void init() {
        super.init();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FIXMessageBrowserDocumentComponent.this.doSelectionChanged(FIXMessageBrowserDocumentComponent.this.table, e);
            }
        });
    }

    @Override
    protected Component getHeaderComponent() {
        return this.table;
    }

    @Override
    protected void updateTableRows(final boolean reschedule) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection<FIXMessage> collection = FIXMessageBrowserDocumentComponent.this.getCachedRows();
                synchronized (collection) {
                    FIXMessageBrowserDocumentComponent.this.table.addMessages(FIXMessageBrowserDocumentComponent.this.getCachedRows());
                    if (FIXMessageBrowserDocumentComponent.this.firstMessage) {
                        FIXMessageBrowserDocumentComponent.this.table.getSelectionModel().setSelectionInterval(0, 0);
                        FIXMessageBrowserDocumentComponent.this.firstMessage = false;
                    }
                    FIXMessageBrowserDocumentComponent.this.getCachedRows().clear();
                }
                StringBuffer buffer = new StringBuffer();
                if (!reschedule || FIXMessageBrowserDocumentComponent.this.isTaskStopped()) {
                    buffer.append("Finished. ");
                } else {
                    switch (FIXMessageBrowserDocumentComponent.this.tableModel.getRowCount()) {
                        case 0: {
                            buffer.append("No messages found.");
                            break;
                        }
                        case 1: {
                            buffer.append("1 message found.");
                            break;
                        }
                        default: {
                            buffer.append(FIXMessageBrowserDocumentComponent.this.table.getRowCount()).append(" sessions found.");
                        }
                    }
                }
                if (reschedule) {
                    FIXMessageBrowserDocumentComponent.this.setStatusText(buffer.toString());
                } else {
                    FIXMessageBrowserDocumentComponent.this.setStatusText("Finished. " + buffer.toString());
                }
                if (reschedule) {
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            FIXMessageBrowserDocumentComponent.this.updateTableRows(true);
                        }
                    };
                    AbstractFIXBrowserDocumentComponent.timer.schedule(timerTask, FIXMessageBrowserDocumentComponent.this.getScreenUpdateTimeout());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(FIXMessage message) {
        Collection<FIXMessage> collection = this.getCachedRows();
        synchronized (collection) {
            this.getCachedRows().add(message);
        }
    }
}

