/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesRuntimeException;
import hermes.browser.IconCache;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;

public class BindToolTableModel
extends DefaultTableModel {
    private Vector rows = new Vector();

    public BindToolTableModel(Collection nodes, String bindingRoot) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            this.rows.add(new RowInfo(iter.next(), bindingRoot));
        }
    }

    public void visit(Visitor visitor) {
        for (RowInfo row : this.rows) {
            AbstractTreeNode treeNode;
            if (row.node instanceof HermesTreeNode) {
                treeNode = (HermesTreeNode)row.node;
                visitor.onHermes(((HermesTreeNode)treeNode).getHermes(), row.binding);
                continue;
            }
            if (!(row.node instanceof DestinationConfigTreeNode)) continue;
            treeNode = (DestinationConfigTreeNode)row.node;
            HermesTreeNode hermesNode = (HermesTreeNode)((DestinationConfigTreeNode)treeNode).getParent();
            visitor.onDestination(hermesNode.getHermes(), ((DestinationConfigTreeNode)treeNode).getDestinationName(), ((DestinationConfigTreeNode)treeNode).getDomain(), row.binding);
        }
    }

    @Override
    public int getRowCount() {
        if (this.rows != null) {
            return this.rows.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int y, int x) {
        return x == 2;
    }

    @Override
    public void setValueAt(Object value, int y, int x) {
        RowInfo row = (RowInfo)this.rows.get(y);
        row.binding = value.toString();
    }

    @Override
    public Object getValueAt(int y, int x) {
        RowInfo row = (RowInfo)this.rows.get(y);
        if (row.node instanceof DestinationConfigTreeNode) {
            DestinationConfigTreeNode treeNode = (DestinationConfigTreeNode)row.node;
            switch (x) {
                case 0: {
                    return treeNode.getIcon();
                }
                case 1: {
                    return treeNode.getDestinationName();
                }
                case 2: {
                    return row.binding;
                }
            }
            return null;
        }
        if (row.node instanceof HermesTreeNode) {
            HermesTreeNode treeNode = (HermesTreeNode)row.node;
            switch (x) {
                case 0: {
                    return IconCache.getIcon("jms.connectionFactory");
                }
                case 1: {
                    return treeNode.getHermes().getId();
                }
                case 2: {
                    return row.binding;
                }
            }
            return null;
        }
        throw new HermesRuntimeException("model can only contain DestinationTreeNode or HermesTreeNode");
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return " ";
            }
            case 1: {
                return "ID";
            }
            case 2: {
                return "Binding";
            }
        }
        return "Error";
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return Icon.class;
        }
        return String.class;
    }

    private static class RowInfo {
        Object node;
        String binding;

        RowInfo(Object node, String binding) {
            this.node = node;
            if (binding == null) {
                if (node instanceof DestinationConfigTreeNode) {
                    this.binding = ((DestinationConfigTreeNode)node).getConfig().getShortName();
                } else if (node instanceof HermesTreeNode) {
                    this.binding = ((HermesTreeNode)node).getHermes().getId();
                }
            }
            this.binding = binding;
        }
    }

    public static interface Visitor {
        public void onDestination(Hermes var1, String var2, Domain var3, String var4);

        public void onHermes(Hermes var1, String var2);
    }
}

