/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.BrowseInterruptedException;
import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.TaskSupport;
import hermes.config.DestinationConfig;
import hermes.impl.QueueBrowserWithConsumer;
import java.util.Enumeration;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.log4j.Logger;

public class BrowseDestinationTask
extends TaskSupport
implements Task {
    private static final Logger log = Logger.getLogger(BrowseDestinationTask.class);
    private Hermes hermes;
    private Iterator iter;
    private QueueBrowser browser;
    private String title = "Browse";
    private boolean useMessageConsumer = false;

    public BrowseDestinationTask(Hermes hermes, final DestinationConfig dConfig) {
        super(Domain.getDomain(dConfig.getDomain()).getIcon());
        this.hermes = hermes;
        this.title = "Browsing " + dConfig.getName() + " on " + hermes.getId();
        if (dConfig.isDurable()) {
            this.title = this.title + " (durableName=" + dConfig.getClientID() + ")";
        }
        this.iter = new Iterator(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                return this.first;
            }

            public Object next() {
                this.first = false;
                return dConfig;
            }
        };
    }

    public BrowseDestinationTask(Hermes hermes, Iterator iter) {
        super(IconCache.getIcon("jms.unknown"));
        this.hermes = hermes;
        this.iter = iter;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected QueueBrowser createBrowser(Destination destination, DestinationConfig dConfig) throws JMSException {
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId() && this.hermes.getSessionConfig().isUseConsumerForQueueBrowse()) {
            log.debug((Object)"using a MessageConsumer for the QueueBrowse");
            return new QueueBrowserWithConsumer(this.hermes, (Queue)destination, dConfig.getSelector(), HermesBrowser.getBrowser().getQueueBrowseConsumerTimeout());
        }
        return this.hermes.createBrowser(dConfig);
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.browser != null) {
                this.browser.close();
                this.browser = null;
            }
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        while (this.iter.hasNext()) {
            DestinationConfig dConfig = (DestinationConfig)this.iter.next();
            int nmessages = 0;
            try {
                Destination destination = this.hermes.getDestination(dConfig.getName(), Domain.getDomain(dConfig.getDomain()));
                this.browser = this.createBrowser(destination, dConfig);
                this.notifyStatus("Running...");
                Enumeration messageIter = this.browser.getEnumeration();
                while (messageIter.hasMoreElements() && this.isRunning()) {
                    Message message = (Message)messageIter.nextElement();
                    if (message != null) {
                        this.notifyMessage(message);
                        ++nmessages;
                        continue;
                    }
                    log.error((Object)"Got a null message!");
                    Thread.sleep(500L);
                }
                if (this.isRunning()) continue;
                log.debug((Object)("user requested stop browse of " + dConfig.getName()));
            }
            catch (BrowseInterruptedException ex) {
                log.info((Object)("browse of " + this.getTitle() + " interrupted after " + nmessages));
            }
            catch (InterruptedException ex) {
                log.info((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                log.debug((Object)("browse complete nmessages=" + nmessages));
                this.notifyStatus("Done.");
                if (this.browser != null) {
                    this.browser.close();
                    this.browser = null;
                }
                this.hermes.close();
            }
        }
    }

    public boolean isUseMessageConsumer() {
        return this.useMessageConsumer;
    }

    public void setUseMessageConsumer(boolean useMessageConsumer) {
        this.useMessageConsumer = useMessageConsumer;
    }
}

