/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.browser.HermesBrowser;
import hermes.browser.tasks.Task;
import hermes.browser.tasks.TaskListener;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class HermesBrowserTaskListener
implements TaskListener {
    private static final Logger log = Logger.getLogger(HermesBrowserTaskListener.class);
    private HermesBrowser hermesBrowser;

    public HermesBrowserTaskListener(HermesBrowser hermesBrowser) {
        this.hermesBrowser = hermesBrowser;
    }

    @Override
    public void onStarted(Task task) {
    }

    @Override
    public void onStopped(Task task) {
    }

    @Override
    public void onStatus(Task task, String status) {
        if (task.getTitle() != null) {
            this.hermesBrowser.getDefaultMessageSink().add(task.getTitle() + ": " + status);
        } else {
            this.hermesBrowser.getDefaultMessageSink().add(status);
        }
    }

    @Override
    public void onThrowable(Task task, Throwable t) {
        JMSException e;
        log.error((Object)t.getMessage(), t);
        if (task.getTitle() != null) {
            this.hermesBrowser.getDefaultMessageSink().add(task.getTitle() + ": " + t.getMessage());
        } else {
            this.hermesBrowser.getDefaultMessageSink().add(t.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(t.getClass().getName()).append("\n");
        if (t.getMessage() == null) {
            stringBuffer.append("Provider gave no error message, check the logfile for errors.").append("\n");
        } else {
            stringBuffer.append(t.getMessage()).append("\n");
        }
        Exception linked = null;
        if (t instanceof JMSException && (e = (JMSException)t).getLinkedException() != null) {
            if (e.getLinkedException().getMessage() != null && !e.getLinkedException().getMessage().equals(e.getMessage())) {
                stringBuffer.append(e.getLinkedException().getMessage()).append("\n");
            }
            linked = e.getLinkedException();
        }
        HermesBrowser.getBrowser().showErrorDialog(stringBuffer.toString(), linked == null ? t : linked);
    }
}

