/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext;

import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.config.ProviderExtConfig;
import hermes.ext.DefaultHermesAdminFactory;
import hermes.ext.ExtensionFinder;
import hermes.impl.ClassLoaderManager;
import hermes.impl.LoaderSupport;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ExtensionFinderImpl
implements ExtensionFinder {
    private static final Logger log = Logger.getLogger(ExtensionFinderImpl.class);
    private ClassLoaderManager classLoaderManager;

    public ExtensionFinderImpl(ClassLoaderManager classLoaderManager) {
        this.classLoaderManager = classLoaderManager;
    }

    @Override
    public synchronized HermesAdminFactory createExtension(String classPathId, ProviderExtConfig extConfig, ConnectionFactory cf) throws InstantiationException, ClassNotFoundException, NamingException, JMSException {
        if (extConfig != null && extConfig.getClassName() != null && !extConfig.getClassName().equals("")) {
            log.debug((Object)("creating extension " + extConfig.getClassName() + " for " + cf.getClass().getName()));
            HermesAdminFactory providerExtension = null;
            try {
                ClassLoader classLoader = this.classLoaderManager.getClassLoader(classPathId);
                log.debug((Object)("loading from " + classLoader));
                Thread.currentThread().setContextClassLoader(classLoader);
                providerExtension = (HermesAdminFactory)classLoader.loadClass(extConfig.getClassName()).newInstance();
                LoaderSupport.populateBean(providerExtension, extConfig.getProperties());
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                throw new HermesException(e);
            }
            return providerExtension;
        }
        return new DefaultHermesAdminFactory();
    }
}

