/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.wme;

import COM.activesw.api.client.BrokerAdminClient;
import COM.activesw.api.client.BrokerClientInfo;
import COM.activesw.api.client.BrokerConnectionDescriptor;
import com.wm.broker.jms.AdminFactory;
import com.wm.broker.jms.QueueAdmin;
import com.wm.broker.jms.QueueConnectionFactoryAdmin;
import hermes.impl.jms.ContextImpl;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.log4j.Logger;

public class WMEInitialContextFactory
implements InitialContextFactory {
    private static final Logger log = Logger.getLogger(WMEInitialContextFactory.class);
    private static final String URN = "wme";
    private static final Set ignoreClientGroups = new HashSet();

    public Context getInitialContext(Hashtable environment) throws NamingException {
        if (!environment.containsKey("java.naming.provider.url")) {
            throw new NamingException("java.naming.provider.url is not available");
        }
        String providerURL = (String)environment.get("java.naming.provider.url");
        if (!providerURL.startsWith(URN)) {
            throw new NamingException("providerURL URN is not wme");
        }
        String hostName = null;
        String brokerName = null;
        String port = null;
        providerURL = providerURL.substring(providerURL.indexOf(47));
        StringTokenizer tokens = new StringTokenizer(providerURL, ":/@");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (element == null || element.equals("")) continue;
            if (brokerName == null) {
                brokerName = element;
                continue;
            }
            if (hostName == null) {
                hostName = element;
                continue;
            }
            if (port != null) continue;
            port = element;
        }
        if (hostName == null || brokerName == null || port == null) {
            throw new NamingException("providerURL (" + providerURL + ") is malformed, format is wme://brokerName@hostname:port");
        }
        try {
            BrokerConnectionDescriptor bcd = new BrokerConnectionDescriptor();
            bcd.setConnectionShare(true);
            try {
                bcd.setConnectionShareLimit(100);
            }
            catch (NoSuchMethodError ex) {
                // empty catch block
            }
            bcd.setSharedEventOrdering("None");
            BrokerAdminClient adminClient = BrokerAdminClient.newOrReconnectAdmin((String)(hostName + ":" + port), (String)brokerName, (String)("admin" + System.currentTimeMillis()), (String)"admin", (String)WMEInitialContextFactory.class.getName(), (BrokerConnectionDescriptor)bcd);
            ContextImpl ctx = new ContextImpl(environment);
            String[] clientIds = adminClient.getClientIds();
            for (int i = 0; i < clientIds.length; ++i) {
                BrokerClientInfo info = adminClient.getClientInfoById(clientIds[i]);
                if (ignoreClientGroups.contains(info.client_group)) continue;
                QueueAdmin queue = AdminFactory.newQueue();
                queue.setName(info.client_id);
                queue.setClientGroup(info.client_group);
                ctx.bind(info.client_id, (Object)queue);
            }
            String[] clientGroups = adminClient.getClientGroupNames();
            for (int i = 0; i < clientGroups.length; ++i) {
                String clientGroup = clientGroups[i];
                QueueConnectionFactoryAdmin cfAdmin = AdminFactory.newQueueConnectionFactory();
                cfAdmin.setBrokerHost(hostName + ":" + port);
                cfAdmin.setBrokerName(brokerName);
                cfAdmin.setConnectionClientGroup(clientGroup);
                cfAdmin.setConnectionClientId("hermes-" + System.currentTimeMillis());
                ctx.bind(clientGroup, (Object)cfAdmin);
            }
            adminClient.destroy();
            return ctx;
        }
        catch (Exception e) {
            NamingException ex = new NamingException(e.getMessage());
            ex.setRootCause(e);
            throw ex;
        }
    }

    static {
        ignoreClientGroups.add("admin");
    }
}

