/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import com.codestreet.selector.parser.InvalidSelectorException;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.swing.JidePopupMenu;
import hermes.browser.IconCache;
import hermes.browser.components.PopupMenuFactory;
import hermes.browser.transferable.MessagesTransferHandler;
import hermes.fix.FIXIdentifierExtension;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageTableModel;
import hermes.fix.SessionKey;
import hermes.fix.SessionRole;
import hermes.swing.Colours;
import hermes.swing.SQL92FilterableTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FIXMessageTable
extends SortableTable {
    private static final Logger log = Logger.getLogger(FIXMessageTable.class);
    private SQL92FilterableTableModel selectorModel;
    private FIXMessageTableModel model;
    private JidePopupMenu popup;
    private SessionKey sessionKey;
    private boolean autoScroll = false;

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public FIXMessageTable(SessionKey sessionKey, final FIXMessageTableModel model) {
        this.model = model;
        this.selectorModel = new SQL92FilterableTableModel(model, new FIXIdentifierExtension());
        this.selectorModel.setRowValueProvider(model);
        this.sessionKey = sessionKey;
        this.setSortable(true);
        this.setModel((TableModel)((Object)this.selectorModel));
        this.setDragEnabled(true);
        this.setTransferHandler(new MessagesTransferHandler(this));
        this.getSelectionModel().setSelectionMode(2);
        this.getColumn(" ").setMaxWidth(IconCache.getIcon("hermes.back").getIconWidth() + 4);
        this.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                FIXMessage message = model.getMessageAt(FIXMessageTable.this.selectorModel.getActualRowAt(row));
                if (model.getRole(message) == SessionRole.ACCEPTOR) {
                    this.setIcon(IconCache.getIcon("hermes.back"));
                } else {
                    this.setIcon(IconCache.getIcon("hermes.forward"));
                }
                return this;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    FIXMessageTable.this.getTransferHandler().exportAsDrag((JComponent)((Object)FIXMessageTable.this), e, 1);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    FIXMessageTable.this.doPopup(e);
                }
            }
        });
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (FIXMessageTable.this.isAutoScroll() && e.getType() == 1) {
                    FIXMessageTable.this.getSelectionModel().setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
                    FIXMessageTable.this.scrollRectToVisible(FIXMessageTable.this.getCellRect(model.getRowCount() - 1, 0, true));
                }
            }
        });
    }

    public SessionKey getSessionKey() {
        return this.sessionKey;
    }

    private void doPopup(MouseEvent e) {
        if (this.popup == null) {
            this.popup = PopupMenuFactory.createFIXMessageTablePopup(this);
        }
        this.popup.show((Component)((Object)this), e.getX(), e.getY());
    }

    public Collection<Object> getSelectedMessages() {
        ArrayList<Object> rval = new ArrayList<Object>();
        int[] selected = this.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            rval.add(this.getMessageAt(selected[i]));
        }
        return rval;
    }

    public FIXMessage getMessageAt(int row) {
        return this.model.getMessageAt(this.selectorModel.getActualRowAt(this.getActualRowAt(row)));
    }

    public void addMessages(Collection<FIXMessage> messages) {
        this.model.addMessages(messages);
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        this.selectorModel.setSelector(selector);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        FIXMessage message;
        Component c = super.prepareRenderer(renderer, row, column);
        if (row < this.getRowCount() && (message = this.getMessageAt(row)) != null && !this.isCellSelected(row, column)) {
            if (this.model.getRole(message) == SessionRole.ACCEPTOR) {
                c.setBackground(Colours.LIGHT_SEA_GREEN);
            } else {
                c.setBackground(Colours.LIGHT_SKY_BLUE);
            }
        }
        return c;
    }

    public void scrollRectToVisible(Rectangle aRect) {
        Container parent;
        int dx = this.getX();
        int dy = this.getY();
        for (parent = this.getParent(); !(parent == null || parent instanceof JViewport && ((JViewport)parent).getClientProperty("HierarchicalTable.mainViewport") != null); parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
        }
        if (parent != null && !(parent instanceof CellRendererPane)) {
            aRect.x += dx;
            aRect.y += dy;
            ((JComponent)parent).scrollRectToVisible(aRect);
            aRect.x -= dx;
            aRect.y -= dy;
        }
    }
}

