/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Hermes;
import hermes.HermesAuditListener;
import hermes.HermesAuditLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Category;

public class DefaultHermesLogImpl
implements HermesAuditLog {
    private static final Category cat = Category.getInstance(DefaultHermesLogImpl.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private String baseDirName = ".";
    private Hermes hermes;
    private boolean active = false;
    private HermesAuditListener auditListener;
    private Map readMsgsInTx = new HashMap();
    private Map writeMsgsInTx = new HashMap();
    private Map filesInTx = new HashMap();

    public DefaultHermesLogImpl(Hermes hermes, String baseDirName, boolean create, boolean active) throws IOException {
        this.active = active;
        this.hermes = hermes;
        File baseDir = new File(baseDirName);
        if (baseDir.exists()) {
            if (!baseDir.isDirectory()) {
                throw new IOException("Audit log dir " + baseDirName + " already exists as a file, reverting to '.'");
            }
        } else if (create) {
            baseDir.mkdir();
        } else {
            throw new IOException("Audit log dir " + baseDirName + " does not exist, reverting to '.'");
        }
        this.baseDirName = baseDirName;
    }

    @Override
    public void onRead(Destination from, Collection messages) {
        if (this.active) {
            try {
                File file = this.getAuditFile("read@", from);
                Collection c = (Collection)this.readMsgsInTx.get(file);
                c.addAll(messages);
            }
            catch (JMSException e) {
                cat.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                cat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void onWrite(Destination from, Collection messages) {
        if (this.active) {
            try {
                File file = this.getAuditFile("write@", from);
                Collection c = (Collection)this.writeMsgsInTx.get(file);
                c.addAll(messages);
            }
            catch (JMSException e) {
                cat.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                cat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public File getAuditFile(String prefix, Destination dest) throws IOException, JMSException {
        File auditFile;
        DateFormat dateFormat = DateFormat.getDateInstance();
        Date now = new Date();
        String userDirName = System.getProperty("user.name");
        String dateDirName = dateFormat.format(new Date());
        String hermesDirName = this.hermes.getId();
        String destDirName = this.hermes.getDestinationName(dest);
        String fileName = prefix + now.getHours() + "_" + now.getMinutes() + "_" + now.getSeconds() + ".xml";
        destDirName = destDirName.replaceAll("queue:///", "");
        String auditFileName = this.baseDirName + SEPARATOR + userDirName + SEPARATOR + dateDirName + SEPARATOR + hermesDirName + SEPARATOR + destDirName + SEPARATOR + fileName;
        if (this.filesInTx.containsKey(auditFileName)) {
            auditFile = (File)this.filesInTx.get(auditFileName);
        } else {
            File destDir;
            File hermesDir;
            File dateDir;
            File userDir = new File(this.baseDirName + SEPARATOR + userDirName);
            if (!userDir.exists()) {
                userDir.mkdir();
            }
            if (!(dateDir = new File(userDir.getPath() + SEPARATOR + dateDirName)).exists()) {
                dateDir.mkdir();
            }
            if (!(hermesDir = new File(dateDir.getPath() + SEPARATOR + hermesDirName)).exists()) {
                hermesDir.mkdir();
            }
            if (!(destDir = new File(hermesDir.getPath() + SEPARATOR + destDirName)).exists()) {
                destDir.mkdir();
            }
            auditFile = new File(destDir.getPath() + SEPARATOR + fileName);
            this.filesInTx.put(auditFileName, auditFile);
            this.readMsgsInTx.put(auditFile, new ArrayList());
            this.writeMsgsInTx.put(auditFile, new ArrayList());
            if (!auditFile.exists()) {
                auditFile.createNewFile();
            }
        }
        return auditFile;
    }

    @Override
    public void onRead(Destination from, Message message) {
        if (this.active) {
            ArrayList<Message> list = new ArrayList<Message>();
            list.add(message);
            this.onRead(from, list);
        }
    }

    @Override
    public void onWrite(Destination to, Message message) {
        if (this.active) {
            ArrayList<Message> list = new ArrayList<Message>();
            list.add(message);
            this.onWrite(to, list);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        if (this.active) {
            Collection messages;
            FileOutputStream ostream;
            Map.Entry entry;
            Iterator iter = this.readMsgsInTx.entrySet().iterator();
            while (iter.hasNext()) {
                try {
                    entry = iter.next();
                    ostream = new FileOutputStream((File)entry.getKey());
                    messages = (Collection)entry.getValue();
                    this.hermes.toXML(messages, (OutputStream)ostream);
                    ostream.flush();
                    ostream.close();
                }
                catch (Exception e) {
                    cat.error((Object)("unable to log messages: " + e.getMessage()), (Throwable)e);
                    Hermes.ui.getDefaultMessageSink().add("Unable to log messages for audit: " + e.getMessage());
                }
            }
            iter = this.writeMsgsInTx.entrySet().iterator();
            while (iter.hasNext()) {
                try {
                    entry = iter.next();
                    ostream = new FileOutputStream((File)entry.getKey());
                    messages = (Collection)entry.getValue();
                    this.hermes.toXML(messages, (OutputStream)ostream);
                    ostream.flush();
                    ostream.close();
                }
                catch (Exception e) {
                    cat.error((Object)("unable to log messages: " + e.getMessage()), (Throwable)e);
                    Hermes.ui.getDefaultMessageSink().add("Unable to log messages for audit: " + e.getMessage());
                }
            }
            this.readMsgsInTx.clear();
            this.writeMsgsInTx.clear();
            this.filesInTx.clear();
        }
    }

    @Override
    public void rollback() {
        this.readMsgsInTx.clear();
        this.writeMsgsInTx.clear();
        this.filesInTx.clear();
    }

    @Override
    public void setListener(HermesAuditListener auditListener) {
        this.auditListener = auditListener;
    }
}

