/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.HermesRepository;
import hermes.HermesRepositoryListener;
import hermes.HermesRepositoryManager;
import hermes.impl.FileRepository;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Category;

public class FileRepositoryManager
implements HermesRepositoryManager {
    private static final Category cat = Category.getInstance(FileRepositoryManager.class);
    private static final Timer timer = new Timer();
    private Set listeners = new HashSet();
    private Set repositories = new HashSet();
    private Map repositoriesByName = new HashMap();
    private File root;
    private TimerTask timerTask;
    private boolean scanning = false;

    public FileRepositoryManager(File root, long period) {
        this.root = root;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                FileRepositoryManager.this.scanForNewFiles();
            }
        };
        timer.schedule(this.timerTask, 0L, period);
    }

    @Override
    public void addRepositoryListener(HermesRepositoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRepositoryListener(HermesRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Iterator iterator() {
        return this.repositories.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForNewFiles() {
        if (!this.scanning) {
            FileRepositoryManager fileRepositoryManager = this;
            synchronized (fileRepositoryManager) {
                this.scanning = true;
                try {
                    HermesRepository repository;
                    File[] files = this.root.listFiles();
                    HashSet<String> fileNames = new HashSet<String>();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            fileNames.add(file.getName());
                            if (this.repositoriesByName.containsKey(file.getName())) continue;
                            repository = new FileRepository(file);
                            this.repositories.add(repository);
                            this.repositoriesByName.put(file.getName(), repository);
                            for (HermesRepositoryListener l : this.listeners) {
                                cat.debug((Object)("new repository:" + ((FileRepository)repository).getId()));
                                l.onRepositoryAdded(repository);
                            }
                        }
                    }
                    Iterator iter = this.repositoriesByName.keySet().iterator();
                    while (iter.hasNext()) {
                        String fileName = (String)iter.next();
                        if (fileNames.contains(fileName)) continue;
                        repository = (HermesRepository)this.repositoriesByName.get(fileName);
                        iter.remove();
                        this.repositories.remove(repository);
                        for (HermesRepositoryListener l : this.listeners) {
                            cat.debug((Object)("removed repository: " + repository.getId()));
                            l.onRepositoryRemoved(repository);
                        }
                    }
                }
                catch (Throwable ex) {
                    cat.error((Object)("during directory scanning: " + ex.getMessage()), ex);
                }
                this.scanning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirectory(String newDir) {
        FileRepositoryManager fileRepositoryManager = this;
        synchronized (fileRepositoryManager) {
            this.root = new File(newDir);
            if (!this.root.exists()) {
                this.root.mkdir();
            }
        }
    }

    @Override
    public String getDirectory() {
        return this.root.getPath();
    }
}

