/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.messages;

import hermes.HermesException;
import hermes.providers.messages.MessageSessionReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class MessageImpl
implements Message {
    private String correlationId;
    private int deliveryMode;
    private Destination destination;
    private long expiration;
    private int priority;
    private boolean redilivered;
    private Destination replyTo;
    private long timestamp;
    private String type;
    private String messageId;
    private MessageSessionReference session;
    private Map header = new HashMap();

    public void acknowledge() throws JMSException {
        this.session.acknowledge(this);
    }

    public void clearBody() throws JMSException {
    }

    public void clearProperties() throws JMSException {
        this.header.clear();
    }

    public boolean getBooleanProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Boolean) {
            return (Boolean)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public byte getByteProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Byte) {
            return (Byte)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public double getDoubleProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Double) {
            return (Double)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public float getFloatProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof String) {
            return ((Float)this.header.get(arg0)).floatValue();
        }
        throw new HermesException("No such property " + arg0);
    }

    public int getIntProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Integer) {
            return (Integer)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationId;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.correlationId.getBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public String getJMSMessageID() throws JMSException {
        return this.messageId;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redilivered;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.replyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public String getJMSType() throws JMSException {
        return this.type;
    }

    public long getLongProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Long) {
            return (Long)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public Object getObjectProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0)) {
            return this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return new IteratorEnumeration(this.header.keySet().iterator());
    }

    public short getShortProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof Short) {
            return (Short)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public String getStringProperty(String arg0) throws JMSException {
        if (this.header.containsKey(arg0) && this.header.get(arg0) instanceof String) {
            return (String)this.header.get(arg0);
        }
        throw new HermesException("No such property " + arg0);
    }

    public boolean propertyExists(String arg0) throws JMSException {
        return this.header.containsKey(arg0);
    }

    public void setBooleanProperty(String arg0, boolean arg1) throws JMSException {
        this.header.put(arg0, new Boolean(arg1));
    }

    public void setByteProperty(String arg0, byte arg1) throws JMSException {
        this.header.put(arg0, new Byte(arg1));
    }

    public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        this.header.put(arg0, new Double(arg1));
    }

    public void setFloatProperty(String arg0, float arg1) throws JMSException {
        this.header.put(arg0, new Float(arg1));
    }

    public void setIntProperty(String arg0, int arg1) throws JMSException {
        this.header.put(arg0, new Integer(arg1));
    }

    public void setJMSCorrelationID(String arg0) throws JMSException {
        this.correlationId = arg0;
    }

    public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
    }

    public void setJMSDeliveryMode(int arg0) throws JMSException {
        this.deliveryMode = arg0;
    }

    public void setJMSDestination(Destination arg0) throws JMSException {
        if (arg0 == null) {
            throw new HermesException("destination is null");
        }
        this.destination = arg0;
    }

    public void setJMSExpiration(long arg0) throws JMSException {
        this.expiration = arg0;
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this.messageId = messageId;
    }

    public void setJMSPriority(int arg0) throws JMSException {
        this.priority = arg0;
    }

    public void setJMSRedelivered(boolean arg0) throws JMSException {
        this.redilivered = arg0;
    }

    public void setJMSReplyTo(Destination arg0) throws JMSException {
        this.replyTo = arg0;
    }

    public void setJMSTimestamp(long arg0) throws JMSException {
        this.timestamp = arg0;
    }

    public void setJMSType(String arg0) throws JMSException {
        this.type = arg0;
    }

    public void setLongProperty(String arg0, long arg1) throws JMSException {
        this.header.put(arg0, new Long(arg1));
    }

    public void setObjectProperty(String arg0, Object arg1) throws JMSException {
        this.header.put(arg0, arg1);
    }

    public void setShortProperty(String arg0, short arg1) throws JMSException {
        this.header.put(arg0, new Short(arg1));
    }

    public void setStringProperty(String arg0, String arg1) throws JMSException {
        this.header.put(arg0, arg1);
    }

    public MessageSessionReference getSession() {
        return this.session;
    }

    public void setSession(MessageSessionReference session) {
        this.session = session;
    }
}

