/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import hermes.browser.HermesBrowser;
import hermes.browser.actions.BrowseContextAction;
import hermes.browser.actions.BrowserAction;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public abstract class BrowseActionListenerAdapter
extends AbstractAction
implements DocumentComponentListener,
ListSelectionListener,
TableModelListener {
    private static final Logger log = Logger.getLogger(BrowseActionListenerAdapter.class);
    private boolean tableListener = false;
    private boolean checkSelection = true;
    private boolean checkRunning = false;
    private Set<Class> documentTypes = new HashSet<Class>();

    public BrowseActionListenerAdapter() {
        HermesBrowser.getBrowser().addDocumentComponentListener(this);
        HermesBrowser.getBrowser().addMessageSelectionListener(this);
    }

    protected void addDocumentType(Class clazz) {
        this.documentTypes.add(clazz);
    }

    public BrowseActionListenerAdapter(boolean tableListener, boolean checkSelection, boolean checkRunning) {
        this();
        this.tableListener = tableListener;
        this.checkSelection = checkSelection;
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void checkEnabled(Object object) {
        if (object instanceof BrowserAction) {
            BrowserAction browseAction = (BrowserAction)object;
            if (this.checkSelection) {
                this.setEnabled(browseAction.hasSelection());
            } else {
                this.setEnabled(true);
            }
            if (this.checkRunning) {
                this.setEnabled(!browseAction.isRunning());
            }
        } else if (object instanceof BrowseContextAction) {
            this.setEnabled(true);
        } else {
            for (Class clazz : this.documentTypes) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                this.setEnabled(true);
            }
        }
    }

    @Override
    public final void tableChanged(TableModelEvent e) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() != null) {
            this.checkEnabled(HermesBrowser.getBrowser().getDocumentPane().getActiveDocument());
        }
    }

    protected void attachListener(Object source) {
        if (source instanceof BrowserAction) {
            BrowserAction action = (BrowserAction)source;
            action.getMessageHeaderTable().getModel().addTableModelListener(this);
        }
    }

    protected void detachListener(Object source) {
        if (source instanceof BrowserAction) {
            BrowserAction action = (BrowserAction)source;
            action.getMessageHeaderTable().getModel().removeTableModelListener(this);
        }
    }

    public void documentComponentMoved(DocumentComponentEvent arg0) {
    }

    public void documentComponentMoving(DocumentComponentEvent arg0) {
    }

    public void documentComponentOpened(DocumentComponentEvent event) {
        this.checkEnabled(event.getSource());
        this.attachListener(event.getSource());
    }

    public void documentComponentClosing(DocumentComponentEvent event) {
        this.setEnabled(false);
        this.detachListener(event.getSource());
    }

    public void documentComponentClosed(DocumentComponentEvent event) {
        this.setEnabled(false);
        this.detachListener(event.getSource());
    }

    public void documentComponentActivated(DocumentComponentEvent event) {
        this.checkEnabled(event.getSource());
        this.attachListener(event.getSource());
    }

    public void documentComponentDeactivated(DocumentComponentEvent event) {
        this.checkEnabled(event.getSource());
        this.detachListener(event.getSource());
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() != null) {
            this.checkEnabled(HermesBrowser.getBrowser().getDocumentPane().getActiveDocument());
        } else {
            this.setEnabled(false);
        }
    }
}

