/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.IconCache;
import hermes.browser.components.BrowserTree;
import hermes.browser.model.TreeUtils;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.swing.actions.ActionSupport;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CascadeBrowserTreeAction
extends ActionSupport {
    private BrowserTree browserTree;

    public CascadeBrowserTreeAction(BrowserTree browserTree) {
        this.browserTree = browserTree;
        this.putValue("Name", "Cascade/Collapse");
        this.putValue("ShortDescription", "Cascade or collapse the session tree.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.collapse.cf"));
        this.setEnabled(false);
        browserTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CascadeBrowserTreeAction.this.setEnabled(e.getPath() != null && TreeUtils.pathContains(e.getPaths(), HermesTreeNode.class));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath[] paths;
        for (TreePath path : paths = this.browserTree.getSelectionPaths()) {
            for (int j = 0; j < path.getPathCount(); ++j) {
                HermesTreeNode node;
                if (!(path.getPath()[j] instanceof HermesTreeNode)) continue;
                node.setCascadeNamespace(!(node = (HermesTreeNode)path.getPath()[j]).isCascadeNamespace());
                TreePath cascadeFrom = path;
                while (!(cascadeFrom.getLastPathComponent() instanceof HermesTreeNode)) {
                    cascadeFrom = path.getParentPath();
                }
                TreeUtils.expandFully(this.browserTree, cascadeFrom);
            }
        }
    }
}

