/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowseContextAction;
import hermes.browser.model.tree.ContextTreeNode;
import hermes.swing.actions.JNDIAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.naming.Context;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class CreateNewJNDIContextAction
extends JNDIAction {
    public CreateNewJNDIContextAction() {
        this.putValue("Name", "Create new context...");
        this.putValue("ShortDescription", "Create a new context at this point in the tree.");
        this.putValue("SmallIcon", IconCache.getIcon("jndi.context.new"));
        this.setEnabled(false);
    }

    @Override
    protected boolean checkEnabled(TreePath path) {
        return path != null && path.getLastPathComponent() instanceof ContextTreeNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            BrowseContextAction browseContext = (BrowseContextAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            ContextTreeNode node = (ContextTreeNode)browseContext.getContextTree().getSelectionPath().getLastPathComponent();
            String binding = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Enter Binding", "");
            if (binding != null && !binding.equals("")) {
                Context context = node.getContextFactory().createContext();
                context.createSubcontext(binding);
                context.close();
                Hermes.ui.getDefaultMessageSink().add("Subcontext " + binding + " created.");
            } else {
                HermesBrowser.getBrowser().showErrorDialog("Invalid binding name.");
            }
        }
        catch (Throwable ex) {
            HermesBrowser.getBrowser().showErrorDialog("Cannot create context:", ex);
        }
    }
}

