/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.AbstractBrowser;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFunction;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.dom.DOMFactory;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.print.PrintEvent;
import com.teamdev.jxbrowser.print.PrintListener;
import com.teamdev.jxbrowser.safari.BrowserFunctionProxy;
import com.teamdev.jxbrowser.safari.SafariConfigurable;
import com.teamdev.jxbrowser.safari.SafariEvents;
import com.teamdev.jxbrowser.safari.SafariNewWindowManager;
import com.teamdev.jxbrowser.safari.SafariPromptService;
import com.teamdev.jxbrowser.safari.dom.SafariDOMFactory;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.webkit.Safari;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.List;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SafariBrowser
extends AbstractBrowser<Safari> {
    private Safari engine;
    private SafariEvents events;
    private SafariConfigurable configurable;
    private DOMFactory domFactory;
    private HttpSecurityHandler handler;

    SafariBrowser() {
        this(new Safari());
    }

    SafariBrowser(Safari safari) {
        this.engine = safari;
        this.events = new SafariEvents(this);
        this.domFactory = new SafariDOMFactory(safari);
        this.configurable = new SafariConfigurable(this);
        SafariNewWindowManager.register(this);
        new SafariPromptService(this);
    }

    public Component getComponent() {
        return this.engine.getComponent();
    }

    public String getContent() {
        return this.engine.getHTML();
    }

    public Document getDocument() {
        return this.domFactory.createDocument(this.engine.getDocument());
    }

    public BrowserType getType() {
        return BrowserType.Safari;
    }

    public void setContent(String string) {
        this.events.setNavigationFinished(false);
        this.setContent(string, null);
    }

    public void setContent(String string, String string2) {
        this.engine.setHTML(string, string2);
    }

    public Image toImage(boolean bl) {
        return this.engine.toImage();
    }

    public Image toImage(Dimension dimension) {
        return this.engine.toImage(dimension);
    }

    public void goBack() {
        this.engine.goBack();
    }

    public void goForward() {
        this.engine.goForward();
    }

    public boolean isNavigationFinished() {
        return this.events.isNavigationFinished();
    }

    public void navigate(String string) {
        this.engine.navigate(string);
    }

    public void navigate(String string, String string2) {
        this.navigate(string, string2, 0);
    }

    public void navigate(String string, String string2, int n) {
        if (string == null) {
            throw new NullPointerException("The location parameter cannot be null.");
        }
        this.engine.navigate(string, string2, n);
    }

    public void refresh() {
        this.engine.reload();
    }

    public void stop() {
        this.engine.stop();
    }

    public boolean canGoBack() {
        return this.engine.canGoBack();
    }

    public boolean canGoForward() {
        return this.engine.canGoForward();
    }

    public List<String> getAllHistory() {
        throw new UnsupportedOperationException();
    }

    public int getCurrentIndex() {
        throw new UnsupportedOperationException();
    }

    public String getCurrentLocation() {
        return this.engine.getLocationURL();
    }

    public HttpSecurityHandler getHttpSecurityHandler() {
        return this.handler;
    }

    public void setHttpSecurityHandler(HttpSecurityHandler httpSecurityHandler) {
        this.handler = httpSecurityHandler;
    }

    public String executeScript(String string) {
        return this.engine.executeScript(string);
    }

    public ContextMenuHandler getContextMenuHandler() {
        throw new UnsupportedOperationException();
    }

    public String getStatusMessage() {
        return this.events.getStatusMessage();
    }

    public String getTitle() {
        return this.events.getTitle();
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        super.dispose();
        if (!this.isDisposed()) {
            this.engine.dispose();
            this.notifyListeners(new DisposeEvent((Browser)this));
        }
    }

    public boolean isDisposed() {
        return this.engine.isDisposed();
    }

    public Configurable getConfigurable() {
        return this.configurable;
    }

    public void setUserAgent(String string) {
        this.engine.setUserAgent(string);
    }

    public Safari getPeer() {
        return this.engine;
    }

    public boolean isReady() {
        return this.engine.isReady();
    }

    public void registerFunction(String string, BrowserFunction browserFunction) {
        this.engine.registerFunction(string, new BrowserFunctionProxy(browserFunction));
    }

    public void print() {
        this.engine.print();
    }

    public void print(PrintListener printListener) {
        printListener.started(new PrintEvent((Browser)this));
        boolean bl = this.engine.print();
        if (bl) {
            printListener.finished(new PrintEvent((Browser)this));
        } else {
            printListener.canceled(new PrintEvent((Browser)this));
        }
    }
}

