/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.safari;

import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import com.teamdev.jxbrowser.webkit.webkit.WebPreferences;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SafariConfigurable
implements Configurable {
    private SafariBrowser browser;
    private WebPreferences preferences;
    private final Map<Feature, FeatureStateChanger> features;

    SafariConfigurable(SafariBrowser safariBrowser) {
        this.browser = safariBrowser;
        this.preferences = safariBrowser.getPeer().getPreferences();
        this.features = new HashMap<Feature, FeatureStateChanger>();
        this.features.put(Feature.DOWNLOAD_IMAGES, new ImagesStateChanger());
        this.features.put(Feature.JAVASCRIPT, new JavascriptStateChanger());
        this.features.put(Feature.PLUGINS, new PluginsStateChanger());
        new JavaPluginStateChanger().change(false);
    }

    public void disableFeature(Feature feature) {
        this.update(feature, false);
    }

    public void enableFeature(Feature feature) {
        this.update(feature, true);
    }

    public Map<Feature, Boolean> getFeatures() {
        HashMap<Feature, Boolean> hashMap = new HashMap<Feature, Boolean>();
        hashMap.put(Feature.DOWNLOAD_IMAGES, this.preferences.canLoadsImagesAutomatically());
        hashMap.put(Feature.JAVASCRIPT, this.preferences.isJavaScriptEnabled());
        hashMap.put(Feature.PLUGINS, this.preferences.arePlugInsEnabled() && this.preferences.isJavaEnabled());
        return hashMap;
    }

    public void setFeatures(Map<Feature, Boolean> map) {
        for (Feature feature : map.keySet()) {
            this.update(feature, map.get(feature));
        }
    }

    public Font getDefaultFont() {
        String string = this.preferences.standardFontFamily();
        int n = this.preferences.defaultFontSize();
        return new Font(string, 0, n);
    }

    public void setDefaultFont(Font font) {
        this.preferences.setStandardFontFamily(font.getName());
        this.preferences.setDefaultFontSize(font.getSize());
    }

    public int getZoomValue() {
        throw new UnsupportedOperationException();
    }

    public void setZoomValue(int n) {
        if (n < 10 || n > 1000) {
            throw new IllegalArgumentException("Zoom value must be between 10 and 1000.");
        }
        throw new UnsupportedOperationException();
    }

    private void update(Feature feature, boolean bl) {
        if (this.features.containsKey(feature)) {
            this.features.get(feature).change(bl);
        }
    }

    private class JavaPluginStateChanger
    implements FeatureStateChanger {
        private JavaPluginStateChanger() {
        }

        public void change(boolean bl) {
            SafariConfigurable.this.preferences.setJavaEnabled(bl);
            SafariConfigurable.this.browser.getPeer().setPreferences(SafariConfigurable.this.preferences);
        }
    }

    private class PluginsStateChanger
    implements FeatureStateChanger {
        private PluginsStateChanger() {
        }

        public void change(boolean bl) {
            SafariConfigurable.this.preferences.setPlugInsEnabled(bl);
            SafariConfigurable.this.preferences.setJavaEnabled(false);
            SafariConfigurable.this.browser.getPeer().setPreferences(SafariConfigurable.this.preferences);
        }
    }

    private class JavascriptStateChanger
    implements FeatureStateChanger {
        private JavascriptStateChanger() {
        }

        public void change(boolean bl) {
            SafariConfigurable.this.preferences.setJavaScriptEnabled(bl);
            SafariConfigurable.this.browser.getPeer().setPreferences(SafariConfigurable.this.preferences);
        }
    }

    private class ImagesStateChanger
    implements FeatureStateChanger {
        private ImagesStateChanger() {
        }

        public void change(boolean bl) {
            SafariConfigurable.this.preferences.setLoadsImagesAutomatically(bl);
            SafariConfigurable.this.browser.getPeer().setPreferences(SafariConfigurable.this.preferences);
        }
    }

    private static interface FeatureStateChanger {
        public void change(boolean var1);
    }
}

