/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit.events;

import com.teamdev.jxbrowser.webkit.DialogAction;
import com.teamdev.jxbrowser.webkit.DialogCreator;
import com.teamdev.jxbrowser.webkit.Safari;
import com.teamdev.jxbrowser.webkit.SafariEngine;
import com.teamdev.jxbrowser.webkit.WebBrowserDialog;
import com.teamdev.jxbrowser.webkit.WebBrowserWindow;
import com.teamdev.jxbrowser.webkit.WindowCreator;
import com.teamdev.jxbrowser.webkit.event.BrowserEvent;
import com.teamdev.jxbrowser.webkit.event.BrowserListener;
import com.teamdev.jxbrowser.webkit.event.StatusCode;
import com.teamdev.jxbrowser.webkit.events.DOMEventHandler;
import com.teamdev.jxbrowser.webkit.events.DialogResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class Events {
    private SafariEngine engine;
    private DialogCreator dialogCreator;
    private WindowCreator windowCreator;
    private DialogResult lastDialogResult;
    private DOMEventHandler domEventHandler;
    private Set<BrowserListener> browserListeners = Collections.synchronizedSet(new HashSet());
    private boolean ready;

    protected Events() {
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public void setEngine(SafariEngine safariEngine) {
        this.engine = safariEngine;
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.browserListeners.add(browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.browserListeners.remove(browserListener);
    }

    public BrowserListener[] getBrowserListeners() {
        return this.browserListeners.toArray(new BrowserListener[this.browserListeners.size()]);
    }

    public void setDialogCreator(DialogCreator dialogCreator) {
        this.dialogCreator = dialogCreator;
    }

    public void setWindowCreator(WindowCreator windowCreator) {
        this.windowCreator = windowCreator;
    }

    public void setDomEventHandler(DOMEventHandler dOMEventHandler) {
        this.domEventHandler = dOMEventHandler;
    }

    public DOMEventHandler getDomEventHandler() {
        return this.domEventHandler;
    }

    protected boolean canShowContextMenu() {
        return this.engine == null || this.engine.getProperties().isAllowContextMenu();
    }

    protected DialogResult getLastDialogResult() {
        return this.lastDialogResult;
    }

    protected void requestFocusInWindow() {
        this.engine.lock();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Events.this.engine.getComponent().requestFocus();
                Events.this.engine.unlock();
            }
        });
    }

    protected void showWebView() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WebBrowserWindow webBrowserWindow = Events.this.engine.getWebBrowserWindow();
                if (webBrowserWindow != null) {
                    webBrowserWindow.setVisible(true);
                }
            }
        });
    }

    protected void disposeWebView() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WebBrowserWindow webBrowserWindow = Events.this.engine.getWebBrowserWindow();
                if (webBrowserWindow != null) {
                    webBrowserWindow.setVisible(false);
                    webBrowserWindow.disposeWindow();
                }
            }
        });
    }

    protected void updateWebViewSize(Rectangle rectangle, boolean bl) {
        Object object;
        Component component = this.engine.getParentComponent();
        if (component != null) {
            object = component.getLocationOnScreen();
            Dimension dimension = component.getSize();
            if (rectangle.isEmpty()) {
                Window window = SwingUtilities.windowForComponent(component);
                Point point = window.getLocationOnScreen();
                int n = ((Point)object).y;
                int n2 = ((Point)object).x + ((Point)object).y - point.y;
                rectangle.setLocation(n2, n);
                rectangle.setSize(dimension);
            } else if (bl) {
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                boolean bl2 = dimension.height + ((Point)object).y > dimension2.height;
                int n = rectangle.y = !bl2 ? ((Point)object).y : 0;
            }
        }
        if ((object = this.engine.getWebBrowserWindow()) != null) {
            object.setBounds(rectangle);
        }
    }

    protected void fireTitleChangeEvent(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BrowserEvent browserEvent = new BrowserEvent(string);
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    browserListener.onTitleChange(browserEvent);
                }
            }
        });
    }

    protected void fireDownloadComplete(final long l, final String string) {
        final String string2 = this.engine.getLocationURL();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BrowserEvent browserEvent = new BrowserEvent(null, null, string2, new StatusCode(l, string));
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    try {
                        browserListener.onDownloadComplete(browserEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                Events.this.setReady(true);
            }
        });
    }

    protected void fireDownloadBegin() {
        this.setReady(false);
        final String string = this.engine.getLocationURL();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BrowserEvent browserEvent = new BrowserEvent(null, null, string, null);
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    browserListener.onDownloadBegin(browserEvent);
                }
            }
        });
    }

    protected void fireStatusChanged(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BrowserEvent browserEvent = new BrowserEvent(null, string, null, null);
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    browserListener.onStatusChange(browserEvent);
                }
            }
        });
    }

    protected void fireNavigationErrorOccurred(long l, String string) {
        final BrowserEvent browserEvent = new BrowserEvent(null, null, this.engine.getLocationURL(), new StatusCode(l, string));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    browserListener.onNavigationErrorOccurred(browserEvent);
                }
            }
        });
    }

    protected void fireProgressChanged(final long l) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (BrowserListener browserListener : Events.this.getBrowserListeners()) {
                    browserListener.onProgressChanged(l);
                }
            }
        });
    }

    protected void showWindow(final Safari safari) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WebBrowserWindow webBrowserWindow;
                if (Events.this.windowCreator != null && (webBrowserWindow = Events.this.windowCreator.createWindow()) != null) {
                    safari.setWebBrowserWindow(webBrowserWindow);
                    safari.setParentComponent(Events.this.engine.getComponent());
                    webBrowserWindow.createWindow(safari);
                }
            }
        });
    }

    protected void showCertificate(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Events.this.dialogCreator != null) {
                    Events.this.showDialog(Events.this.dialogCreator.createCertificate(string));
                    if (Events.this.lastDialogResult.getAction() == DialogAction.OK) {
                        Events.this.engine.navigate(string, true, 0);
                    }
                }
            }
        });
    }

    protected void showAlert(final String string) {
        this.engine.lock();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Events.this.dialogCreator != null) {
                    Events.this.showDialog(Events.this.dialogCreator.createAlert(string));
                }
                Events.this.engine.unlock();
            }
        });
    }

    protected void showConfirmation(final String string) {
        this.engine.lock();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Events.this.dialogCreator != null) {
                    Events.this.showDialog(Events.this.dialogCreator.createConfirmation(string));
                }
                Events.this.engine.unlock();
            }
        });
    }

    protected void showPrompt(final String string, final String string2) {
        this.engine.lock();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Events.this.dialogCreator != null) {
                    Events.this.showDialog(Events.this.dialogCreator.createPrompt(string, string2));
                }
                Events.this.engine.unlock();
            }
        });
    }

    private void showDialog(WebBrowserDialog webBrowserDialog) {
        DialogAction dialogAction;
        if (webBrowserDialog != null && (dialogAction = webBrowserDialog.showDialog(this.engine.getComponent())) != null) {
            this.lastDialogResult = new DialogResult(dialogAction, webBrowserDialog);
        }
    }

    public void dispose() {
        this.domEventHandler = null;
        this.browserListeners.clear();
    }
}

