/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

class LineNumberList
extends AbstractGutterComponent
implements MouseInputListener {
    private int currentLine;
    private int lastY = -1;
    private int cellHeight;
    private int cellWidth;
    private int ascent;
    private Map aaHints;
    private int mouseDragStartOffset;
    private Listener l;
    private Insets textAreaInsets;
    private Rectangle visibleRect;
    private int lineNumberingStartIndex;

    public LineNumberList(RTextArea rTextArea) {
        this(rTextArea, Color.GRAY);
    }

    public LineNumberList(RTextArea rTextArea, Color color) {
        super(rTextArea);
        if (color != null) {
            this.setForeground(color);
        } else {
            this.setForeground(Color.GRAY);
        }
        this.currentLine = 0;
        this.setLineNumberingStartIndex(1);
        this.visibleRect = new Rectangle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.aaHints = RSyntaxUtilities.getDesktopAntiAliasHints();
    }

    public void addNotify() {
        super.addNotify();
        if (this.textArea != null) {
            this.l.install(this.textArea);
        }
        this.updateCellWidths();
        this.updateCellHeights();
    }

    public int getLineNumberingStartIndex() {
        return this.lineNumberingStartIndex;
    }

    public Dimension getPreferredSize() {
        int n = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.cellWidth, n);
    }

    private int getRhsBorderWidth() {
        int n = 4;
        if (this.textArea instanceof RSyntaxTextArea && ((RSyntaxTextArea)this.textArea).isCodeFoldingEnabled()) {
            n = 0;
        }
        return n;
    }

    void handleDocumentEvent(DocumentEvent documentEvent) {
        int n;
        int n2 = n = this.textArea != null ? this.textArea.getLineCount() : 0;
        if (n != this.currentLineCount) {
            if (n / 10 != this.currentLineCount / 10) {
                this.updateCellWidths();
            }
            this.currentLineCount = n;
            this.repaint();
        }
    }

    void lineHeightsChanged() {
        this.updateCellHeights();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (this.mouseDragStartOffset > -1 && (n = this.textArea.viewToModel(new Point(0, mouseEvent.getY()))) >= 0) {
            this.textArea.setCaretPosition(this.mouseDragStartOffset);
            this.textArea.moveCaretPosition(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.textArea == null) {
            return;
        }
        if (mouseEvent.getButton() == 1) {
            int n = this.textArea.viewToModel(new Point(0, mouseEvent.getY()));
            if (n >= 0) {
                this.textArea.setCaretPosition(n);
            }
            this.mouseDragStartOffset = n;
        } else {
            this.mouseDragStartOffset = -1;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        Color color = this.getBackground();
        if (this.getGutter() != null) {
            color = this.getGutter().getBackground();
        }
        graphics.setColor(color);
        graphics.fillRect(0, this.visibleRect.y, this.cellWidth, this.visibleRect.height);
        graphics.setFont(this.getFont());
        if (this.aaHints != null) {
            ((Graphics2D)graphics).addRenderingHints(this.aaHints);
        }
        if (this.textArea.getLineWrap()) {
            this.paintWrappedLineNumbers(graphics, this.visibleRect);
            return;
        }
        int n = this.visibleRect.y / this.cellHeight;
        int n2 = n * this.cellHeight;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        int n3 = (n2 += this.textAreaInsets.top) + this.ascent;
        FoldManager foldManager = null;
        if (this.textArea instanceof RSyntaxTextArea) {
            foldManager = ((RSyntaxTextArea)this.textArea).getFoldManager();
            n += foldManager.getHiddenLineCountAbove(n, true);
        }
        int n4 = this.getRhsBorderWidth();
        graphics.setColor(this.getForeground());
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (bl) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = this.getWidth() - n4;
            for (int i = n + 1; n3 < this.visibleRect.y + this.visibleRect.height + this.ascent && i <= this.textArea.getLineCount(); ++i) {
                int n6;
                String string = Integer.toString(i + this.getLineNumberingStartIndex() - 1);
                int n7 = fontMetrics.stringWidth(string);
                graphics.drawString(string, n5 - n7, n3);
                n3 += this.cellHeight;
                Fold fold = foldManager.getFoldForLine(i - 1);
                while (fold != null && fold.isCollapsed() && (n6 = fold.getLineCount()) != 0) {
                    fold = foldManager.getFoldForLine((i += n6) - 1);
                }
            }
        } else {
            for (int i = n + 1; n3 < this.visibleRect.y + this.visibleRect.height && i < this.textArea.getLineCount(); ++i) {
                String string = Integer.toString(i + this.getLineNumberingStartIndex() - 1);
                graphics.drawString(string, n4, n3);
                n3 += this.cellHeight;
                Fold fold = foldManager.getFoldForLine(i - 1);
                while (fold != null && fold.isCollapsed()) {
                    fold = foldManager.getFoldForLine(i += fold.getLineCount());
                }
            }
        }
    }

    private void paintWrappedLineNumbers(Graphics graphics, Rectangle rectangle) {
        int n = this.getWidth();
        RTextAreaUI rTextAreaUI = (RTextAreaUI)this.textArea.getUI();
        View view = rTextAreaUI.getRootView(this.textArea).getView(0);
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementCount();
        int n3 = this.textArea.viewToModel(new Point(rectangle.x, rectangle.y));
        int n4 = element.getElementIndex(n3);
        FoldManager foldManager = ((RSyntaxTextArea)this.textArea).getFoldManager();
        Rectangle rectangle2 = rTextAreaUI.getVisibleEditorRect();
        Rectangle rectangle3 = LineNumberList.getChildViewBounds(view, n4, rectangle2);
        int n5 = rectangle3.y;
        int n6 = this.getRhsBorderWidth();
        boolean bl = this.getComponentOrientation().isLeftToRight();
        int n7 = bl ? n - n6 : n6;
        int n8 = rectangle.y + rectangle.height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(this.getForeground());
        while (n5 < n8) {
            int n9;
            rectangle3 = LineNumberList.getChildViewBounds(view, n4, rectangle2);
            int n10 = n4 + 1 + this.getLineNumberingStartIndex() - 1;
            String string = Integer.toString(n10);
            if (bl) {
                n9 = fontMetrics.stringWidth(string);
                graphics.drawString(string, n7 - n9, n5 + this.ascent);
            } else {
                n9 = n6;
                graphics.drawString(string, n9, n5 + this.ascent);
            }
            n5 += rectangle3.height;
            Fold fold = foldManager.getFoldForLine(n4);
            if (fold != null && fold.isCollapsed()) {
                n4 += fold.getCollapsedLineCount();
            }
            if (++n4 < n2) continue;
            break;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.textArea != null) {
            this.l.uninstall(this.textArea);
        }
    }

    private void repaintLine(int n) {
        int n2 = this.textArea.getInsets().top;
        this.repaint(0, n2 += n * this.cellHeight, this.cellWidth, this.cellHeight);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateCellWidths();
        this.updateCellHeights();
    }

    public void setLineNumberingStartIndex(int n) {
        this.lineNumberingStartIndex = n;
    }

    public void setTextArea(RTextArea rTextArea) {
        if (this.l == null) {
            this.l = new Listener();
        }
        if (this.textArea != null) {
            this.l.uninstall(rTextArea);
        }
        super.setTextArea(rTextArea);
        if (rTextArea != null) {
            this.l.install(rTextArea);
            this.updateCellHeights();
            this.updateCellWidths();
        }
    }

    private void updateCellHeights() {
        if (this.textArea != null) {
            this.cellHeight = this.textArea.getLineHeight();
            this.ascent = this.textArea.getMaxAscent();
        } else {
            this.cellHeight = 20;
            this.ascent = 5;
        }
        this.repaint();
    }

    void updateCellWidths() {
        Font font;
        int n = this.cellWidth;
        this.cellWidth = this.getRhsBorderWidth();
        if (this.textArea != null && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n2 = 0;
            int n3 = this.textArea.getLineCount();
            while (n3 >= 10) {
                n3 /= 10;
                ++n2;
            }
            this.cellWidth += fontMetrics.charWidth('9') * (n2 + 1) + 5;
        }
        if (this.cellWidth != n) {
            this.revalidate();
        }
    }

    private class Listener
    implements CaretListener,
    PropertyChangeListener {
        private boolean installed;

        private Listener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n = LineNumberList.this.textArea.getCaretPosition();
            if (!LineNumberList.this.textArea.getLineWrap()) {
                int n2 = LineNumberList.this.textArea.getDocument().getDefaultRootElement().getElementIndex(n);
                if (LineNumberList.this.currentLine != n2) {
                    LineNumberList.this.repaintLine(n2);
                    LineNumberList.this.repaintLine(LineNumberList.this.currentLine);
                    LineNumberList.this.currentLine = n2;
                }
            } else {
                try {
                    int n3 = LineNumberList.this.textArea.yForLineContaining(n);
                    if (n3 != LineNumberList.this.lastY) {
                        LineNumberList.this.lastY = n3;
                        LineNumberList.this.currentLine = LineNumberList.this.textArea.getDocument().getDefaultRootElement().getElementIndex(n);
                        LineNumberList.this.repaint();
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public void install(RTextArea rTextArea) {
            if (!this.installed) {
                rTextArea.addCaretListener(this);
                rTextArea.addPropertyChangeListener(this);
                this.caretUpdate(null);
                this.installed = true;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RTA.currentLineHighlight".equals(string) || "RTA.currentLineHighlightColor".equals(string)) {
                LineNumberList.this.repaintLine(LineNumberList.this.currentLine);
            }
        }

        public void uninstall(RTextArea rTextArea) {
            if (this.installed) {
                rTextArea.removeCaretListener(this);
                rTextArea.removePropertyChangeListener(this);
                this.installed = false;
            }
        }
    }
}

