/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrDict;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagCheckImpl;
import org.w3c.tidy.TagId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagTable {
    public static final Dict XML_TAGS = new Dict(TagId.UNKNOWN, null, 65536, null, 8, null, null);
    private static final Dict[] TAGS = new Dict[]{new Dict(TagId.UNKNOWN, "unknown!", 0, null, 0, null, null), new Dict(TagId.A, "a", 8191, AttrDict.A, 16, ParserImpl.INLINE, null), new Dict(TagId.ABBR, "abbr", 8188, AttrDict.ABBR, 16, ParserImpl.INLINE, null), new Dict(TagId.ACRONYM, "acronym", 8188, AttrDict.ACRONYM, 16, ParserImpl.INLINE, null), new Dict(TagId.ADDRESS, "address", 8191, AttrDict.ADDRESS, 8, ParserImpl.INLINE, null), new Dict(TagId.APPLET, "applet", 1754, AttrDict.APPLET, 71696, ParserImpl.BLOCK, null), new Dict(TagId.AREA, "area", 4094, AttrDict.AREA, 9, ParserImpl.EMPTY, TagCheckImpl.AREA), new Dict(TagId.B, "b", 4095, AttrDict.B, 16, ParserImpl.INLINE, null), new Dict(TagId.BASE, "base", 8191, AttrDict.BASE, 5, ParserImpl.EMPTY, null), new Dict(TagId.BASEFONT, "basefont", 1754, AttrDict.BASEFONT, 17, ParserImpl.EMPTY, null), new Dict(TagId.BDO, "bdo", 4092, AttrDict.BDO, 16, ParserImpl.INLINE, null), new Dict(TagId.BIG, "big", 4094, AttrDict.BIG, 16, ParserImpl.INLINE, null), new Dict(TagId.BLOCKQUOTE, "blockquote", 8191, AttrDict.BLOCKQUOTE, 8, ParserImpl.BLOCK, null), new Dict(TagId.BODY, "body", 8191, AttrDict.BODY, 0x208002, ParserImpl.BODY, null), new Dict(TagId.BR, "br", 8191, AttrDict.BR, 17, ParserImpl.EMPTY, null), new Dict(TagId.BUTTON, "button", 4092, AttrDict.BUTTON, 16, ParserImpl.BLOCK, null), new Dict(TagId.CAPTION, "caption", 8190, AttrDict.CAPTION, 128, ParserImpl.INLINE, TagCheckImpl.CAPTION), new Dict(TagId.CENTER, "center", 1754, AttrDict.CENTER, 8, ParserImpl.BLOCK, null), new Dict(TagId.CITE, "cite", 8191, AttrDict.CITE, 16, ParserImpl.INLINE, null), new Dict(TagId.CODE, "code", 8191, AttrDict.CODE, 16, ParserImpl.INLINE, null), new Dict(TagId.COL, "col", 4092, AttrDict.COL, 129, ParserImpl.EMPTY, null), new Dict(TagId.COLGROUP, "colgroup", 4092, AttrDict.COLGROUP, 32896, ParserImpl.COLGROUP, null), new Dict(TagId.DD, "dd", 8191, AttrDict.DD, 294976, ParserImpl.BLOCK, null), new Dict(TagId.DEL, "del", 4092, AttrDict.DEL, 131096, ParserImpl.INLINE, null), new Dict(TagId.DFN, "dfn", 8190, AttrDict.DFN, 16, ParserImpl.INLINE, null), new Dict(TagId.DIR, "dir", 1755, AttrDict.DIR, 524296, ParserImpl.LIST, null), new Dict(TagId.DIV, "div", 8190, AttrDict.DIV, 8, ParserImpl.BLOCK, null), new Dict(TagId.DL, "dl", 8191, AttrDict.DL, 8, ParserImpl.DEFLIST, null), new Dict(TagId.DT, "dt", 8191, AttrDict.DT, 294976, ParserImpl.INLINE, null), new Dict(TagId.EM, "em", 8191, AttrDict.EM, 16, ParserImpl.INLINE, null), new Dict(TagId.FIELDSET, "fieldset", 4092, AttrDict.FIELDSET, 8, ParserImpl.BLOCK, null), new Dict(TagId.FONT, "font", 1754, AttrDict.FONT, 16, ParserImpl.INLINE, null), new Dict(TagId.FORM, "form", 8191, AttrDict.FORM, 8, ParserImpl.BLOCK, TagCheckImpl.FORM), new Dict(TagId.FRAME, "frame", 1168, AttrDict.FRAME, 8193, ParserImpl.EMPTY, null), new Dict(TagId.FRAMESET, "frameset", 1168, AttrDict.FRAMESET, 8194, ParserImpl.FRAMESET, null), new Dict(TagId.H1, "h1", 8191, AttrDict.H1, 16392, ParserImpl.INLINE, null), new Dict(TagId.H2, "h2", 8191, AttrDict.H2, 16392, ParserImpl.INLINE, null), new Dict(TagId.H3, "h3", 8191, AttrDict.H3, 16392, ParserImpl.INLINE, null), new Dict(TagId.H4, "h4", 8191, AttrDict.H4, 16392, ParserImpl.INLINE, null), new Dict(TagId.H5, "h5", 8191, AttrDict.H5, 16392, ParserImpl.INLINE, null), new Dict(TagId.H6, "h6", 8191, AttrDict.H6, 16392, ParserImpl.INLINE, null), new Dict(TagId.HEAD, "head", 8191, AttrDict.HEAD, 0x208002, ParserImpl.HEAD, null), new Dict(TagId.HR, "hr", 4095, AttrDict.HR, 9, ParserImpl.EMPTY, null), new Dict(TagId.HTML, "html", 8191, AttrDict.HTML, 0x208002, ParserImpl.HTML, TagCheckImpl.HTML), new Dict(TagId.I, "i", 4095, AttrDict.I, 16, ParserImpl.INLINE, null), new Dict(TagId.IFRAME, "iframe", 1752, AttrDict.IFRAME, 16, ParserImpl.BLOCK, null), new Dict(TagId.IMG, "img", 8191, AttrDict.IMG, 65553, ParserImpl.EMPTY, TagCheckImpl.IMG), new Dict(TagId.INPUT, "input", 8191, AttrDict.INPUT, 65553, ParserImpl.EMPTY, null), new Dict(TagId.INS, "ins", 4092, AttrDict.INS, 131096, ParserImpl.INLINE, null), new Dict(TagId.ISINDEX, "isindex", 1755, AttrDict.ISINDEX, 9, ParserImpl.EMPTY, null), new Dict(TagId.KBD, "kbd", 8191, AttrDict.KBD, 16, ParserImpl.INLINE, null), new Dict(TagId.LABEL, "label", 8188, AttrDict.LABEL, 16, ParserImpl.INLINE, null), new Dict(TagId.LEGEND, "legend", 4092, AttrDict.LEGEND, 16, ParserImpl.INLINE, null), new Dict(TagId.LI, "li", 8191, AttrDict.LI, 294944, ParserImpl.BLOCK, null), new Dict(TagId.LINK, "link", 8191, AttrDict.LINK, 5, ParserImpl.EMPTY, TagCheckImpl.LINK), new Dict(TagId.LISTING, "listing", 3, AttrDict.LISTING, 524296, ParserImpl.PRE, null), new Dict(TagId.MAP, "map", 4094, AttrDict.MAP, 16, ParserImpl.BLOCK, null), new Dict(TagId.MENU, "menu", 1755, AttrDict.MENU, 524296, ParserImpl.LIST, null), new Dict(TagId.META, "meta", 8191, AttrDict.META, 5, ParserImpl.EMPTY, TagCheckImpl.META), new Dict(TagId.NOFRAMES, "noframes", 1752, AttrDict.NOFRAMES, 8200, ParserImpl.NOFRAMES, null), new Dict(TagId.NOSCRIPT, "noscript", 4092, AttrDict.NOSCRIPT, 131096, ParserImpl.BLOCK, null), new Dict(TagId.OBJECT, "object", 8188, AttrDict.OBJECT, 71700, ParserImpl.BLOCK, null), new Dict(TagId.OL, "ol", 8191, AttrDict.OL, 8, ParserImpl.LIST, null), new Dict(TagId.OPTGROUP, "optgroup", 4092, AttrDict.OPTGROUP, 33792, ParserImpl.OPTGROUP, null), new Dict(TagId.OPTION, "option", 8191, AttrDict.OPTION, 33792, ParserImpl.TEXT, null), new Dict(TagId.P, "p", 8191, AttrDict.P, 32776, ParserImpl.INLINE, null), new Dict(TagId.PARAM, "param", 8190, AttrDict.PARAM, 17, ParserImpl.EMPTY, null), new Dict(TagId.PLAINTEXT, "plaintext", 3, AttrDict.PLAINTEXT, 524296, ParserImpl.PRE, null), new Dict(TagId.PRE, "pre", 8191, AttrDict.PRE, 8, ParserImpl.PRE, null), new Dict(TagId.Q, "q", 8188, AttrDict.Q, 16, ParserImpl.INLINE, null), new Dict(TagId.RB, "rb", 2048, AttrDict.RB, 16, ParserImpl.INLINE, null), new Dict(TagId.RBC, "rbc", 2048, AttrDict.RBC, 16, ParserImpl.INLINE, null), new Dict(TagId.RP, "rp", 2048, AttrDict.RP, 16, ParserImpl.INLINE, null), new Dict(TagId.RT, "rt", 2048, AttrDict.RT, 16, ParserImpl.INLINE, null), new Dict(TagId.RTC, "rtc", 2048, AttrDict.RTC, 16, ParserImpl.INLINE, null), new Dict(TagId.RUBY, "ruby", 2048, AttrDict.RUBY, 16, ParserImpl.INLINE, null), new Dict(TagId.S, "s", 1752, AttrDict.S, 16, ParserImpl.INLINE, null), new Dict(TagId.SAMP, "samp", 8191, AttrDict.SAMP, 16, ParserImpl.INLINE, null), new Dict(TagId.SCRIPT, "script", 4094, AttrDict.SCRIPT, 131100, ParserImpl.SCRIPT, TagCheckImpl.SCRIPT), new Dict(TagId.SELECT, "select", 8191, AttrDict.SELECT, 1040, ParserImpl.SELECT, null), new Dict(TagId.SMALL, "small", 4094, AttrDict.SMALL, 16, ParserImpl.INLINE, null), new Dict(TagId.SPAN, "span", 8188, AttrDict.SPAN, 16, ParserImpl.INLINE, null), new Dict(TagId.STRIKE, "strike", 1754, AttrDict.STRIKE, 16, ParserImpl.INLINE, null), new Dict(TagId.STRONG, "strong", 8191, AttrDict.STRONG, 16, ParserImpl.INLINE, null), new Dict(TagId.STYLE, "style", 4094, AttrDict.STYLE, 4, ParserImpl.SCRIPT, TagCheckImpl.STYLE), new Dict(TagId.SUB, "sub", 4094, AttrDict.SUB, 16, ParserImpl.INLINE, null), new Dict(TagId.SUP, "sup", 4094, AttrDict.SUP, 16, ParserImpl.INLINE, null), new Dict(TagId.TABLE, "table", 8190, AttrDict.TABLE, 8, ParserImpl.TABLETAG, TagCheckImpl.TABLE), new Dict(TagId.TBODY, "tbody", 4092, AttrDict.TBODY, 33152, ParserImpl.ROWGROUP, null), new Dict(TagId.TD, "td", 8190, AttrDict.TD, 295424, ParserImpl.BLOCK, null), new Dict(TagId.TEXTAREA, "textarea", 8191, AttrDict.TEXTAREA, 1040, ParserImpl.TEXT, null), new Dict(TagId.TFOOT, "tfoot", 4092, AttrDict.TFOOT, 33152, ParserImpl.ROWGROUP, null), new Dict(TagId.TH, "th", 8190, AttrDict.TH, 295424, ParserImpl.BLOCK, null), new Dict(TagId.THEAD, "thead", 4092, AttrDict.THEAD, 33152, ParserImpl.ROWGROUP, null), new Dict(TagId.TITLE, "title", 8191, AttrDict.TITLE, 4, ParserImpl.TITLE, null), new Dict(TagId.TR, "tr", 8190, AttrDict.TR, 32896, ParserImpl.ROW, null), new Dict(TagId.TT, "tt", 4095, AttrDict.TT, 16, ParserImpl.INLINE, null), new Dict(TagId.U, "u", 1754, AttrDict.U, 16, ParserImpl.INLINE, null), new Dict(TagId.UL, "ul", 8191, AttrDict.UL, 8, ParserImpl.LIST, null), new Dict(TagId.VAR, "var", 8191, AttrDict.VAR, 16, ParserImpl.INLINE, null), new Dict(TagId.XMP, "xmp", 3, AttrDict.XMP, 524296, ParserImpl.PRE, null), new Dict(TagId.NEXTID, "nextid", 1, AttrDict.NEXTID, 5, ParserImpl.EMPTY, null), new Dict(TagId.ALIGN, "align", 16384, null, 8, ParserImpl.BLOCK, null), new Dict(TagId.BGSOUND, "bgsound", 32768, null, 5, ParserImpl.EMPTY, null), new Dict(TagId.BLINK, "blink", 57344, null, 16, ParserImpl.INLINE, null), new Dict(TagId.COMMENT, "comment", 32768, null, 16, ParserImpl.INLINE, null), new Dict(TagId.EMBED, "embed", 16384, null, 65553, ParserImpl.EMPTY, null), new Dict(TagId.ILAYER, "ilayer", 16384, null, 16, ParserImpl.INLINE, null), new Dict(TagId.KEYGEN, "keygen", 16384, null, 17, ParserImpl.EMPTY, null), new Dict(TagId.LAYER, "layer", 16384, null, 8, ParserImpl.BLOCK, null), new Dict(TagId.MARQUEE, "marquee", 32768, null, 32784, ParserImpl.INLINE, null), new Dict(TagId.MULTICOL, "multicol", 16384, null, 8, ParserImpl.BLOCK, null), new Dict(TagId.NOBR, "nobr", 57344, null, 16, ParserImpl.INLINE, null), new Dict(TagId.NOEMBED, "noembed", 16384, null, 16, ParserImpl.INLINE, null), new Dict(TagId.NOLAYER, "nolayer", 16384, null, 131096, ParserImpl.BLOCK, null), new Dict(TagId.NOSAVE, "nosave", 16384, null, 8, ParserImpl.BLOCK, null), new Dict(TagId.SERVER, "server", 16384, null, 131100, ParserImpl.SCRIPT, null), new Dict(TagId.SERVLET, "servlet", 8192, null, 71696, ParserImpl.BLOCK, null), new Dict(TagId.SPACER, "spacer", 16384, null, 17, ParserImpl.EMPTY, null), new Dict(TagId.WBR, "wbr", 57344, null, 17, ParserImpl.EMPTY, null)};
    protected Map<String, Node> anchorMap = new HashMap<String, Node>();
    protected Map<Node, String> anchorByNode = new HashMap<Node, String>();
    private Configuration configuration;
    private Map<String, Dict> tagHashtable = new Hashtable<String, Dict>();

    protected TagTable() {
        for (int i = 0; i < TAGS.length; ++i) {
            this.install(TAGS[i]);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Dict lookup(String name) {
        return this.tagHashtable.get(name);
    }

    public Dict lookup(TagId tid) {
        if (tid == TagId.UNKNOWN) {
            return null;
        }
        for (Dict np : this.tagHashtable.values()) {
            if (np.id != tid) continue;
            return np;
        }
        return null;
    }

    public Dict install(Dict dict) {
        Dict d = this.tagHashtable.get(dict.name);
        if (d != null) {
            d.versions = dict.versions;
            d.model |= dict.model;
            d.setParser(dict.getParser());
            d.setChkattrs(dict.getChkattrs());
            return d;
        }
        this.tagHashtable.put(dict.name, dict);
        return dict;
    }

    public boolean findTag(Node node) {
        Dict np;
        if (this.configuration != null && this.configuration.isXmlTags()) {
            node.tag = XML_TAGS;
            return true;
        }
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            node.tag = np;
            return true;
        }
        return false;
    }

    public Parser findParser(Node node) {
        Dict np;
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            return np.getParser();
        }
        return null;
    }

    public void defineTag(short tagType, String name) {
        Parser tagParser;
        int model;
        switch (tagType) {
            case 4: {
                model = 1310728;
                tagParser = ParserImpl.BLOCK;
                break;
            }
            case 1: {
                model = 0x140001;
                tagParser = ParserImpl.BLOCK;
                break;
            }
            case 8: {
                model = 1310728;
                tagParser = ParserImpl.PRE;
                break;
            }
            default: {
                model = 0x140010;
                tagParser = ParserImpl.INLINE;
            }
        }
        this.install(new Dict(TagId.UNKNOWN, name, 57344, null, model, tagParser, null));
    }

    List<String> findAllDefinedTag(short tagType) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Dict curDictEntry : this.tagHashtable.values()) {
            if (curDictEntry == null) continue;
            switch (tagType) {
                case 1: {
                    if (curDictEntry.versions != 57344 || (curDictEntry.model & 1) != 1 || curDictEntry.id == TagId.WBR) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 2: {
                    if (curDictEntry.versions != 57344 || (curDictEntry.model & 0x10) != 16 || curDictEntry.id == TagId.BLINK || curDictEntry.id == TagId.NOBR || curDictEntry.id == TagId.WBR) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 4: {
                    if (curDictEntry.versions != 57344 || (curDictEntry.model & 8) != 8 || curDictEntry.getParser() != ParserImpl.BLOCK) break;
                    tagNames.add(curDictEntry.name);
                    break;
                }
                case 8: {
                    if (curDictEntry.versions != 57344 || (curDictEntry.model & 8) != 8 || curDictEntry.getParser() != ParserImpl.PRE) break;
                    tagNames.add(curDictEntry.name);
                }
            }
        }
        return tagNames;
    }

    public void freeAttrs(Node node) {
        while (node.attributes != null) {
            AttVal av = node.attributes;
            if ("id".equalsIgnoreCase(av.attribute) || "name".equalsIgnoreCase(av.attribute) && node.isAnchorElement()) {
                this.removeAnchorByNode(node);
            }
            node.attributes = av.next;
        }
    }

    void removeAnchorByNode(Node node) {
        String s = this.anchorByNode.get(node);
        if (s == null) {
            return;
        }
        this.anchorByNode.remove(node);
        this.anchorMap.remove(s);
    }

    void addAnchor(String name, Node node) {
        String s = name.toLowerCase();
        this.anchorMap.put(s, node);
        this.anchorByNode.put(node, s);
    }

    Node getNodeByAnchor(String name) {
        return this.anchorMap.get(name.toLowerCase());
    }

    void freeAnchors() {
        this.anchorMap.clear();
        this.anchorByNode.clear();
    }
}

