/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

public class HTMLTableCellElement
extends HTMLTableComponent {
    private static final long serialVersionUID = -4321684413510290017L;

    public void jsxFunction_setAttribute(String name, String value) {
        if ("noWrap".equals(name) && value != null && this.getBrowserVersion().isIE()) {
            value = "true";
        }
        super.jsxFunction_setAttribute(name, value);
    }

    public int jsxGet_offsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return super.jsxGet_offsetHeight();
        }
        ComputedCSSStyleDeclaration style = this.jsxGet_currentStyle();
        boolean includeBorder = this.getBrowserVersion().isIE();
        return style.getCalculatedHeight(includeBorder, true);
    }

    public int jsxGet_offsetWidth() {
        HtmlTableRow row;
        float w = super.jsxGet_offsetWidth();
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return (int)w;
        }
        ComputedCSSStyleDeclaration style = this.jsxGet_currentStyle();
        if ("collapse".equals(style.jsxGet_borderCollapse()) && (row = this.getRow()) != null) {
            HtmlElement thiz = this.getDomNodeOrDie();
            List<HtmlTableCell> cells = row.getCells();
            boolean ie = this.getBrowserVersion().isIE();
            boolean leftmost = cells.indexOf(thiz) == 0;
            boolean rightmost = cells.indexOf(thiz) == cells.size() - 1;
            w = (float)((double)w - (ie && leftmost ? 0.0 : 0.5) * (double)style.getBorderLeft());
            w = (float)((double)w - (ie && rightmost ? 0.0 : 0.5) * (double)style.getBorderRight());
        }
        return (int)w;
    }

    public Integer jsxGet_cellIndex() {
        HtmlTableCell cell = (HtmlTableCell)this.getDomNodeOrDie();
        HtmlTableRow row = cell.getEnclosingRow();
        if (row == null) {
            return -1;
        }
        return new Integer(row.getCells().indexOf(cell));
    }

    public String jsxGet_abbr() {
        return this.getDomNodeOrDie().getAttribute("abbr");
    }

    public void jsxSet_abbr(String abbr) {
        this.getDomNodeOrDie().setAttribute("abbr", abbr);
    }

    public String jsxGet_axis() {
        return this.getDomNodeOrDie().getAttribute("axis");
    }

    public void jsxSet_axis(String axis) {
        this.getDomNodeOrDie().setAttribute("axis", axis);
    }

    public String jsxGet_bgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    public void jsxSet_bgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    public int jsxGet_colSpan() {
        String s = this.getDomNodeOrDie().getAttribute("colSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public void jsxSet_colSpan(String colSpan) {
        String s;
        try {
            int i = new Double(Double.parseDouble(colSpan)).intValue();
            if (i <= 0) {
                throw new NumberFormatException(colSpan);
            }
            s = String.valueOf(i);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().isIE()) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            s = "1";
        }
        this.getDomNodeOrDie().setAttribute("colSpan", s);
    }

    public int jsxGet_rowSpan() {
        String s = this.getDomNodeOrDie().getAttribute("rowSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public void jsxSet_rowSpan(String rowSpan) {
        String s;
        try {
            int i = new Double(Double.parseDouble(rowSpan)).intValue();
            if (i <= 0) {
                throw new NumberFormatException(rowSpan);
            }
            s = String.valueOf(i);
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().isIE()) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            s = "1";
        }
        this.getDomNodeOrDie().setAttribute("rowSpan", s);
    }

    public boolean jsxGet_noWrap() {
        return this.getDomNodeOrDie().hasAttribute("noWrap");
    }

    public void jsxSet_noWrap(boolean noWrap) {
        if (noWrap) {
            String value = this.getBrowserVersion().isIE() ? "true" : "";
            this.getDomNodeOrDie().setAttribute("noWrap", value);
        } else {
            this.getDomNodeOrDie().removeAttribute("noWrap");
        }
    }

    private HtmlTableRow getRow() {
        DomNode node;
        for (node = this.getDomNodeOrDie(); node != null && !(node instanceof HtmlTableRow); node = node.getParentNode()) {
        }
        return (HtmlTableRow)node;
    }
}

