/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.registry.RegistryEventListener;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.WinRegistry;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RegistryKey
extends Handle {
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647L, "HKEY_CURRENT_USER");
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646L, "HKEY_LOCAL_MACHINE");
    public static final RegistryKey USERS = new RegistryKey(-2147483645L, "HKEY_USERS");
    public static final RegistryKey PERFORMANCE_DATA = new RegistryKey(-2147483644L, "HKEY_PERFORMANCE_DATA");
    public static final RegistryKey CURRENT_CONFIG = new RegistryKey(-2147483643L, "HKEY_CURRENT_CONFIG");
    public static final RegistryKey DYN_DATA = new RegistryKey(-2147483642L, "HKEY_DYN_DATA");
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$registry$RegistryKey == null ? (class$com$jniwrapper$win32$registry$RegistryKey = RegistryKey.class$("com.jniwrapper.win32.registry.RegistryKey")) : class$com$jniwrapper$win32$registry$RegistryKey));
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    static final int DELETE = 65536;
    static final int READ_CONTROL = 131072;
    static final int WRITE_DAC = 262144;
    static final int WRITE_OWNER = 524288;
    static final int SYNCHRONIZE = 0x100000;
    static final int STANDARD_RIGHTS_REQUIRED = 983040;
    static final int STANDARD_RIGHTS_READ = 131072;
    static final int STANDARD_RIGHTS_WRITE = 131072;
    static final int STANDARD_RIGHTS_EXECUTE = 131072;
    static final int STANDARD_RIGHTS_ALL = 0x1F0000;
    static final int SPECIFIC_RIGHTS_ALL = 65535;
    static final int ACCESS_SYSTEM_SECURITY = 0x1000000;
    static final int MAXIMUM_ALLOWED = 0x2000000;
    static final int GENERIC_READ = Integer.MIN_VALUE;
    static final int GENERIC_WRITE = 0x40000000;
    static final int GENERIC_EXECUTE = 0x20000000;
    static final int GENERIC_ALL = 0x10000000;
    static final int KEY_QUERY_VALUE = 1;
    static final int KEY_SET_VALUE = 2;
    static final int KEY_CREATE_SUB_KEY = 4;
    static final int KEY_ENUMERATE_SUB_KEYS = 8;
    static final int KEY_NOTIFY = 16;
    static final int KEY_CREATE_LINK = 32;
    static final int KEY_READ = 131097;
    static final int KEY_WRITE = 131078;
    static final int KEY_EXECUTE = 131097;
    static final int KEY_ALL_ACCESS = 983103;
    static final int KEY_WOW64_64KEY = 256;
    static final int KEY_WOW64_32KEY = 512;
    static final int REG_OPTION_RESERVED = 0;
    static final int REG_OPTION_NON_VOLATILE = 0;
    static final int REG_OPTION_VOLATILE = 1;
    static final int REG_OPTION_CREATE_LINK = 2;
    static final int REG_OPTION_BACKUP_RESTORE = 4;
    static final int REG_OPTION_OPEN_LINK = 8;
    static final int REG_LEGAL_OPTION = 15;
    static final int NO_ERROR = 0;
    static final int ERROR_FILE_NOT_FOUND = 2;
    static final long REG_CREATED_NEW_KEY = 1L;
    static final long REG_OPENED_EXISTING_KEY = 2L;
    static final int MAX_PATH = 260;
    private String _path = "";
    private String _name = "";
    private RegistryKey _rootKey;
    private int _errorCode = 0;
    private RegistryKeyValues _keyValues;
    private boolean _listening = false;
    private List _registryEventListeners = new LinkedList();
    private RegistryAccessMode _registryAccessMode = RegistryAccessMode.DEFAULT;
    static /* synthetic */ Class class$com$jniwrapper$win32$registry$RegistryKey;

    private RegistryKey() {
    }

    private RegistryKey(long value) {
        super(value);
    }

    private RegistryKey(long key, String name) {
        super(key);
        this._name = name;
        this._rootKey = new RegistryKey(this.getValue());
    }

    public RegistryAccessMode getRegistryAccessMode() {
        return this._registryAccessMode;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public String getAbsolutePath() {
        String path = this.getPath();
        StringBuffer result = new StringBuffer(path);
        if (path.length() > 0 && !path.endsWith("\\")) {
            result.append('\\');
        }
        result.append(this.getName());
        return result.toString();
    }

    protected void checkError() {
        if (this._errorCode != 0) {
            throw new RegistryException(this._errorCode);
        }
    }

    protected void checkError(long errorCode) {
        this._errorCode = (int)errorCode;
        this.checkError();
    }

    public int getSubKeyCount() {
        UInt32 subKeyCount = new UInt32();
        this.checkError(WinRegistry.queryInfoKey(this, null, null, subKeyCount, null, null, null, null, null));
        int result = (int)subKeyCount.getValue();
        return result;
    }

    public void close() {
        this.checkError(WinRegistry.closeKey(this));
    }

    public RegistryKey createSubKey(String subKey, boolean writable) {
        return this.createSubKey(subKey, writable, RegistryAccessMode.DEFAULT);
    }

    public RegistryKey createSubKey(String subKey, RegistryAccessMode accessMode) {
        return this.createSubKey(subKey, false, accessMode);
    }

    public RegistryKey createSubKey(String subKey, boolean writable, RegistryAccessMode accessMode) {
        RegistryKey result = new RegistryKey();
        result._registryAccessMode = accessMode;
        this.checkError(WinRegistry.createKey(this, subKey, 0L, writable ? (long)(0x2001F | accessMode.getValue()) : (long)(0x20019 | accessMode.getValue()), (Handle)result));
        result._path = this.getAbsolutePath();
        result._name = subKey;
        result._rootKey = this.getRootKey();
        return result;
    }

    public RegistryKey createSubKey(String subKey) {
        return this.createSubKey(subKey, false);
    }

    public void deleteSubKey(String subKey) {
        this.deleteSubKey(subKey, this._registryAccessMode);
    }

    public void deleteSubKey(String subKey, RegistryAccessMode accessMode) {
        this.checkError(WinRegistry.deleteKey(this, subKey, accessMode.getValue()));
    }

    public void deleteSubTree(String subKey) {
        RegistryKey key = this.openSubKey(subKey, true);
        int index = 0;
        Str name = new Str(260);
        LinkedList<String> list = new LinkedList<String>();
        while (WinRegistry.enumKeyEx(key, index++, name, new UInt32(260L), null, null) == 0L) {
            list.add(name.getValue());
        }
        for (int i = 0; i < list.size(); ++i) {
            key.deleteSubTree((String)list.get(i));
        }
        key.close();
        this.deleteSubKey(subKey);
    }

    public void rename(String newName) {
        String absolutePath = this.getAbsolutePath();
        String parent = "";
        try {
            parent = absolutePath.substring(absolutePath.indexOf("\\") + 1, absolutePath.lastIndexOf("\\"));
        }
        catch (Exception e) {
            // empty catch block
        }
        RegistryKey parentKey = this.getRootKey();
        if (parent.length() != 0) {
            parentKey = parentKey.openSubKey(parent);
        }
        RegistryKey target = this.copy(parentKey, newName, false);
        String name = this.getName().lastIndexOf("\\") != -1 ? this.getName().substring(this.getName().lastIndexOf("\\") + 1) : this.getName();
        parentKey.deleteSubTree(name);
        parentKey.close();
        this.setValue(target.getValue());
        this._path = target._path;
        this._name = target._name;
        this._rootKey = target.getRootKey();
    }

    public RegistryKey getRootKey() {
        return this._rootKey;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)((Object)obj);
        return this.getValue() == registryKey.getValue();
    }

    public int hashCode() {
        return (int)this.getValue();
    }

    public void flush() {
        this.checkError(WinRegistry.flushKey(this));
    }

    public List getSubKeyNames() {
        int subKeyCount = this.getSubKeyCount();
        ArrayList<String> result = new ArrayList<String>(subKeyCount);
        if (subKeyCount > 0) {
            RegistryKey handle = this;
            int i = 0;
            int errorCode = 0;
            while (errorCode == 0) {
                Str valueName = new Str("", 260);
                errorCode = (int)WinRegistry.enumKeyEx(handle, i, valueName, new UInt32(260L), null, null);
                if (errorCode == 0) {
                    result.add(valueName.getValue());
                }
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public RegistryKey openSubKey(String name) {
        return this.openSubKey(name, false, false);
    }

    public RegistryKey openSubKey(String name, boolean writable) {
        return this.openSubKey(name, writable, false);
    }

    public RegistryKey openSubKey(String name, boolean writable, boolean quietly) {
        return this.openSubKey(name, writable, quietly, RegistryAccessMode.DEFAULT);
    }

    public RegistryKey openSubKey(String name, boolean writable, boolean quietly, RegistryAccessMode accessMode) {
        RegistryKey result = new RegistryKey();
        result._registryAccessMode = accessMode;
        result._errorCode = (int)WinRegistry.openKey(this, name.startsWith("\\\\") ? name.replaceFirst("\\\\+", "") : name, writable ? 0x2001F | accessMode.getValue() : 0x20019 | accessMode.getValue(), result);
        result._path = this.getAbsolutePath();
        result._name = name;
        result._rootKey = this.getRootKey();
        if (!quietly) {
            result.checkError();
        }
        return result;
    }

    public RegistryKey openSubKey(String name, boolean writable, RegistryAccessMode accessMode) {
        return this.openSubKey(name, writable, false, accessMode);
    }

    public RegistryKey openSubKey(String name, RegistryAccessMode accessMode) {
        return this.openSubKey(name, false, false, accessMode);
    }

    public boolean exists(String name) {
        return this.exists(name, this._registryAccessMode);
    }

    public boolean exists(String name, RegistryAccessMode accessMode) {
        boolean result;
        RegistryKey handle = new RegistryKey();
        this._errorCode = (int)WinRegistry.openKey(this, name, 0x20019 | accessMode.getValue(), handle);
        boolean bl = result = this._errorCode != 2;
        if (result) {
            handle.close();
        }
        return result;
    }

    public RegistryKey copy(RegistryKey newBase, String newName, boolean quietly) {
        if (newBase == null) {
            throw new IllegalArgumentException("newBase parameter cannot be null.");
        }
        if (newName == null) {
            throw new IllegalArgumentException("newName parameter cannot be null.");
        }
        RegistryKey target = new RegistryKey();
        UInt32 disposition = new UInt32();
        RegistryKey hTarget = newBase;
        this.checkError(WinRegistry.createKey(hTarget, newName, 0L, 0x2001F | this._registryAccessMode.getValue(), target, disposition));
        target._path = this._path;
        target._name = newName;
        target._rootKey = this.getRootKey();
        if (disposition.getValue() == 2L && !quietly) {
            throw new RegistryException("The specified registry key already exists.");
        }
        int index = 0;
        Str name = new Str(260);
        while (WinRegistry.enumKeyEx(this, index++, name, new UInt32(260L), null, null) == 0L) {
            this.openSubKey(name.getValue()).copy(newBase, target.getName() + "\\" + name.getValue(), true);
        }
        List srcValues = this.values().getEntries();
        RegistryKeyValues tagValues = target.values();
        for (int i = 0; i < srcValues.size(); ++i) {
            RegistryKeyValues.RegistryValueEntry entry = (RegistryKeyValues.RegistryValueEntry)srcValues.get(i);
            tagValues.put(entry.getKey(), entry.getValue(), entry.getType());
        }
        return target;
    }

    public List getSubkeys() {
        List subkeyNames = this.getSubKeyNames();
        LinkedList<RegistryKey> result = new LinkedList<RegistryKey>();
        Iterator i = subkeyNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            try {
                RegistryKey subkey = this.openSubKey(name);
                result.add(subkey);
            }
            catch (RegistryException e) {
                LOG.error((Object)("Failed to read the registry key " + this.getAbsolutePath() + '\\' + name), (Throwable)e);
                RegistryKey subkey = this.openSubKey(name, false, true);
                result.add(subkey);
            }
        }
        return result;
    }

    public RegistryKeyValues values() {
        this.checkHandle();
        if (this._keyValues == null) {
            this._keyValues = new RegistryKeyValues(this);
        }
        return this._keyValues;
    }

    public Handle getHandle() {
        return this;
    }

    private void checkHandle() {
        if (this.isNull()) {
            this.checkError(WinRegistry.openKey(new Handle(this.getValue()), "", 0x20019 | this._registryAccessMode.getValue(), this));
        }
    }

    public void addRegistryEventListener(RegistryEventListener listener) {
        if (!this._registryEventListeners.contains(listener)) {
            this._registryEventListeners.add(listener);
        }
    }

    public void removeRegistryEventListener(RegistryEventListener listener) {
        this._registryEventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistryEvent(EventObject event) {
        LinkedList listeners;
        RegistryKey registryKey = this;
        synchronized (registryKey) {
            listeners = new LinkedList(this._registryEventListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            RegistryEventListener listener = (RegistryEventListener)i.next();
            listener.handle(event);
        }
    }

    public void startChangeListening(final boolean watchSubtree, final int filter) {
        Thread listener = new Thread(new Runnable(){

            public void run() {
                RegistryKey.this._listening = true;
                while (RegistryKey.this._listening) {
                    RegistryKey.this.checkError(WinRegistry.notifyChangeValue(RegistryKey.this, watchSubtree, filter, new Handle(), false));
                    if (!RegistryKey.this._listening) continue;
                    RegistryKey.this.fireRegistryEvent(new EventObject((Object)RegistryKey.this));
                }
            }
        });
        listener.start();
    }

    public void startChangeListening() {
        int filter = 15;
        this.startChangeListening(true, filter);
    }

    public void stopChangeListening() {
        this._listening = false;
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RegistryAccessMode
    extends EnumItem {
        public static final RegistryAccessMode DEFAULT = new RegistryAccessMode(0);
        public static final RegistryAccessMode WOW64 = new RegistryAccessMode(256);
        public static final RegistryAccessMode WOW32 = new RegistryAccessMode(512);

        private RegistryAccessMode(int value) {
            super(value);
        }
    }
}

