/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.shell.ShellIcon;
import com.jniwrapper.win32.ui.controls.AbstractChooserField;
import com.jniwrapper.win32.ui.dialogs.SelectIconDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ChooseIconField
extends AbstractChooserField {
    public static final String PROPERTY_ICON = "icon";
    private JLabel image;
    private SelectIconDialog _dialog;

    protected JComponent createField() {
        this.image = new JLabel();
        Dimension size = new Dimension(36, 38);
        this.image.setPreferredSize(size);
        this.image.setMinimumSize(size);
        this.image.setMaximumSize(size);
        this.image.setBackground(Color.WHITE);
        this.image.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChooseIconField.this.actionPerformed(null);
                }
            }
        });
        JPanel bevel = new JPanel();
        bevel.setBackground(Color.WHITE);
        bevel.setBorder(BorderFactory.createEtchedBorder());
        bevel.setLayout(new GridBagLayout());
        bevel.add((Component)this.image, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton selectButton = this.getSelectButton();
        selectButton.setBorder(BorderFactory.createEtchedBorder());
        selectButton.setPreferredSize(new Dimension(20, 38));
        return bevel;
    }

    public ChooseIconField() {
    }

    public ChooseIconField(File iconFile) {
        this();
        if (iconFile.exists()) {
            this.setIconImage(new ShellIcon(iconFile));
            this.setIconFile(iconFile);
        }
    }

    public ChooseIconField(File iconFile, int iconIndex) {
        this();
        if (iconFile.exists()) {
            this.setIconImage(new ShellIcon(iconFile, iconIndex));
            this.setIconFile(iconFile);
            this.setIconIndex(iconIndex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        SelectIconDialog dialog = this.getDialog();
        if (dialog.getOwner() == null) {
            dialog.setOwner(SwingUtilities.getWindowAncestor(this));
        }
        String oldIcon = dialog.getIconFile().getAbsolutePath() + Integer.toString(dialog.getIconIndex());
        if (dialog.execute()) {
            this.setIconImage(dialog.getShellIcon());
            String newIcon = dialog.getIconFile().getAbsolutePath() + Integer.toString(dialog.getIconIndex());
            this.firePropertyChange(PROPERTY_ICON, oldIcon, newIcon);
        }
    }

    private void setIconImage(ShellIcon shellIcon) {
        try {
            ShellIcon icon = shellIcon;
            ImageIcon imageIcon = new ImageIcon(icon.toImage());
            this.image.setIcon(imageIcon);
        }
        catch (LastErrorException lastErrorException) {
            // empty catch block
        }
    }

    public void setIconImage(File iconFile, int iconIndex) {
        this.setIconFile(iconFile);
        this.setIconIndex(iconIndex);
        this.setIconImage(this.getShellIcon());
    }

    public SelectIconDialog getDialog() {
        if (this._dialog == null) {
            this._dialog = new SelectIconDialog();
        }
        return this._dialog;
    }

    public void setIconFile(File value) {
        this.getDialog().setIconFile(value);
    }

    public File getIconFile() {
        return this.getDialog().getIconFile();
    }

    public void setIconIndex(int value) {
        this.getDialog().setIconIndex(value);
    }

    public int getIconIndex() {
        return this.getDialog().getIconIndex();
    }

    public ShellIcon getShellIcon() {
        return this.getDialog().getShellIcon();
    }
}

